/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.datamodel;

import java.awt.Color;
import org.esa.beam.dataio.dimap.DimapProductHelpers;
import org.esa.beam.framework.dataio.ProductSubsetDef;
import org.esa.beam.framework.datamodel.Mask;
import org.esa.beam.framework.datamodel.ProductNode;
import org.esa.beam.framework.datamodel.ProductVisitor;
import org.esa.beam.util.Debug;
import org.esa.beam.util.Guardian;
import org.esa.beam.util.ObjectUtils;
import org.esa.beam.util.StringUtils;
import org.esa.beam.util.XmlWriter;
import org.jdom.Element;

@Deprecated
public class BitmaskDef
extends ProductNode {
    public static final String PROPERTY_NAME_COLOR = "color";
    public static final String PROPERTY_NAME_EXPR = "expr";
    public static final String PROPERTY_NAME_TRANSPARENCY = "transparency";
    private static final Color _DEFAULT_COLOR = Color.yellow;
    private String _expr;
    private Color _color;
    private float _transparency;

    public BitmaskDef(String name, String description, String expr, Color color, float transparency) {
        super(name, description);
        this.setExpr(expr);
        this.setColor(color);
        this.setTransparency(transparency);
    }

    public String getExpr() {
        return this._expr;
    }

    public void setExpr(String expr) {
        if (!ObjectUtils.equalObjects(expr, this._expr)) {
            this._expr = expr != null ? expr : "";
            this.fireProductNodeChanged(PROPERTY_NAME_EXPR);
            this.setModified(true);
        }
    }

    @Override
    public void updateExpression(String oldExternalName, String newExternalName) {
        if (this._expr == null) {
            return;
        }
        String expression = StringUtils.replaceWord(this._expr, oldExternalName, newExternalName);
        if (!this._expr.equals(expression)) {
            this._expr = expression;
            this.setModified(true);
        }
        super.updateExpression(oldExternalName, newExternalName);
    }

    public Color getColor() {
        return this._color;
    }

    public void setColor(Color color) {
        if (!ObjectUtils.equalObjects(this._color, color)) {
            this._color = color != null ? color : _DEFAULT_COLOR;
            this.fireProductNodeChanged(PROPERTY_NAME_COLOR);
            this.setModified(true);
        }
    }

    public float getAlpha() {
        return 1.0f - this.getTransparency();
    }

    public float getTransparency() {
        return this._transparency;
    }

    public void setTransparency(float transparency) {
        if (transparency < 0.0f || transparency > 1.0f) {
            throw new IllegalArgumentException("transparency must be >= 0 and <= 1");
        }
        if (this._transparency != transparency) {
            this._transparency = transparency;
            this.fireProductNodeChanged(PROPERTY_NAME_TRANSPARENCY);
            this.setModified(true);
        }
    }

    @Override
    public void acceptVisitor(ProductVisitor visitor) {
        Guardian.assertNotNull("visitor", visitor);
        visitor.visit(this);
    }

    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        BitmaskDef def = (BitmaskDef)object;
        return ObjectUtils.equalObjects(this.getExpr(), def.getExpr()) && ObjectUtils.equalObjects(this.getColor(), def.getColor()) && this.getTransparency() == def.getTransparency();
    }

    public BitmaskDef createCopy() {
        return new BitmaskDef(this.getName(), this.getDescription(), this.getExpr(), this.getColor(), this.getTransparency());
    }

    @Override
    public long getRawStorageSize(ProductSubsetDef subsetDef) {
        return 64 + this._expr.length();
    }

    public void writeXML(XmlWriter writer, int indent) {
        Guardian.assertNotNull("writer", writer);
        Guardian.assertGreaterThan("indent", indent, -1L);
        String[][] attributes = new String[][]{{"name", this.getName()}};
        String[] bdTags = XmlWriter.createTags(indent, "Bitmask_Definition", attributes);
        writer.println(bdTags[0]);
        String description = this.getDescription();
        if (description == null) {
            description = "";
        }
        attributes[0] = new String[]{"value", description};
        writer.printLine(indent + 1, "DESCRIPTION", attributes, null);
        String expr = this.getExpr();
        if (expr == null) {
            expr = "";
        }
        attributes[0] = new String[]{"value", expr};
        writer.printLine(indent + 1, "EXPRESSION", attributes, null);
        DimapProductHelpers.printColorTag(indent + 1, this.getColor(), writer);
        attributes[0] = new String[]{"value", String.valueOf(this.getTransparency())};
        writer.printLine(indent + 1, "TRANSPARENCY", attributes, null);
        writer.println(bdTags[1]);
    }

    public static BitmaskDef createBitmaskDef(Element element) {
        String name = element.getAttributeValue("name");
        String description = null;
        Element descElem = element.getChild("DESCRIPTION");
        if (descElem != null) {
            description = descElem.getAttributeValue("value").trim();
        }
        String expression = element.getChild("EXPRESSION").getAttributeValue("value").trim();
        Color color = DimapProductHelpers.createColor(element.getChild("COLOR"));
        String value = element.getChild("TRANSPARENCY").getAttributeValue("value");
        float transparency = 0.5f;
        try {
            transparency = Float.parseFloat(value);
        }
        catch (NumberFormatException e) {
            Debug.trace(e);
        }
        return new BitmaskDef(name, description, expression, color, transparency);
    }

    @Override
    public void dispose() {
        this._expr = null;
        this._color = null;
        super.dispose();
    }

    public Mask createMask(int width, int height) {
        return Mask.BandMathsType.create(this.getName(), this.getDescription(), width, height, this.getExpr(), this.getColor(), this.getTransparency());
    }
}

