/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.dataio;

import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.core.SubProgressMonitor;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Logger;
import org.esa.beam.framework.dataio.DecodeQualification;
import org.esa.beam.framework.dataio.ProductIOException;
import org.esa.beam.framework.dataio.ProductIOPlugInManager;
import org.esa.beam.framework.dataio.ProductReader;
import org.esa.beam.framework.dataio.ProductReaderPlugIn;
import org.esa.beam.framework.dataio.ProductSubsetDef;
import org.esa.beam.framework.dataio.ProductWriter;
import org.esa.beam.framework.dataio.ProductWriterPlugIn;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.util.Guardian;
import org.esa.beam.util.logging.BeamLogManager;

public class ProductIO {
    public static final String DEFAULT_FORMAT_NAME = "BEAM-DIMAP";
    private static boolean doNotCrop = false;

    public static ProductReader getProductReader(String formatName) {
        ProductIOPlugInManager registry = ProductIOPlugInManager.getInstance();
        Iterator<ProductReaderPlugIn> it = registry.getReaderPlugIns(formatName);
        if (it.hasNext()) {
            ProductReaderPlugIn plugIn = it.next();
            return plugIn.createReaderInstance();
        }
        return null;
    }

    public static String[] getProductWriterExtensions(String formatName) {
        ProductIOPlugInManager registry = ProductIOPlugInManager.getInstance();
        Iterator<ProductWriterPlugIn> it = registry.getWriterPlugIns(formatName);
        if (it.hasNext()) {
            ProductWriterPlugIn plugIn = it.next();
            return plugIn.getDefaultFileExtensions();
        }
        return null;
    }

    public static ProductWriter getProductWriter(String formatName) {
        ProductIOPlugInManager registry = ProductIOPlugInManager.getInstance();
        Iterator<ProductWriterPlugIn> it = registry.getWriterPlugIns(formatName);
        if (it.hasNext()) {
            ProductWriterPlugIn plugIn = it.next();
            return plugIn.createWriterInstance();
        }
        return null;
    }

    public static Product readProduct(File file, String ... formatNames) throws IOException {
        Guardian.assertNotNull("file", file);
        if (!file.exists()) {
            throw new FileNotFoundException("File not found: " + file.getPath());
        }
        ProductIOPlugInManager registry = ProductIOPlugInManager.getInstance();
        String[] stringArray = formatNames;
        int n = formatNames.length;
        int n2 = 0;
        while (n2 < n) {
            ProductReader productReader;
            String formatName = stringArray[n2];
            Iterator<ProductReaderPlugIn> it = registry.getReaderPlugIns(formatName);
            ProductReaderPlugIn selectedPlugIn = null;
            while (it.hasNext()) {
                ProductReaderPlugIn plugIn = it.next();
                DecodeQualification decodeQualification = plugIn.getDecodeQualification(file);
                if (decodeQualification == DecodeQualification.INTENDED) {
                    selectedPlugIn = plugIn;
                    break;
                }
                if (decodeQualification != DecodeQualification.SUITABLE) continue;
                selectedPlugIn = plugIn;
            }
            if (selectedPlugIn != null && (productReader = selectedPlugIn.createReaderInstance()) != null) {
                return productReader.readProductNodes(file, null);
            }
            ++n2;
        }
        return ProductIO.readProductImpl(file, null);
    }

    public static Product readProduct(String filePath) throws IOException {
        return ProductIO.readProductImpl(new File(filePath), null);
    }

    public static Product readProduct(File file) throws IOException {
        return ProductIO.readProductImpl(file, null);
    }

    private static Product readProductImpl(File file, ProductSubsetDef subsetDef) throws IOException {
        Guardian.assertNotNull("file", file);
        if (!file.exists()) {
            throw new FileNotFoundException("File not found: " + file.getPath());
        }
        ProductReader productReader = ProductIO.getProductReaderForInput(file);
        if (productReader != null) {
            return productReader.readProductNodes(file, subsetDef);
        }
        return null;
    }

    @Deprecated
    public static ProductReader getProductReaderForFile(File file) {
        return ProductIO.getProductReaderForInput(file);
    }

    public static ProductReader getProductReaderForInput(Object input) {
        long startTimeTotal = System.currentTimeMillis();
        Logger logger = BeamLogManager.getSystemLogger();
        logger.fine("Searching reader plugin for '" + input + "'");
        ProductIOPlugInManager registry = ProductIOPlugInManager.getInstance();
        Iterator<ProductReaderPlugIn> it = registry.getAllReaderPlugIns();
        Object selectedPlugIn = null;
        while (it.hasNext()) {
            ProductReaderPlugIn plugIn = it.next();
            long startTime = System.currentTimeMillis();
            DecodeQualification decodeQualification = plugIn.getDecodeQualification(input);
            long endTime = System.currentTimeMillis();
            logger.fine(String.format("Checking reader plugin %s (took %d ms)", plugIn.getClass().getName(), endTime - startTime));
            if (decodeQualification == DecodeQualification.INTENDED) {
                selectedPlugIn = plugIn;
                break;
            }
            if (decodeQualification != DecodeQualification.SUITABLE) continue;
            selectedPlugIn = plugIn;
        }
        long endTimeTotal = System.currentTimeMillis();
        logger.fine(String.format("Searching reader plugin took %d ms", endTimeTotal - startTimeTotal));
        if (selectedPlugIn != null) {
            logger.fine("Selected " + selectedPlugIn.getClass().getName());
            return selectedPlugIn.createReaderInstance();
        }
        logger.fine("No suitable reader plugin found");
        return null;
    }

    public static void writeProduct(Product product, String filePath, String formatName) throws IOException {
        ProductIO.writeProduct(product, new File(filePath), formatName, false, ProgressMonitor.NULL);
    }

    public static void writeProduct(Product product, String filePath, String formatName, ProgressMonitor pm) throws IOException {
        ProductIO.writeProduct(product, new File(filePath), formatName, false, pm);
    }

    public static void writeProduct(Product product, File file, String formatName, boolean incremental) throws IOException {
        ProductIO.writeProduct(product, file, formatName, incremental, ProgressMonitor.NULL);
    }

    public static void writeProduct(Product product, File file, String formatName, boolean incremental, ProgressMonitor pm) throws IOException {
        IOException ioException;
        block15: {
            ProductWriter productWriterOld;
            block17: {
                ProductWriter productWriter;
                Guardian.assertNotNull("product", product);
                Guardian.assertNotNull("file", file);
                if (formatName == null) {
                    formatName = DEFAULT_FORMAT_NAME;
                }
                if ((productWriter = ProductIO.getProductWriter(formatName)) == null) {
                    throw new ProductIOException("no product writer for the '" + formatName + "' format available");
                }
                productWriter.setIncrementalMode(incremental);
                productWriterOld = product.getProductWriter();
                product.setProductWriter(productWriter);
                ioException = null;
                try {
                    try {
                        productWriter.writeProductNodes(product, file);
                        ProductIO.writeAllBands(product, pm);
                    }
                    catch (IOException e) {
                        block14: {
                            ioException = e;
                            try {
                                product.closeProductWriter();
                            }
                            catch (IOException e2) {
                                if (ioException != null) break block14;
                                ioException = e2;
                            }
                        }
                        product.setProductWriter(productWriterOld);
                        product.setFileLocation(file);
                        break block15;
                    }
                }
                catch (Throwable throwable) {
                    block16: {
                        try {
                            product.closeProductWriter();
                        }
                        catch (IOException e) {
                            if (ioException != null) break block16;
                            ioException = e;
                        }
                    }
                    product.setProductWriter(productWriterOld);
                    product.setFileLocation(file);
                    throw throwable;
                }
                try {
                    product.closeProductWriter();
                }
                catch (IOException e) {
                    if (ioException != null) break block17;
                    ioException = e;
                }
            }
            product.setProductWriter(productWriterOld);
            product.setFileLocation(file);
        }
        if (ioException != null) {
            throw ioException;
        }
    }

    private static void writeAllBands(Product product, ProgressMonitor pm) throws IOException {
        ProductWriter productWriter = product.getProductWriter();
        ArrayList<Band> bandsToWrite = new ArrayList<Band>();
        int i = 0;
        while (i < product.getNumBands()) {
            Band band = product.getBandAt(i);
            if (productWriter.shouldWrite(band)) {
                bandsToWrite.add(band);
            }
            ++i;
        }
        if (!bandsToWrite.isEmpty()) {
            pm.beginTask("Writing bands of product '" + product.getName() + "'...", bandsToWrite.size());
            try {
                for (Band band : bandsToWrite) {
                    if (pm.isCanceled()) {
                        break;
                    }
                    band.writeRasterDataFully(SubProgressMonitor.create(pm, 1));
                }
            }
            finally {
                pm.done();
            }
        }
    }

    private ProductIO() {
    }

    public static void setDoNotCrop(boolean doNotCrop) {
        ProductIO.doNotCrop = doNotCrop;
    }

    public static boolean getDoNotCrop() {
        return doNotCrop;
    }
}

