/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.geotiff.internal;

import org.esa.beam.dataio.geotiff.internal.TiffValue;
import org.esa.beam.dataio.geotiff.internal.TiffValueRangeChecker;
import org.esa.beam.framework.datamodel.ProductData;

class TiffRational
extends TiffValue {
    private static final int NUMERATOR_INDEX = 0;
    private static final int DENOMINATOR_INDEX = 1;

    public TiffRational(long numerator, long denominator) {
        TiffValueRangeChecker.checkValueTiffRational(numerator, "numerator");
        TiffValueRangeChecker.checkValueTiffRational(denominator, "denominator");
        this.setData(ProductData.createInstance(22, 2));
        this.getData().setElemUIntAt(0, numerator);
        this.getData().setElemUIntAt(1, denominator);
    }

    public long getNumerator() {
        return this.getData().getElemUIntAt(0);
    }

    public long getDenominator() {
        return this.getData().getElemUIntAt(1);
    }

    public double getValue() {
        return this.getNumerator() / this.getDenominator();
    }
}

