/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.geotiff;

import com.sun.media.imageio.plugins.tiff.TIFFField;
import com.sun.media.imageio.plugins.tiff.TIFFTag;
import com.sun.media.imageioimpl.plugins.tiff.TIFFIFD;
import com.sun.media.imageioimpl.plugins.tiff.TIFFImageMetadata;
import java.util.Map;
import java.util.SortedMap;
import org.esa.beam.dataio.geotiff.TiffFileInfo;
import org.esa.beam.dataio.geotiff.internal.GeoKeyEntry;
import org.esa.beam.framework.datamodel.MetadataAttribute;
import org.esa.beam.framework.datamodel.MetadataElement;
import org.esa.beam.framework.datamodel.ProductData;
import org.esa.beam.util.geotiff.EPSGCodes;

class TiffTagToMetadataConverter {
    private static final int[] PROCESSED_GEO_TIFF_TAGS = new int[]{33550, 33922, 34264};

    private TiffTagToMetadataConverter() {
    }

    public static void addTiffTagsToMetadata(TIFFImageMetadata imageMetadata, TiffFileInfo tiffInfo, MetadataElement metadataElem) {
        TIFFField[] tiffFields;
        MetadataElement tiffMetadata = new MetadataElement("TIFF Metadata");
        if (tiffInfo.isGeotiff()) {
            MetadataElement geoTiffMetadata = new MetadataElement("GeoTIFF Metadata");
            TiffTagToMetadataConverter.addGeoTiffTagsToMetadata(tiffInfo, geoTiffMetadata);
            tiffMetadata.addElement(geoTiffMetadata);
        }
        TIFFIFD tiffifd = imageMetadata.getRootIFD();
        TIFFField[] tIFFFieldArray = tiffFields = tiffifd.getTIFFFields();
        int n = tiffFields.length;
        int n2 = 0;
        while (n2 < n) {
            TIFFField tiffField = tIFFFieldArray[n2];
            int tagNumber = tiffField.getTag().getNumber();
            if (tagNumber != 65000 && !TiffTagToMetadataConverter.isGeoTiffTag(tagNumber)) {
                MetadataAttribute attribute = TiffTagToMetadataConverter.generateMetadataAttribute(tiffField);
                tiffMetadata.addAttribute(attribute);
            }
            ++n2;
        }
        metadataElem.addElement(tiffMetadata);
    }

    private static boolean isGeoTiffTag(int tagNumber) {
        return tagNumber == 34735 || tagNumber == 34737 || tagNumber == 34736 || tagNumber == 33550 || tagNumber == 33922 || tagNumber == 34264;
    }

    private static void addGeoTiffTagsToMetadata(TiffFileInfo tiffInfo, MetadataElement geoTiffMetadata) {
        MetadataAttribute attribute;
        TIFFField field = tiffInfo.getField(34735);
        MetadataElement geoKeyDirMetadata = new MetadataElement(field.getTag().getName());
        geoTiffMetadata.addElement(geoKeyDirMetadata);
        SortedMap<Integer, GeoKeyEntry> geoKeyMap = tiffInfo.getGeoKeyEntries();
        for (Map.Entry<Integer, GeoKeyEntry> entry : geoKeyMap.entrySet()) {
            GeoKeyEntry geoKeyEntry = entry.getValue();
            String name = geoKeyEntry.getName();
            ProductData data = TiffTagToMetadataConverter.getGeoKeyValue(geoKeyEntry);
            if (data == null) continue;
            attribute = new MetadataAttribute(name, data, true);
            geoKeyDirMetadata.addAttribute(attribute);
        }
        int[] nArray = PROCESSED_GEO_TIFF_TAGS;
        int n = PROCESSED_GEO_TIFF_TAGS.length;
        int n2 = 0;
        while (n2 < n) {
            int tagNunmber = nArray[n2];
            TIFFField tiffField = tiffInfo.getField(tagNunmber);
            if (tiffField != null) {
                attribute = TiffTagToMetadataConverter.generateMetadataAttribute(tiffField);
                geoTiffMetadata.addAttribute(attribute);
            }
            ++n2;
        }
    }

    private static MetadataAttribute generateMetadataAttribute(TIFFField tiffField) {
        TIFFTag geoTiffTag = tiffField.getTag();
        String name = geoTiffTag.getName();
        int dataCount = tiffField.getCount();
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < dataCount) {
            if (geoTiffTag.hasValueNames()) {
                sb.append(geoTiffTag.getValueName(tiffField.getAsInt(i)));
            } else {
                sb.append(tiffField.getValueAsString(i));
            }
            if (i + 1 < dataCount) {
                sb.append(", ");
            }
            ++i;
        }
        ProductData value = ProductData.createInstance(sb.toString());
        return new MetadataAttribute(name, value, true);
    }

    private static ProductData getGeoKeyValue(GeoKeyEntry geoKeyEntry) {
        ProductData value = geoKeyEntry.getDblValue() != null ? ProductData.createInstance(geoKeyEntry.getDblValue()) : (geoKeyEntry.getStrValue() != null ? ProductData.createInstance(geoKeyEntry.getStrValue()) : (geoKeyEntry.getKeyId() == 1024 ? TiffTagToMetadataConverter.getModelTypeValueName(geoKeyEntry.getIntValue()) : (geoKeyEntry.getKeyId() == 1025 ? TiffTagToMetadataConverter.getRasterTypeValueName(geoKeyEntry.getIntValue()) : TiffTagToMetadataConverter.getEPSGValueName(geoKeyEntry))));
        return value;
    }

    private static ProductData getEPSGValueName(GeoKeyEntry geoKeyEntry) {
        String epsgCodeName = EPSGCodes.getInstance().getName(geoKeyEntry.getIntValue());
        ProductData value = epsgCodeName == null ? ProductData.createInstance(geoKeyEntry.getIntValue()) : ProductData.createInstance(epsgCodeName);
        return value;
    }

    private static ProductData getRasterTypeValueName(Integer intValue) {
        ProductData value = intValue == 1 ? ProductData.createInstance("RasterPixelIsArea") : (intValue == 2 ? ProductData.createInstance("RasterPixelIsPoint") : ProductData.createInstance("unknown"));
        return value;
    }

    private static ProductData getModelTypeValueName(Integer intValue) {
        ProductData value = intValue == 1 ? ProductData.createInstance("ModelTypeProjected") : (intValue == 2 ? ProductData.createInstance("ModelTypeGeographic") : (intValue == 3 ? ProductData.createInstance("ModelTypeGeocentric") : ProductData.createInstance("unknown")));
        return value;
    }
}

