/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.geometry;

import com.bc.ceres.binding.Converter;
import com.thoughtworks.xstream.core.util.OrderRetainingMap;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.esa.beam.dataio.geometry.VectorDataNodeIO;
import org.esa.beam.framework.datamodel.VectorDataNode;
import org.esa.beam.util.StringUtils;
import org.esa.beam.util.converters.JavaTypeConverter;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;

public class VectorDataNodeWriter {
    private static long id = System.nanoTime();

    public void write(VectorDataNode vectorDataNode, File file) throws IOException {
        try (FileWriter writer = new FileWriter(file);){
            this.writeNodeProperties(vectorDataNode, writer);
            this.writeFeatures(vectorDataNode.getFeatureCollection(), writer);
        }
    }

    public void writeFeatures(FeatureCollection<SimpleFeatureType, SimpleFeature> featureCollection, Writer writer) throws IOException {
        SimpleFeatureType simpleFeatureType = featureCollection.getSchema();
        this.writeFeatureType(simpleFeatureType, writer);
        this.writeFeatures0(featureCollection, writer);
    }

    public void writeProperties(Map<String, String> properties, Writer writer) throws IOException {
        Set<Map.Entry<String, String>> entries = properties.entrySet();
        for (Map.Entry<String, String> entry : entries) {
            writer.write("#" + entry.getKey() + "=" + entry.getValue() + "\n");
        }
    }

    void writeNodeProperties(VectorDataNode vectorDataNode, Writer writer) throws IOException {
        String defaultCSS;
        OrderRetainingMap properties = new OrderRetainingMap();
        Map<Object, Object> userData = vectorDataNode.getFeatureType().getUserData();
        Set<Map.Entry<Object, Object>> entries = userData.entrySet();
        for (Map.Entry<Object, Object> entry : entries) {
            if (!(entry.getKey() instanceof String) || !(entry.getValue() instanceof String)) continue;
            properties.put(entry.getKey().toString(), entry.getValue().toString());
        }
        String description = vectorDataNode.getDescription();
        if (StringUtils.isNotNullAndNotEmpty(description)) {
            properties.put("description", description);
        }
        if (StringUtils.isNotNullAndNotEmpty(defaultCSS = vectorDataNode.getDefaultStyleCss())) {
            properties.put("defaultCSS", defaultCSS);
        }
        this.writeProperties(properties, writer);
    }

    private void writeFeatures0(FeatureCollection<SimpleFeatureType, SimpleFeature> featureCollection, Writer writer) throws IOException {
        Converter[] converters = VectorDataNodeIO.getConverters(featureCollection.getSchema());
        try (FeatureIterator<SimpleFeature> features = featureCollection.features();){
            while (features.hasNext()) {
                SimpleFeature simpleFeature = features.next();
                String fid = simpleFeature.getID();
                if (fid == null || fid.isEmpty()) {
                    fid = String.format("FID%s", Long.toHexString(id++));
                }
                writer.write(fid);
                List<Object> attributes = simpleFeature.getAttributes();
                int i = 0;
                while (i < attributes.size()) {
                    Object value = attributes.get(i);
                    String text = "[null]";
                    if (value != null) {
                        Converter converter = converters[i];
                        text = converter.format(value);
                        text = VectorDataNodeIO.encodeTabString(text);
                    }
                    writer.write(9);
                    writer.write(text);
                    ++i;
                }
                writer.write(10);
            }
        }
    }

    private void writeFeatureType(SimpleFeatureType simpleFeatureType, Writer writer) throws IOException {
        writer.write(simpleFeatureType.getTypeName());
        List<AttributeDescriptor> attributeDescriptors = simpleFeatureType.getAttributeDescriptors();
        JavaTypeConverter typeConverter = new JavaTypeConverter();
        for (AttributeDescriptor attributeDescriptor : attributeDescriptors) {
            Class<?> binding = attributeDescriptor.getType().getBinding();
            String name = attributeDescriptor.getLocalName();
            String type = typeConverter.format(binding);
            writer.write(9);
            writer.write(name);
            writer.write(58);
            writer.write(type);
        }
        writer.write(10);
    }
}

