/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.geometry;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.CoordinateSequenceFilter;
import org.esa.beam.framework.datamodel.GeoCoding;
import org.esa.beam.framework.datamodel.GeoPos;
import org.esa.beam.framework.datamodel.PixelPos;

class GeoPosToPixelPosFilter
implements CoordinateSequenceFilter {
    public int count = 0;
    private int numCoordinates;
    private GeoCoding geoCoding;

    public GeoPosToPixelPosFilter(int numCoordinates, GeoCoding geoCoding) {
        this.numCoordinates = numCoordinates;
        this.geoCoding = geoCoding;
    }

    @Override
    public void filter(CoordinateSequence seq, int i) {
        Coordinate coord = seq.getCoordinate(i);
        PixelPos pixelPos = this.geoCoding.getPixelPos(new GeoPos((float)coord.y, (float)coord.x), null);
        double x = Math.round(pixelPos.x * 10000.0f) / 10000;
        double y = Math.round(pixelPos.y * 10000.0f) / 10000;
        coord.setCoordinate(new Coordinate(x, y));
        ++this.count;
    }

    @Override
    public boolean isDone() {
        return this.numCoordinates == this.count;
    }

    @Override
    public boolean isGeometryChanged() {
        return this.numCoordinates == this.count;
    }
}

