/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.dimap.spi;

import java.util.ArrayList;
import org.esa.beam.dataio.dimap.spi.DimapPersistable;
import org.esa.beam.framework.datamodel.ConvolutionFilterBand;
import org.esa.beam.framework.datamodel.Kernel;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductData;
import org.esa.beam.framework.datamodel.RasterDataNode;
import org.esa.beam.util.StringUtils;
import org.jdom.Element;

class ConvolutionFilterBandPersistable
implements DimapPersistable {
    ConvolutionFilterBandPersistable() {
    }

    @Override
    public Object createObjectFromXml(Element element, Product product) {
        Element filterInfo = element.getChild("Filter_Band_Info");
        Element kernelInfo = filterInfo.getChild("Filter_Kernel");
        Kernel kernel = ConvolutionFilterBandPersistable.convertElementToKernel(kernelInfo);
        String sourceName = filterInfo.getChildTextTrim("FILTER_SOURCE");
        String bandName = element.getChildTextTrim("BAND_NAME");
        RasterDataNode sourceNode = product.getRasterDataNode(sourceName);
        ConvolutionFilterBand cfb = new ConvolutionFilterBand(bandName, sourceNode, kernel, 1);
        cfb.setDescription(element.getChildTextTrim("BAND_DESCRIPTION"));
        cfb.setUnit(element.getChildTextTrim("PHYSICAL_UNIT"));
        cfb.setSolarFlux(Float.parseFloat(element.getChildTextTrim("SOLAR_FLUX")));
        cfb.setSpectralWavelength(Float.parseFloat(element.getChildTextTrim("BAND_WAVELEN")));
        cfb.setSpectralBandwidth(Float.parseFloat(element.getChildTextTrim("BANDWIDTH")));
        cfb.setScalingFactor(Double.parseDouble(element.getChildTextTrim("SCALING_FACTOR")));
        cfb.setScalingOffset(Double.parseDouble(element.getChildTextTrim("SCALING_OFFSET")));
        cfb.setLog10Scaled(Boolean.parseBoolean(element.getChildTextTrim("LOG10_SCALED")));
        cfb.setNoDataValueUsed(Boolean.parseBoolean(element.getChildTextTrim("NO_DATA_VALUE_USED")));
        cfb.setNoDataValue(Double.parseDouble(element.getChildTextTrim("NO_DATA_VALUE")));
        return cfb;
    }

    @Override
    public Element createXmlFromObject(Object object) {
        ConvolutionFilterBand cfb = (ConvolutionFilterBand)object;
        ArrayList<Element> contentList = new ArrayList<Element>();
        contentList.add(ConvolutionFilterBandPersistable.createElement("BAND_INDEX", String.valueOf(cfb.getProduct().getBandIndex(cfb.getName()))));
        contentList.add(ConvolutionFilterBandPersistable.createElement("BAND_NAME", cfb.getName()));
        contentList.add(ConvolutionFilterBandPersistable.createElement("BAND_DESCRIPTION", cfb.getDescription()));
        contentList.add(ConvolutionFilterBandPersistable.createElement("DATA_TYPE", ProductData.getTypeString(cfb.getDataType())));
        contentList.add(ConvolutionFilterBandPersistable.createElement("PHYSICAL_UNIT", cfb.getUnit()));
        contentList.add(ConvolutionFilterBandPersistable.createElement("SOLAR_FLUX", String.valueOf(cfb.getSolarFlux())));
        contentList.add(ConvolutionFilterBandPersistable.createElement("BAND_WAVELEN", String.valueOf(cfb.getSpectralWavelength())));
        contentList.add(ConvolutionFilterBandPersistable.createElement("BANDWIDTH", String.valueOf(cfb.getSpectralBandwidth())));
        contentList.add(ConvolutionFilterBandPersistable.createElement("SCALING_FACTOR", String.valueOf(cfb.getScalingFactor())));
        contentList.add(ConvolutionFilterBandPersistable.createElement("SCALING_OFFSET", String.valueOf(cfb.getScalingOffset())));
        contentList.add(ConvolutionFilterBandPersistable.createElement("LOG10_SCALED", String.valueOf(cfb.isLog10Scaled())));
        contentList.add(ConvolutionFilterBandPersistable.createElement("NO_DATA_VALUE_USED", String.valueOf(cfb.isNoDataValueUsed())));
        contentList.add(ConvolutionFilterBandPersistable.createElement("NO_DATA_VALUE", String.valueOf(cfb.getNoDataValue())));
        ArrayList<Element> filterBandInfoList = new ArrayList<Element>();
        filterBandInfoList.add(ConvolutionFilterBandPersistable.createElement("FILTER_SOURCE", cfb.getSource().getName()));
        filterBandInfoList.add(ConvolutionFilterBandPersistable.convertKernelToElement(cfb.getKernel()));
        Element filterBandInfo = new Element("Filter_Band_Info");
        filterBandInfo.setAttribute("bandType", "ConvolutionFilterBand");
        filterBandInfo.addContent(filterBandInfoList);
        contentList.add(filterBandInfo);
        Element root = new Element("Spectral_Band_Info");
        root.setContent(contentList);
        return root;
    }

    static Kernel convertElementToKernel(Element kernelInfo) {
        String kernelDataString = kernelInfo.getChildTextTrim("KERNEL_DATA");
        double[] data = StringUtils.toDoubleArray(kernelDataString, ",");
        int width = Integer.parseInt(kernelInfo.getChildTextTrim("KERNEL_WIDTH"));
        int height = Integer.parseInt(kernelInfo.getChildTextTrim("KERNEL_HEIGHT"));
        String xOriginText = kernelInfo.getChildTextTrim("KERNEL_X_ORIGIN");
        int xOrigin = (width - 1) / 2;
        if (xOriginText != null) {
            xOrigin = Integer.parseInt(xOriginText);
        }
        String yOriginText = kernelInfo.getChildTextTrim("KERNEL_Y_ORIGIN");
        int yOrigin = (height - 1) / 2;
        if (yOriginText != null) {
            yOrigin = Integer.parseInt(yOriginText);
        }
        String factorText = kernelInfo.getChildTextTrim("KERNEL_FACTOR");
        double factor = 1.0;
        if (factorText != null) {
            factor = Double.parseDouble(factorText);
        }
        return new Kernel(width, height, xOrigin, yOrigin, factor, data);
    }

    static Element convertKernelToElement(Kernel kernel) {
        ArrayList<Element> filterKernelList = new ArrayList<Element>();
        filterKernelList.add(ConvolutionFilterBandPersistable.createElement("KERNEL_WIDTH", String.valueOf(kernel.getWidth())));
        filterKernelList.add(ConvolutionFilterBandPersistable.createElement("KERNEL_HEIGHT", String.valueOf(kernel.getHeight())));
        filterKernelList.add(ConvolutionFilterBandPersistable.createElement("KERNEL_X_ORIGIN", String.valueOf(kernel.getXOrigin())));
        filterKernelList.add(ConvolutionFilterBandPersistable.createElement("KERNEL_Y_ORIGIN", String.valueOf(kernel.getYOrigin())));
        filterKernelList.add(ConvolutionFilterBandPersistable.createElement("KERNEL_FACTOR", String.valueOf(kernel.getFactor())));
        filterKernelList.add(ConvolutionFilterBandPersistable.createElement("KERNEL_DATA", ConvolutionFilterBandPersistable.toCsv(kernel.getKernelData(null))));
        Element filterKernel = new Element("Filter_Kernel");
        filterKernel.addContent(filterKernelList);
        return filterKernel;
    }

    static String toCsv(double[] data) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < data.length) {
            double v = data[i];
            if (i > 0) {
                sb.append(',');
            }
            if (v == (double)((int)v)) {
                sb.append((int)v);
            } else {
                sb.append(v);
            }
            ++i;
        }
        return sb.toString();
    }

    private static Element createElement(String tagName, String text) {
        Element elem = new Element(tagName);
        elem.setText(text);
        return elem;
    }
}

