/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.avhrr.noaa.pod;

import com.bc.ceres.binio.CompoundData;
import com.bc.ceres.binio.DataContext;
import com.bc.ceres.binio.DataFormat;
import com.bc.ceres.binio.IOHandler;
import com.bc.ceres.binio.SequenceData;
import java.io.IOException;
import java.nio.ByteOrder;
import org.esa.beam.dataio.avhrr.noaa.pod.PodTypes;

class PodFormatDetector {
    PodFormatDetector() {
    }

    public boolean canDecode(IOHandler ioHandler) {
        DataFormat dataFormat = new DataFormat(PodTypes.TBM_HEADER_RECORD_TYPE, ByteOrder.BIG_ENDIAN);
        DataContext context = dataFormat.createContext(ioHandler);
        try {
            boolean bl = PodFormatDetector.isTbmHeaderRecord(context.getData());
            return bl;
        }
        catch (IOException iOException) {
            return false;
        }
        finally {
            context.dispose();
        }
    }

    static boolean isTbmHeaderRecord(CompoundData data) throws IOException {
        String datasetName;
        String appendedDataSelection;
        String totalOrSelectiveCopy = PodFormatDetector.getString(data, 2);
        return !(!"T".equals(totalOrSelectiveCopy) && !"S".equals(totalOrSelectiveCopy) || !"Y".equals(appendedDataSelection = PodFormatDetector.getString(data, 10)) && !"N".equals(appendedDataSelection) || !(datasetName = PodFormatDetector.getString(data, 1)).matches("[A-Z]{3}\\.HRPT\\..*"));
    }

    static String getString(CompoundData data, int index) throws IOException {
        return PodFormatDetector.toString(data.getSequence(index));
    }

    static String toString(SequenceData valueSequence) throws IOException {
        byte[] data = new byte[valueSequence.getElementCount()];
        int i = 0;
        while (i < data.length) {
            data[i] = valueSequence.getByte(i);
            ++i;
        }
        return new String(data);
    }
}

