/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.avhrr.noaa.pod;

import com.bc.ceres.binio.SequenceData;
import com.bc.ceres.core.ProgressMonitor;
import java.io.IOException;
import org.esa.beam.dataio.avhrr.BandReader;
import org.esa.beam.dataio.avhrr.calibration.Calibrator;
import org.esa.beam.dataio.avhrr.noaa.pod.CalibratorFactory;
import org.esa.beam.dataio.avhrr.noaa.pod.VideoDataProvider;
import org.esa.beam.framework.datamodel.ProductData;

final class PodBandReader
implements BandReader {
    private static final int POINTS_PER_SCAN = 2048;
    private static final int WORDS_PER_SCAN = 3414;
    private static final int TEN_BITS = 1023;
    private static final int[] FIRST;
    private static final int[][] INCREMENT;
    private static final int[][] SHIFT;
    private final VideoDataProvider videoDataProvider;
    private final int channelIndex;
    private final CalibratorFactory calibratorFactory;

    static {
        int[] nArray = new int[5];
        nArray[3] = 1;
        nArray[4] = 1;
        FIRST = nArray;
        INCREMENT = new int[][]{{1, 2, 2}, {2, 1, 2}, {2, 2, 1}, {1, 2, 2}, {2, 1, 2}};
        int[][] nArrayArray = new int[5][];
        int[] nArray2 = new int[3];
        nArray2[0] = 20;
        nArray2[2] = 10;
        nArrayArray[0] = nArray2;
        int[] nArray3 = new int[3];
        nArray3[0] = 10;
        nArray3[1] = 20;
        nArrayArray[1] = nArray3;
        int[] nArray4 = new int[3];
        nArray4[1] = 10;
        nArray4[2] = 20;
        nArrayArray[2] = nArray4;
        int[] nArray5 = new int[3];
        nArray5[0] = 20;
        nArray5[2] = 10;
        nArrayArray[3] = nArray5;
        int[] nArray6 = new int[3];
        nArray6[0] = 10;
        nArray6[1] = 20;
        nArrayArray[4] = nArray6;
        SHIFT = nArrayArray;
    }

    public PodBandReader(int channelIndex, VideoDataProvider videoDataProvider, CalibratorFactory calibratorFactory) {
        this.channelIndex = channelIndex;
        this.videoDataProvider = videoDataProvider;
        this.calibratorFactory = calibratorFactory;
    }

    @Override
    public String getBandName() {
        return this.calibratorFactory.getBandName();
    }

    @Override
    public String getBandUnit() {
        return this.calibratorFactory.getBandUnit();
    }

    @Override
    public String getBandDescription() {
        return this.calibratorFactory.getBandDescription();
    }

    @Override
    public double getScalingFactor() {
        return 1.0;
    }

    @Override
    public int getDataType() {
        return 30;
    }

    @Override
    public void readBandRasterData(int sourceOffsetX, int sourceOffsetY, int sourceWidth, int sourceHeight, int sourceStepX, int sourceStepY, ProductData targetBuffer, ProgressMonitor pm) throws IOException {
        int minX = sourceOffsetX;
        int maxX = sourceOffsetX + sourceWidth - 1;
        int minY = sourceOffsetY;
        int maxY = sourceOffsetY + sourceHeight - 1;
        float[] targetData = (float[])targetBuffer.getElems();
        int[] videoData = new int[3414];
        int[] countData = new int[2048];
        int targetIdx = 0;
        pm.beginTask("Reading AVHRR band '" + this.getBandName() + "'...", maxY - minY);
        try {
            int y = minY;
            while (y <= maxY) {
                if (pm.isCanceled()) {
                    break;
                }
                boolean valid = this.videoDataProvider.isValid(y);
                if (valid) {
                    this.readVideoData(y, videoData);
                    this.decodeVideoData(this.channelIndex, videoData, countData);
                    try {
                        Calibrator calibrator = this.calibratorFactory.createCalibrator(y);
                        int x = minX;
                        while (x <= maxX) {
                            targetData[targetIdx] = calibrator.calibrate(countData[x]);
                            ++targetIdx;
                            x += sourceStepX;
                        }
                    }
                    catch (IOException iOException) {
                        valid = false;
                    }
                }
                if (!valid) {
                    int x = minX;
                    while (x <= maxX) {
                        targetData[targetIdx] = Float.NaN;
                        ++targetIdx;
                        x += sourceStepX;
                    }
                }
                pm.worked(1);
                y += sourceStepY;
            }
        }
        finally {
            pm.done();
        }
    }

    private void readVideoData(int y, int[] videoData) throws IOException {
        SequenceData videoDataSequence = this.videoDataProvider.getVideoData(y);
        int i = 0;
        while (i < videoDataSequence.getElementCount()) {
            videoData[i] = videoDataSequence.getInt(i);
            ++i;
        }
    }

    private void decodeVideoData(int channelIndex, int[] videoData, int[] countData) {
        int[] shifts = SHIFT[channelIndex];
        int[] increments = INCREMENT[channelIndex];
        int i = 0;
        int j = 0;
        int rawIndex = FIRST[channelIndex];
        while (i < countData.length) {
            countData[i] = (videoData[rawIndex] & 1023 << shifts[j]) >> shifts[j];
            rawIndex += increments[j];
            j = j == 2 ? 0 : ++j;
            ++i;
        }
    }
}

