/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.avhrr.noaa.pod;

import org.esa.beam.dataio.avhrr.BandReader;
import org.esa.beam.dataio.avhrr.noaa.pod.AlbedoCalibratorFactory;
import org.esa.beam.dataio.avhrr.noaa.pod.CalibrationCoefficientsProvider;
import org.esa.beam.dataio.avhrr.noaa.pod.CountsCalibratorFactory;
import org.esa.beam.dataio.avhrr.noaa.pod.PodBandReader;
import org.esa.beam.dataio.avhrr.noaa.pod.RadianceCalibratorFactory;
import org.esa.beam.dataio.avhrr.noaa.pod.VideoDataProvider;

class BandReaderFactory {
    BandReaderFactory() {
    }

    static BandReader createCountBandReader(int channelIndex, VideoDataProvider videoDataProvider) {
        return new PodBandReader(channelIndex, videoDataProvider, new CountsCalibratorFactory(channelIndex));
    }

    static BandReader createAlbedoBandReader(int channelIndex, VideoDataProvider videoDataProvider, CalibrationCoefficientsProvider calibrationCoefficientsProvider) {
        return new PodBandReader(channelIndex, videoDataProvider, new AlbedoCalibratorFactory(channelIndex, calibrationCoefficientsProvider));
    }

    static BandReader createRadianceBandReader(int channelIndex, VideoDataProvider videoDataProvider, CalibrationCoefficientsProvider calibrationCoefficientsProvider) {
        return new PodBandReader(channelIndex, videoDataProvider, new RadianceCalibratorFactory(channelIndex, calibrationCoefficientsProvider));
    }
}

