/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.avhrr.calibration;

import org.esa.beam.dataio.avhrr.calibration.RadianceCalibrator;

public class Radiance2ReflectanceFactorCalibrator
implements RadianceCalibrator {
    private float conversionFactor;

    public Radiance2ReflectanceFactorCalibrator(double equivalentWidth, double solarIrradiance, double earthSunDistance) {
        this.conversionFactor = (float)(solarIrradiance / (314.1592653589793 * equivalentWidth * earthSunDistance * earthSunDistance));
    }

    @Override
    public float calibrate(float radiances) {
        return radiances / this.conversionFactor;
    }

    public float getConversionFactor() {
        return this.conversionFactor;
    }
}

