/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.awt;

import com.vividsolutions.jts.awt.GeometryCollectionShape;
import com.vividsolutions.jts.awt.IdentityPointTransformation;
import com.vividsolutions.jts.awt.PointShapeFactory;
import com.vividsolutions.jts.awt.PointTransformation;
import com.vividsolutions.jts.awt.PolygonShape;
import com.vividsolutions.jts.awt.SqarePointShapeFactory;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.util.ArrayList;

public class ShapeWriter {
    public static final PointTransformation DEFAULT_POINT_TRANSFORMATION = new IdentityPointTransformation();
    public static final PointShapeFactory DEFAULT_POINT_FACTORY = new SqarePointShapeFactory(3.0);
    private PointTransformation pointTransformer = DEFAULT_POINT_TRANSFORMATION;
    private PointShapeFactory pointFactory = DEFAULT_POINT_FACTORY;

    public ShapeWriter(PointTransformation pointTransformer, PointShapeFactory pointFactory) {
        if (pointTransformer != null) {
            this.pointTransformer = pointTransformer;
        }
        if (pointFactory != null) {
            this.pointFactory = pointFactory;
        }
    }

    public ShapeWriter(PointTransformation pointTransformer) {
        this(pointTransformer, null);
    }

    public ShapeWriter() {
    }

    public Shape toShape(Geometry geometry) {
        if (geometry.isEmpty()) {
            return new GeneralPath();
        }
        if (geometry instanceof Polygon) {
            return this.toShape((Polygon)geometry);
        }
        if (geometry instanceof LineString) {
            return this.toShape((LineString)geometry);
        }
        if (geometry instanceof MultiLineString) {
            return this.toShape((MultiLineString)geometry);
        }
        if (geometry instanceof Point) {
            return this.toShape((Point)geometry);
        }
        if (geometry instanceof GeometryCollection) {
            return this.toShape((GeometryCollection)geometry);
        }
        throw new IllegalArgumentException("Unrecognized Geometry class: " + geometry.getClass());
    }

    private Shape toShape(Polygon p) {
        ArrayList<Coordinate[]> holeVertexCollection = new ArrayList<Coordinate[]>();
        for (int j = 0; j < p.getNumInteriorRing(); ++j) {
            holeVertexCollection.add(this.toViewCoordinates(p.getInteriorRingN(j).getCoordinates()));
        }
        return new PolygonShape(this.toViewCoordinates(p.getExteriorRing().getCoordinates()), holeVertexCollection);
    }

    private Coordinate[] toViewCoordinates(Coordinate[] modelCoordinates) {
        Coordinate[] viewCoordinates = new Coordinate[modelCoordinates.length];
        for (int i = 0; i < modelCoordinates.length; ++i) {
            Point2D point2D = this.toPoint(modelCoordinates[i]);
            viewCoordinates[i] = new Coordinate(point2D.getX(), point2D.getY());
        }
        return viewCoordinates;
    }

    private Shape toShape(GeometryCollection gc) {
        GeometryCollectionShape shape = new GeometryCollectionShape();
        for (int i = 0; i < gc.getNumGeometries(); ++i) {
            Geometry g = gc.getGeometryN(i);
            shape.add(this.toShape(g));
        }
        return shape;
    }

    private GeneralPath toShape(MultiLineString mls) {
        GeneralPath path = new GeneralPath();
        for (int i = 0; i < mls.getNumGeometries(); ++i) {
            LineString lineString = (LineString)mls.getGeometryN(i);
            path.append(this.toShape(lineString), false);
        }
        return path;
    }

    private GeneralPath toShape(LineString lineString) {
        GeneralPath shape = new GeneralPath();
        Point2D viewPoint = this.toPoint(lineString.getCoordinateN(0));
        shape.moveTo((float)viewPoint.getX(), (float)viewPoint.getY());
        for (int i = 1; i < lineString.getNumPoints(); ++i) {
            viewPoint = this.toPoint(lineString.getCoordinateN(i));
            shape.lineTo((float)viewPoint.getX(), (float)viewPoint.getY());
        }
        return shape;
    }

    private Shape toShape(Point point) {
        Point2D viewPoint = this.toPoint(point.getCoordinate());
        return this.pointFactory.createPoint(viewPoint);
    }

    private Point2D toPoint(Coordinate model) {
        Point2D.Double view = new Point2D.Double();
        this.pointTransformer.transform(model, view);
        ((Point2D)view).setLocation(Math.round(((Point2D)view).getX()), Math.round(((Point2D)view).getY()));
        return view;
    }
}

