/*
 * Decompiled with CFR 0.152.
 */
package com.bc.jexp.impl;

import com.bc.jexp.Function;
import com.bc.jexp.Namespace;
import com.bc.jexp.ParseException;
import com.bc.jexp.Parser;
import com.bc.jexp.Symbol;
import com.bc.jexp.Term;
import com.bc.jexp.impl.DefaultNamespace;
import com.bc.jexp.impl.NamespaceImpl;
import com.bc.jexp.impl.Tokenizer;

public final class ParserImpl
implements Parser {
    private Namespace defaultNamespace;
    private Tokenizer tokenizer;
    private boolean typeChecking;

    public ParserImpl() {
        this(new DefaultNamespace(), true);
    }

    public ParserImpl(boolean typeChecking) {
        this(new DefaultNamespace(), typeChecking);
    }

    public ParserImpl(Namespace namespace) {
        this(namespace, true);
    }

    public ParserImpl(Namespace namespace, boolean typeChecking) {
        this.defaultNamespace = namespace;
        this.typeChecking = typeChecking;
        this.tokenizer = null;
    }

    @Override
    public final Namespace getDefaultNamespace() {
        return this.defaultNamespace;
    }

    public boolean isTypeChecking() {
        return this.typeChecking;
    }

    @Override
    public final Term parse(String code) throws ParseException {
        return this.parse(code, this.defaultNamespace);
    }

    @Override
    public final Term parse(String code, Namespace namespace) throws ParseException {
        if (code == null) {
            throw new IllegalArgumentException("code is null");
        }
        Namespace defaultNamespace = this.defaultNamespace;
        if (namespace != null && namespace != defaultNamespace) {
            this.defaultNamespace = new NamespaceImpl(namespace);
        }
        this.tokenizer = new Tokenizer(code);
        Term term = this.parseImpl();
        this.tokenizer = null;
        this.defaultNamespace = defaultNamespace;
        return term;
    }

    private Term parseImpl() throws ParseException {
        Term expr = this.parseTerm(false);
        int tt = this.tokenizer.next();
        if (tt != -1) {
            this.reportError("Incomplete expression.");
        }
        return expr;
    }

    private Term parseTerm(boolean required) throws ParseException {
        return this.parseAssign(required);
    }

    private Term parseAssign(boolean required) throws ParseException {
        Term t1 = this.parseConditional(required);
        while (t1 != null) {
            int tt = this.tokenizer.next();
            if (tt == 61) {
                Term t2 = this.parseAssign(true);
                if (t1 instanceof Term.Ref && ((Term.Ref)t1).getVariable() != null) {
                    t1 = new Term.Assign(t1, t2);
                    continue;
                }
                this.reportError("Variable expected on the left side of assignment '='.");
                continue;
            }
            this.tokenizer.pushBack();
            break;
        }
        return t1;
    }

    private Term parseConditional(boolean required) throws ParseException {
        Term t1;
        this.tokenizer.next();
        if (this.isKeyword("if")) {
            t1 = this.parseTerm(true);
            this.tokenizer.next();
            if (this.isKeyword("then")) {
                Term t2 = this.parseTerm(true);
                this.tokenizer.next();
                if (this.isKeyword("else")) {
                    if (this.isTypeChecking() && !t1.isB()) {
                        this.reportError("Boolean operand expected after 'if' in conditional term.");
                    }
                    Term t3 = this.parseTerm(true);
                    return this.createConditionTerm(t1, t2, t3);
                }
                this.tokenizer.pushBack();
                this.reportError("Missing 'else' in a conditional 'if' term.");
            } else {
                this.tokenizer.pushBack();
                this.reportError("Missing 'then' in a conditional 'if' term.");
            }
        } else {
            this.tokenizer.pushBack();
        }
        t1 = this.parseLogicalOr(required);
        int tt = this.tokenizer.next();
        if (tt == 63) {
            Term t2 = this.parseTerm(true);
            tt = this.tokenizer.next();
            if (tt == 58) {
                if (this.isTypeChecking() && !t1.isB()) {
                    this.reportError("Boolean operand expected before '?' in conditional term.");
                }
                Term t3 = this.parseTerm(true);
                t1 = this.createConditionTerm(t1, t2, t3);
            } else {
                this.tokenizer.pushBack();
                this.reportError("Missing ':' part of conditional '?:' term.");
            }
        } else {
            this.tokenizer.pushBack();
        }
        return t1;
    }

    private Term parseLogicalOr(boolean required) throws ParseException {
        Term t1 = this.parseLogicalAnd(required);
        while (t1 != null) {
            this.tokenizer.next();
            if (this.isSpecial("||") || this.isKeyword("or")) {
                Term t2 = this.parseLogicalAnd(true);
                if (t1.isB() && t2.isB() || !this.isTypeChecking()) {
                    t1 = new Term.OrB(t1, t2);
                    continue;
                }
                this.reportTypeErrorB2("'||' or 'or'");
                continue;
            }
            this.tokenizer.pushBack();
            break;
        }
        return t1;
    }

    private Term parseLogicalAnd(boolean required) throws ParseException {
        Term t1 = this.parseComparison(required);
        while (t1 != null) {
            this.tokenizer.next();
            if (this.isSpecial("&&") || this.isKeyword("and")) {
                Term t2 = this.parseComparison(true);
                if (t1.isB() && t2.isB() || !this.isTypeChecking()) {
                    t1 = new Term.AndB(t1, t2);
                    continue;
                }
                this.reportTypeErrorB2("'&&' or 'and'");
                continue;
            }
            this.tokenizer.pushBack();
            break;
        }
        return t1;
    }

    private Term parseComparison(boolean required) throws ParseException {
        Term t1 = this.parseBitwiseOr(required);
        while (t1 != null) {
            Term t2;
            int tt = this.tokenizer.next();
            if (tt == 60) {
                t2 = this.parseBitwiseOr(true);
                if (t1.isD() && t2.isN() || t1.isN() && t2.isD()) {
                    t1 = new Term.LtD(t1, t2);
                    continue;
                }
                if (t1.isI() && t2.isI()) {
                    t1 = new Term.LtI(t1, t2);
                    continue;
                }
                if (!this.isTypeChecking()) {
                    t1 = new Term.LtD(t1, t2);
                    continue;
                }
                this.reportTypeErrorN2("'<'");
                continue;
            }
            if (tt == 62) {
                t2 = this.parseBitwiseOr(true);
                if (t1.isD() && t2.isN() || t1.isN() && t2.isD()) {
                    t1 = new Term.GtD(t1, t2);
                    continue;
                }
                if (t1.isI() && t2.isI()) {
                    t1 = new Term.GtI(t1, t2);
                    continue;
                }
                if (!this.isTypeChecking()) {
                    t1 = new Term.GtD(t1, t2);
                    continue;
                }
                this.reportTypeErrorN2("'>'");
                continue;
            }
            if (this.isSpecial("==")) {
                t2 = this.parseBitwiseOr(true);
                if (t1.isD() && t2.isN() || t1.isN() && t2.isD()) {
                    t1 = new Term.EqD(t1, t2);
                    continue;
                }
                if (t1.isI() && t2.isI()) {
                    t1 = new Term.EqI(t1, t2);
                    continue;
                }
                if (!this.isTypeChecking()) {
                    t1 = new Term.EqD(t1, t2);
                    continue;
                }
                this.reportTypeErrorN2("'=='");
                continue;
            }
            if (this.isSpecial("!=")) {
                t2 = this.parseBitwiseOr(true);
                if (t1.isD() && t2.isN() || t1.isN() && t2.isD()) {
                    t1 = new Term.NEqD(t1, t2);
                    continue;
                }
                if (t1.isI() && t2.isI()) {
                    t1 = new Term.NEqI(t1, t2);
                    continue;
                }
                if (!this.isTypeChecking()) {
                    t1 = new Term.NEqD(t1, t2);
                    continue;
                }
                this.reportTypeErrorN2("'!='");
                continue;
            }
            if (this.isSpecial("<=")) {
                t2 = this.parseBitwiseOr(true);
                if (t1.isD() && t2.isN() || t1.isN() && t2.isD()) {
                    t1 = new Term.LeD(t1, t2);
                    continue;
                }
                if (t1.isI() && t2.isI()) {
                    t1 = new Term.LeI(t1, t2);
                    continue;
                }
                if (!this.isTypeChecking()) {
                    t1 = new Term.LeD(t1, t2);
                    continue;
                }
                this.reportTypeErrorN2("'<='");
                continue;
            }
            if (this.isSpecial(">=")) {
                t2 = this.parseBitwiseOr(true);
                if (t1.isD() && t2.isN() || t1.isN() && t2.isD()) {
                    t1 = new Term.GeD(t1, t2);
                    continue;
                }
                if (t1.isI() && t2.isI()) {
                    t1 = new Term.GeI(t1, t2);
                    continue;
                }
                if (!this.isTypeChecking()) {
                    t1 = new Term.GeD(t1, t2);
                    continue;
                }
                this.reportTypeErrorN2("'>='");
                continue;
            }
            this.tokenizer.pushBack();
            break;
        }
        return t1;
    }

    private Term parseBitwiseOr(boolean required) throws ParseException {
        Term t1 = this.parseBtwiseXOr(required);
        while (t1 != null) {
            int tt = this.tokenizer.next();
            if (tt == 124) {
                Term t2 = this.parseBtwiseXOr(true);
                if (t1.isI() && t2.isI() || !this.isTypeChecking()) {
                    t1 = new Term.OrI(t1, t2);
                    continue;
                }
                this.reportTypeErrorI2("'|'");
                continue;
            }
            this.tokenizer.pushBack();
            break;
        }
        return t1;
    }

    private Term parseBtwiseXOr(boolean required) throws ParseException {
        Term t1 = this.parseBitwiseAnd(required);
        while (t1 != null) {
            int tt = this.tokenizer.next();
            if (tt == 94) {
                Term t2 = this.parseBitwiseAnd(true);
                if (t1.isI() && t2.isI() || !this.isTypeChecking()) {
                    t1 = new Term.XOrI(t1, t2);
                    continue;
                }
                this.reportTypeErrorI2("'^'");
                continue;
            }
            this.tokenizer.pushBack();
            break;
        }
        return t1;
    }

    private Term parseBitwiseAnd(boolean required) throws ParseException {
        Term t1 = this.parseAdd(required);
        while (t1 != null) {
            int tt = this.tokenizer.next();
            if (tt == 38) {
                Term t2 = this.parseAdd(true);
                if (t1.isI() && t2.isI() || !this.isTypeChecking()) {
                    t1 = new Term.AndI(t1, t2);
                    continue;
                }
                this.reportTypeErrorI2("'&'");
                continue;
            }
            this.tokenizer.pushBack();
            break;
        }
        return t1;
    }

    private Term parseAdd(boolean required) throws ParseException {
        Term t1 = this.parseMul(required);
        while (t1 != null) {
            Term t2;
            int tt = this.tokenizer.next();
            if (tt == 43) {
                t2 = this.parseMul(true);
                if (t1.isD() && t2.isN() || t1.isN() && t2.isD()) {
                    t1 = new Term.Add(3, t1, t2);
                    continue;
                }
                if (t1.isI() && t2.isI()) {
                    t1 = new Term.Add(2, t1, t2);
                    continue;
                }
                if (!this.isTypeChecking()) {
                    t1 = new Term.Add(t1.isD() || t2.isD() ? 3 : 2, t1, t2);
                    continue;
                }
                this.reportTypeErrorN2("'+'");
                continue;
            }
            if (tt == 45) {
                t2 = this.parseMul(true);
                if (t1.isD() && t2.isN() || t1.isN() && t2.isD()) {
                    t1 = new Term.Sub(3, t1, t2);
                    continue;
                }
                if (t1.isI() && t2.isI()) {
                    t1 = new Term.Sub(2, t1, t2);
                    continue;
                }
                if (!this.isTypeChecking()) {
                    t1 = new Term.Sub(t1.isD() || t2.isD() ? 3 : 2, t1, t2);
                    continue;
                }
                this.reportTypeErrorN2("'-'");
                continue;
            }
            this.tokenizer.pushBack();
            break;
        }
        return t1;
    }

    private Term parseMul(boolean required) throws ParseException {
        Term t1 = this.parseUnary(required);
        while (t1 != null) {
            Term t2;
            int tt = this.tokenizer.next();
            if (tt == 42) {
                t2 = this.parseUnary(true);
                if (t1.isD() && t2.isN() || t1.isN() && t2.isD()) {
                    t1 = new Term.Mul(3, t1, t2);
                    continue;
                }
                if (t1.isI() && t2.isI()) {
                    t1 = new Term.Mul(2, t1, t2);
                    continue;
                }
                if (!this.isTypeChecking()) {
                    t1 = new Term.Mul(t1.isD() || t2.isD() ? 3 : 2, t1, t2);
                    continue;
                }
                this.reportTypeErrorN2("'*'");
                continue;
            }
            if (tt == 47) {
                t2 = this.parseUnary(true);
                if (t1.isD() && t2.isN() || t1.isN() && t2.isD()) {
                    t1 = new Term.Div(3, t1, t2);
                    continue;
                }
                if (t1.isI() && t2.isI()) {
                    t1 = new Term.Div(2, t1, t2);
                    continue;
                }
                if (!this.isTypeChecking()) {
                    t1 = new Term.Div(t1.isD() || t2.isD() ? 3 : 2, t1, t2);
                    continue;
                }
                this.reportTypeErrorN2("'/'");
                continue;
            }
            if (tt == 37) {
                t2 = this.parseUnary(true);
                if (t1.isD() && t2.isN() || t1.isN() && t2.isD()) {
                    t1 = new Term.Mod(3, t1, t2);
                    continue;
                }
                if (t1.isI() && t2.isI()) {
                    t1 = new Term.Mod(2, t1, t2);
                    continue;
                }
                if (!this.isTypeChecking()) {
                    t1 = new Term.Mod(t1.isD() || t2.isD() ? 3 : 2, t1, t2);
                    continue;
                }
                this.reportTypeErrorN2("'%'");
                continue;
            }
            this.tokenizer.pushBack();
            break;
        }
        return t1;
    }

    private Term parseUnary(boolean required) throws ParseException {
        Term t1 = null;
        int tt = this.tokenizer.next();
        if (tt == 43) {
            Term t2 = this.parseUnary(true);
            if (t2.isI() || t2.isD()) {
                t1 = t2;
            } else if (!this.isTypeChecking()) {
                t1 = t2;
            } else {
                this.reportTypeErrorN1("'+'");
            }
        } else if (tt == 45) {
            Term t2 = this.parseUnary(true);
            if (t2 instanceof Term.ConstI) {
                t1 = new Term.ConstI(-((Term.ConstI)t2).getValue());
            } else if (t2 instanceof Term.ConstD) {
                t1 = new Term.ConstD(-((Term.ConstD)t2).getValue());
            } else if (t2.isI()) {
                t1 = new Term.Neg(2, t2);
            } else if (t2.isD()) {
                t1 = new Term.Neg(3, t2);
            } else if (!this.isTypeChecking()) {
                t1 = new Term.Neg(2, t2);
            } else {
                this.reportTypeErrorN1("'-'");
            }
        } else if (tt == 33 || this.isKeyword("not")) {
            Term t2 = this.parseUnary(true);
            if (t2.isB() || !this.isTypeChecking()) {
                t1 = new Term.NotB(t2);
            } else {
                this.reportTypeErrorB1("'!' or 'not'");
            }
        } else if (tt == 126) {
            Term t2 = this.parseUnary(true);
            if (t2.isI() || !this.isTypeChecking()) {
                t1 = new Term.NotI(t2);
            } else {
                this.reportTypeErrorI1("'~'");
            }
        } else {
            this.tokenizer.pushBack();
            t1 = this.parsePostfix(required);
        }
        return t1;
    }

    private Term parsePostfix(boolean required) throws ParseException {
        return this.parsePrimary(required);
    }

    private Term parsePrimary(boolean required) throws ParseException {
        Term t1 = null;
        int tt = this.tokenizer.next();
        if (tt == -14) {
            t1 = new Term.ConstD(this.convertDoubleToken());
        } else if (tt == -11) {
            t1 = new Term.ConstI(this.convertIntToken());
        } else if (tt == -12) {
            t1 = new Term.ConstI(this.convertHexIntToken());
        } else if (tt == -13) {
            t1 = new Term.ConstI(this.convertOctIntToken());
        } else if (tt == -21) {
            t1 = new Term.ConstS(this.convertStringToken());
        } else if (tt == -32) {
            String keyword = this.tokenizer.getToken();
            if (keyword.equalsIgnoreCase("true")) {
                t1 = new Term.ConstB(true);
            } else if (keyword.equalsIgnoreCase("false")) {
                t1 = new Term.ConstB(false);
            } else {
                this.reportError("Unexpected keyword '" + keyword + "'.");
            }
        } else if (tt == -31 || tt == -33) {
            String name = this.tokenizer.getToken();
            t1 = this.parseCallOrRef(name);
        } else if (tt == 40) {
            t1 = this.parseTerm(true);
            tt = this.tokenizer.next();
            if (tt != 41) {
                this.tokenizer.pushBack();
                this.reportError("Missing ')'.");
            }
        } else {
            if (required) {
                this.reportError("Term expected.");
            }
            this.tokenizer.pushBack();
        }
        return t1;
    }

    private String convertStringToken() {
        return this.tokenizer.getToken();
    }

    private Term parseCallOrRef(String name) throws ParseException {
        Term t1 = null;
        int tt = this.tokenizer.next();
        if (tt == 40) {
            Term[] args = this.parseArgumentList();
            Function function = this.defaultNamespace.resolveFunction(name, args);
            if (function != null) {
                t1 = new Term.Call(function, args);
            } else {
                this.reportError("Undefined function '" + ParserImpl.getFunctionCallString(name, args) + "'.");
            }
        } else {
            this.tokenizer.pushBack();
            Symbol symbol = this.defaultNamespace.resolveSymbol(name);
            if (symbol != null) {
                t1 = new Term.Ref(symbol);
            } else {
                this.reportError("Undefined symbol '" + name + "'.");
            }
        }
        return t1;
    }

    private Term[] parseArgumentList() throws ParseException {
        Term[] args = this.parseTermList();
        int tt = this.tokenizer.next();
        if (tt != 41) {
            this.tokenizer.pushBack();
            this.reportError("Missing ')' or ','.");
        }
        return args;
    }

    private Term[] parseTermList() throws ParseException {
        Term[] terms = new Term[1];
        int count = 0;
        Term term = this.parseTerm(false);
        while (term != null) {
            if (count >= terms.length) {
                Term[] temp = new Term[2 * terms.length];
                System.arraycopy(terms, 0, temp, 0, terms.length);
                terms = temp;
            }
            terms[count++] = term;
            int tt = this.tokenizer.next();
            if (tt == 44) {
                term = this.parseTerm(true);
                continue;
            }
            this.tokenizer.pushBack();
            term = null;
        }
        if (count < terms.length) {
            Term[] temp = new Term[count];
            System.arraycopy(terms, 0, temp, 0, count);
            terms = temp;
        }
        return terms;
    }

    private double convertDoubleToken() throws ParseException {
        String token = this.tokenizer.getToken();
        try {
            return Double.parseDouble(token);
        }
        catch (NumberFormatException numberFormatException) {
            this.reportError("Token '" + token + "' is not a valid numeric constant.");
            return 0.0;
        }
    }

    private int convertHexIntToken() throws ParseException {
        String token = this.tokenizer.getToken();
        try {
            String hexPart = token.substring(2);
            long l = Long.parseLong(hexPart, 16);
            if (l >= Integer.MIN_VALUE && l <= Integer.MAX_VALUE) {
                return (int)l;
            }
            this.reportError("Hexadecimal constant '" + token + "' is out of range.");
        }
        catch (NumberFormatException numberFormatException) {
            this.reportError("Token '" + token + "' is not a valid hexadecimal constant.");
        }
        return 0;
    }

    private int convertOctIntToken() throws ParseException {
        String token = this.tokenizer.getToken();
        try {
            String octPart = token.substring(1);
            long l = Long.parseLong(octPart, 8);
            if (l >= Integer.MIN_VALUE && l <= Integer.MAX_VALUE) {
                return (int)l;
            }
            this.reportError("Octal constant '" + token + "' is out of range.");
        }
        catch (NumberFormatException numberFormatException) {
            this.reportError("Token '" + token + "' is not a valid octal constant.");
        }
        return 0;
    }

    private int convertIntToken() throws ParseException {
        String token = this.tokenizer.getToken();
        try {
            long l = Long.parseLong(token);
            if (l >= Integer.MIN_VALUE && l <= Integer.MAX_VALUE) {
                return (int)l;
            }
            this.reportError("Integer constant '" + token + "' is out of range.");
        }
        catch (NumberFormatException numberFormatException) {
            this.reportError("Token  '" + token + "' is not a valid integer constant.");
        }
        return 0;
    }

    private boolean isSpecial(String special) {
        String token;
        return this.tokenizer.getType() == -41 && (token = this.tokenizer.getToken()).equals(special);
    }

    private boolean isKeyword(String keyword) {
        String token;
        return this.tokenizer.getType() == -32 && (token = this.tokenizer.getToken()).equalsIgnoreCase(keyword);
    }

    private void reportError(String message) throws ParseException {
        throw new ParseException(this.tokenizer.getLine(), this.tokenizer.getColumn(), message);
    }

    private void reportTypeErrorB1(String operator) throws ParseException {
        this.reportError("Boolean operand expected for unary " + operator + " operator.");
    }

    private void reportTypeErrorI1(String operator) throws ParseException {
        this.reportError("Integer operand expected for unary " + operator + " operator.");
    }

    private void reportTypeErrorN1(String operator) throws ParseException {
        this.reportError("Numeric operand expected for unary " + operator + " operator.");
    }

    private void reportTypeErrorB2(String operator) throws ParseException {
        this.reportError("Boolean operands expected for binary " + operator + " operator.");
    }

    private void reportTypeErrorI2(String operator) throws ParseException {
        this.reportError("Integer operands expected for binary " + operator + " operator.");
    }

    private void reportTypeErrorN2(String operator) throws ParseException {
        this.reportError("Numeric operands expected for binary " + operator + " operator.");
    }

    private static String getFunctionCallString(String name, Term[] args) {
        StringBuffer sb = new StringBuffer();
        sb.append(name);
        sb.append('(');
        int i = 0;
        while (i < args.length) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(ParserImpl.getParamTypeString(args[i].getRetType()));
            ++i;
        }
        sb.append(')');
        return sb.toString();
    }

    private static String getParamTypeString(int type) {
        if (type == 1) {
            return "boolean";
        }
        if (type == 2) {
            return "int";
        }
        if (type == 3) {
            return "double";
        }
        return "?";
    }

    private Term createConditionTerm(Term t1, Term t2, Term t3) throws ParseException {
        if (t2.isB() && t3.isB()) {
            return new Term.Cond(1, t1, t2, t3);
        }
        if (t2.isD() && t3.isN() || t2.isN() && t3.isD()) {
            return new Term.Cond(3, t1, t2, t3);
        }
        if (t2.isI() && t3.isI()) {
            return new Term.Cond(2, t1, t2, t3);
        }
        if (!this.isTypeChecking()) {
            return new Term.Cond(3, t1, t2, t3);
        }
        this.reportError("Boolean or numeric operands expected in conditional term.");
        return null;
    }
}

