/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.jai.operator;

import com.bc.ceres.jai.ExpressionCompilerConfig;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.media.jai.JAI;
import javax.media.jai.OperationDescriptorImpl;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.RenderedOp;

public class ExpressionDescriptor
extends OperationDescriptorImpl {
    private static final String[][] resources = new String[][]{{"GlobalName", "Expression"}, {"LocalName", "Expression"}, {"Vendor", "com.bc.ceres.jai"}, {"Description", "Computes a single-banded image using a Java expression."}, {"DocURL", ""}, {"Version", "1.0"}, {"arg0Desc", "The type of the destination image."}, {"arg1Desc", "An arbitrary Java expression."}, {"arg2Desc", "The configuration for the Java expression compiler."}};
    private static final String[] supportedModes = new String[]{"rendered"};
    private static final String[] sourceNames = new String[]{"sources"};
    private static final Class[][] sourceTypes = new Class[][]{{Map.class}};
    private static final String[] paramNames = new String[]{"dataType", "expression", "compilerConfig"};
    private static final Class[] paramClasses = new Class[]{Integer.class, String.class, ExpressionCompilerConfig.class};
    private static final Object[] paramDefaults = new Object[]{NO_PARAMETER_DEFAULT, NO_PARAMETER_DEFAULT, NO_PARAMETER_DEFAULT};
    private static final Set<Integer> validTypeValues = new TreeSet<Integer>(Arrays.asList(0, 2, 1, 3, 4, 5));
    private static final Object[] validParamValues = new Object[3];

    public ExpressionDescriptor() {
        super(resources, supportedModes, sourceNames, sourceTypes, paramNames, paramClasses, paramDefaults, validParamValues);
    }

    @Override
    protected boolean validateSources(String modeName, ParameterBlock args, StringBuffer message) {
        if (!super.validateSources(modeName, args, message)) {
            return false;
        }
        Map source = (Map)args.getSource(0);
        if (source.isEmpty()) {
            message.append("At least a single source must be given.");
            return false;
        }
        Map.Entry[] entries = source.entrySet().toArray(new Map.Entry[0]);
        RenderedImage image0 = null;
        Map.Entry[] entryArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            Map.Entry entry = entryArray[n2];
            if (!(entry.getKey() instanceof String)) {
                message.append("Invalid key in source map.");
                return false;
            }
            if (!(entry.getValue() instanceof RenderedImage)) {
                message.append("Invalid value in source map.");
                return false;
            }
            RenderedImage image = (RenderedImage)entry.getValue();
            if (image.getSampleModel().getNumBands() != 1) {
                message.append("All images in the source map must have exactly one band.");
                return false;
            }
            if (image0 != null) {
                if (image.getWidth() != image0.getWidth() || image.getHeight() != image0.getHeight()) {
                    message.append("All images in the source map must have the same width x height.");
                    return false;
                }
            } else {
                image0 = image;
            }
            ++n2;
        }
        return true;
    }

    @Override
    protected boolean validateParameters(String modeName, ParameterBlock args, StringBuffer message) {
        if (!super.validateParameters(modeName, args, message)) {
            return false;
        }
        int dataType = args.getIntParameter(0);
        if (!validTypeValues.contains(dataType)) {
            message.append("Parameter 'dataType' is not valid.");
            return false;
        }
        String expression = ((String)args.getObjectParameter(1)).trim();
        int length = expression.length();
        if (length == 0) {
            message.append("Parameter 'expression' must not be empty.");
            return false;
        }
        return true;
    }

    public static RenderedOp create(Map<String, RenderedImage> sources, int dataType, String expression, ExpressionCompilerConfig compilerConfig, RenderingHints hints) {
        ParameterBlockJAI pb = new ParameterBlockJAI("Expression", "rendered");
        pb.addSource(sources);
        pb.setParameter("dataType", dataType);
        pb.setParameter("expression", expression);
        pb.setParameter("compilerConfig", compilerConfig);
        return JAI.create("Expression", pb, hints);
    }
}

