/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.core.runtime.internal;

import com.bc.ceres.core.CoreException;
import com.bc.ceres.core.ExtensionFactory;
import com.bc.ceres.core.ExtensionManager;
import com.bc.ceres.core.ServiceRegistry;
import com.bc.ceres.core.ServiceRegistryManager;
import com.bc.ceres.core.SingleTypeExtensionFactory;
import com.bc.ceres.core.runtime.Activator;
import com.bc.ceres.core.runtime.ConfigurationElement;
import com.bc.ceres.core.runtime.Extension;
import com.bc.ceres.core.runtime.ExtensionPoint;
import com.bc.ceres.core.runtime.Module;
import com.bc.ceres.core.runtime.ModuleContext;
import com.bc.ceres.core.runtime.ModuleState;
import com.bc.ceres.core.runtime.RuntimeRunnable;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;

public class RuntimeActivator
implements Activator {
    private static RuntimeActivator instance;
    private Map<String, RuntimeRunnable> applications;
    private List<ServiceRegistration> serviceRegistrations;
    private ModuleContext moduleContext;
    private ClassLoader resourcesClassLoader;

    public static RuntimeActivator getInstance() {
        return instance;
    }

    public RuntimeActivator() {
        instance = this;
    }

    public RuntimeRunnable getApplication(String id) {
        return this.applications.get(id);
    }

    public ModuleContext getModuleContext() {
        return this.moduleContext;
    }

    @Override
    public void start(ModuleContext moduleContext) throws CoreException {
        this.moduleContext = moduleContext;
        this.initApplications();
        this.initServiceProviders();
        this.initAdapters();
    }

    @Override
    public void stop(ModuleContext moduleContext) throws CoreException {
        try {
            this.disposeServiceProviders();
            this.disposeApplications();
        }
        finally {
            this.moduleContext = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassLoader getResourcesClassLoader() {
        if (this.resourcesClassLoader == null) {
            RuntimeActivator runtimeActivator = this;
            synchronized (runtimeActivator) {
                if (this.resourcesClassLoader == null) {
                    this.resourcesClassLoader = this.createResourcesClassLoader();
                }
            }
        }
        return this.resourcesClassLoader;
    }

    private void initServiceProviders() {
        Extension[] extensions;
        ClassLoader providerLoader = this.getResourcesClassLoader();
        this.serviceRegistrations = new ArrayList<ServiceRegistration>(32);
        ExtensionPoint extensionPoint = this.moduleContext.getModule().getExtensionPoint("serviceProviders");
        Extension[] extensionArray = extensions = extensionPoint.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            ConfigurationElement[] children;
            Extension extension = extensionArray[n2];
            ConfigurationElement[] configurationElementArray = children = (ConfigurationElement[])extension.getConfigurationElement().getChildren("serviceProvider");
            int n3 = children.length;
            int n4 = 0;
            while (n4 < n3) {
                Class<?> providerClass;
                ConfigurationElement child = configurationElementArray[n4];
                String providerClassName = child.getValue();
                Module declaringModule = extension.getDeclaringModule();
                if (declaringModule.getState().is(ModuleState.RESOLVED) && (providerClass = this.getProviderClass(declaringModule, providerClassName)) != null) {
                    try {
                        Set<ServiceRegistration> serviceRegistrationsForClass = this.getServiceRegistrations(providerClass, providerLoader);
                        for (ServiceRegistration serviceRegistration : serviceRegistrationsForClass) {
                            String[] providerImplClassNames = this.getProviderImplClassNames(serviceRegistration);
                            if (providerImplClassNames == null) continue;
                            String[] stringArray = providerImplClassNames;
                            int n5 = providerImplClassNames.length;
                            int n6 = 0;
                            while (n6 < n5) {
                                String providerImplClassName = stringArray[n6];
                                Class<?> providerImplClass = this.getProviderImplClass(serviceRegistration, providerImplClassName);
                                if (providerImplClass != null) {
                                    this.registerProviderImpl(serviceRegistration, providerImplClass);
                                }
                                ++n6;
                            }
                        }
                    }
                    catch (IOException e) {
                        this.moduleContext.getLogger().log(Level.SEVERE, String.format("Failed to load service provider [%s]", providerClassName), e);
                    }
                }
                ++n4;
            }
            ++n2;
        }
    }

    private ClassLoader createResourcesClassLoader() {
        ArrayList<URL> urlArrayList = new ArrayList<URL>();
        Module[] moduleArray = this.moduleContext.getModules();
        int n = moduleArray.length;
        int n2 = 0;
        while (n2 < n) {
            Module module = moduleArray[n2];
            if (module.getState().is(ModuleState.RESOLVED)) {
                URL location = module.getLocation();
                urlArrayList.add(location);
            }
            ++n2;
        }
        return new URLClassLoader(urlArrayList.toArray(new URL[urlArrayList.size()]), (ClassLoader)new NullClassLoader());
    }

    private void registerProviderImpl(ServiceRegistration serviceRegistration, Class<?> providerImplClass) {
        Class providerClass = serviceRegistration.serviceRegistry.getServiceType();
        if (providerClass.isAssignableFrom(providerImplClass)) {
            Object providerImpl = this.getProviderImpl(providerImplClass);
            if (providerImpl != null) {
                serviceRegistration.serviceRegistry.addService(providerImpl);
                serviceRegistration.providerImpl = providerImpl;
                this.moduleContext.getLogger().info(String.format("Module [%s]: Service [%s] registered", serviceRegistration.module.getSymbolicName(), serviceRegistration.providerImpl.getClass()));
                this.serviceRegistrations.add(serviceRegistration);
            }
        } else {
            this.moduleContext.getLogger().severe(String.format("Service [%s] is not of type [%s]", providerImplClass.toString(), providerClass.toString()));
        }
    }

    private Object getProviderImpl(Class<?> providerImplClass) {
        Object providerImpl = null;
        try {
            providerImpl = providerImplClass.newInstance();
        }
        catch (Throwable t) {
            this.moduleContext.getLogger().log(Level.SEVERE, String.format("Failed to instantiate service of type [%s]", providerImplClass.toString()), t);
        }
        return providerImpl;
    }

    private Class<?> getProviderImplClass(ServiceRegistration serviceRegistration, String providerImplClassName) {
        Class<?> providerImplClass = null;
        try {
            providerImplClass = serviceRegistration.module.loadClass(providerImplClassName);
        }
        catch (Throwable t) {
            this.moduleContext.getLogger().log(Level.SEVERE, String.format("Failed to load service type [%s]", providerImplClassName), t);
        }
        return providerImplClass;
    }

    private String[] getProviderImplClassNames(ServiceRegistration serviceRegistration) {
        String[] providerImplClassNames = null;
        try {
            providerImplClassNames = RuntimeActivator.parseSpiConfiguration(serviceRegistration.url);
        }
        catch (IOException e) {
            this.moduleContext.getLogger().log(Level.SEVERE, String.format("Failed to load configuration [%s] from module [%s].", serviceRegistration.url, serviceRegistration.module.getName()), e);
        }
        return providerImplClassNames;
    }

    private Class<?> getProviderClass(Module declaringModule, String providerClassName) {
        Class<?> providerClass = null;
        try {
            providerClass = declaringModule.loadClass(providerClassName);
        }
        catch (Throwable t) {
            this.moduleContext.getLogger().log(Level.SEVERE, String.format("Failed to load service provider [%s].", providerClassName), t);
        }
        return providerClass;
    }

    private Set<ServiceRegistration> getServiceRegistrations(Class<?> providerClass, ClassLoader providerLoader) throws IOException {
        ServiceRegistry<?> serviceRegistry = ServiceRegistryManager.getInstance().getServiceRegistry(providerClass);
        HashSet<ServiceRegistration> serviceRegistrationsForClass = new HashSet<ServiceRegistration>(10);
        String resourcePath = "META-INF/services/" + providerClass.getName();
        Enumeration<URL> resources = providerLoader.getResources(resourcePath);
        if (resources != null) {
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                Module module = this.getModule(url);
                if (module != null) {
                    ServiceRegistration serviceRegistration = new ServiceRegistration(url, module, serviceRegistry);
                    if (!serviceRegistrationsForClass.contains(serviceRegistration)) {
                        serviceRegistrationsForClass.add(serviceRegistration);
                        continue;
                    }
                    this.moduleContext.getLogger().warning(String.format("Service already registered: [%s].", serviceRegistration));
                    continue;
                }
                this.moduleContext.getLogger().warning("Module not found for service provider URL " + url);
            }
        }
        return serviceRegistrationsForClass;
    }

    private Module getModule(URL url) {
        String urlString = url.toExternalForm();
        Module module = this.getModule(urlString);
        if (module == null && urlString.startsWith("jar:")) {
            urlString = urlString.substring(4);
            module = this.getModule(urlString);
        }
        return module;
    }

    private Module getModule(String urlAsString) {
        Module[] moduleArray = this.moduleContext.getModules();
        int n = moduleArray.length;
        int n2 = 0;
        while (n2 < n) {
            Module module = moduleArray[n2];
            if (urlAsString.startsWith(module.getLocation().toExternalForm())) {
                return module;
            }
            ++n2;
        }
        return null;
    }

    private void disposeServiceProviders() {
        for (ServiceRegistration serviceRegistration : this.serviceRegistrations) {
            ServiceRegistry serviceRegistry = serviceRegistration.serviceRegistry;
            Object providerImpl = serviceRegistration.providerImpl;
            serviceRegistry.removeService(providerImpl);
            this.moduleContext.getLogger().info(String.format("Module [%s]: Service [%s] unregistered", serviceRegistration.module.getSymbolicName(), serviceRegistration.providerImpl.getClass()));
        }
        this.serviceRegistrations.clear();
        this.resourcesClassLoader = null;
    }

    private void initApplications() {
        this.applications = new HashMap<String, RuntimeRunnable>(3);
        ExtensionPoint extensionPoint = this.moduleContext.getModule().getExtensionPoint("applications");
        Extension[] extensions = extensionPoint.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            ConfigurationElement[] children;
            Extension extension = extensions[i];
            ConfigurationElement[] configurationElementArray = children = (ConfigurationElement[])extension.getConfigurationElement().getChildren("application");
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                ConfigurationElement child = configurationElementArray[n2];
                String appId = child.getAttribute("id");
                if (this.isNullOrEmpty(appId)) {
                    this.moduleContext.getLogger().severe("Missing identifier for extension " + i + " of extension point [applications].");
                } else {
                    if (this.applications.containsKey(appId)) {
                        this.moduleContext.getLogger().warning("Identifier [" + appId + "] is already in use within extension point [applications].");
                    }
                    RuntimeRunnable application = null;
                    try {
                        application = child.createExecutableExtension(RuntimeRunnable.class);
                    }
                    catch (Throwable e) {
                        Module declaringModule = extension.getDeclaringModule();
                        String msg = String.format("Failed to register application [%s] (declared by module [%s]).", appId, declaringModule.getSymbolicName());
                        this.moduleContext.getLogger().log(Level.SEVERE, msg, e);
                    }
                    if (application != null) {
                        this.applications.put(appId, application);
                        Module declaringModule = extension.getDeclaringModule();
                        String msg = String.format("Module [%s]: Application [%s] registered using instance of [%s].", declaringModule.getSymbolicName(), appId, application.getClass());
                        this.moduleContext.getLogger().info(msg);
                    }
                }
                ++n2;
            }
            ++i;
        }
    }

    private void disposeApplications() {
        this.applications.clear();
        this.applications = null;
    }

    private void initAdapters() {
        Extension[] extensions;
        ExtensionPoint extensionPoint = this.moduleContext.getModule().getExtensionPoint("adapters");
        Extension[] extensionArray = extensions = extensionPoint.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            ConfigurationElement[] children;
            Extension extension = extensionArray[n2];
            ConfigurationElement[] configurationElementArray = children = (ConfigurationElement[])extension.getConfigurationElement().getChildren("adapter");
            int n3 = children.length;
            int n4 = 0;
            while (n4 < n3) {
                ConfigurationElement child = configurationElementArray[n4];
                try {
                    this.registerAdapter(extension, child);
                }
                catch (Exception e) {
                    this.moduleContext.getLogger().log(Level.SEVERE, String.format("Module [%s]: Failed to register an [adapter] extension of point [adapters].", extension.getDeclaringModule().getSymbolicName()), e);
                }
                ++n4;
            }
            ++n2;
        }
    }

    private void registerAdapter(Extension extension, ConfigurationElement child) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Module declaringModule = extension.getDeclaringModule();
        String extensibleTypeName = this.getChildValue(child, "extensibleType");
        String extensionFactoryName = this.getChildValue(child, "extensionFactory");
        String extensionTypeName = this.getChildValue(child, "extensionType");
        String extensionSubTypeName = this.getChildValue(child, "extensionSubType");
        if (!this.isNullOrEmpty(extensibleTypeName)) {
            if (!this.isNullOrEmpty(extensionFactoryName)) {
                Class<?> extensibleType = declaringModule.loadClass(extensibleTypeName);
                ExtensionFactory extensionFactory = (ExtensionFactory)declaringModule.loadClass(extensionFactoryName).newInstance();
                this.registerAdapter(declaringModule, extensibleType, extensionFactory);
            } else if (!this.isNullOrEmpty(extensionTypeName)) {
                if (!this.isNullOrEmpty(extensionSubTypeName)) {
                    Class<?> extensibleType = declaringModule.loadClass(extensibleTypeName);
                    Class<?> extensionType = declaringModule.loadClass(extensionTypeName);
                    Class<?> extensionSubType = declaringModule.loadClass(extensionSubTypeName);
                    this.registerAdapter(declaringModule, extensibleType, new SingleTypeExtensionFactory(extensionType, extensionSubType));
                } else {
                    Class<?> extensibleType = declaringModule.loadClass(extensibleTypeName);
                    Class<?> extensionType = declaringModule.loadClass(extensionTypeName);
                    this.registerAdapter(declaringModule, extensibleType, new SingleTypeExtensionFactory(extensionType));
                }
            } else {
                this.moduleContext.getLogger().severe(String.format("Module [%s]: Missing either element 'extensionFactory' or 'extensionType' in an extension of point [adapters].", declaringModule.getSymbolicName()));
            }
        } else {
            this.moduleContext.getLogger().severe(String.format("Module [%s]: Missing element 'extensibleType' in an extension of point [adapters].", declaringModule.getSymbolicName()));
        }
    }

    private void registerAdapter(Module declaringModule, Class<?> extensibleType, ExtensionFactory extensionFactory) {
        ExtensionManager.getInstance().register(extensibleType, extensionFactory);
        this.moduleContext.getLogger().info(String.format("Module [%s]: Adapter registered: A [%s] can now be extended to %s", declaringModule.getSymbolicName(), extensibleType, Arrays.toString(extensionFactory.getExtensionTypes())));
    }

    private String getChildValue(ConfigurationElement child, String elementName) {
        ConfigurationElement element = (ConfigurationElement)child.getChild(elementName);
        return element != null ? element.getValue() : null;
    }

    private boolean isNullOrEmpty(String extendibleTypeName) {
        return extendibleTypeName == null || extendibleTypeName.trim().length() == 0;
    }

    public static String[] parseSpiConfiguration(URL resource) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(resource.openStream()));){
            String s;
            ArrayList<String> classNames = new ArrayList<String>(3);
            while ((s = bufferedReader.readLine()) != null) {
                int i = s.indexOf(35);
                if (i >= 0) {
                    s = s.substring(0, i);
                }
                if ((s = s.trim()).length() <= 0) continue;
                classNames.add(s);
            }
            return classNames.toArray(new String[classNames.size()]);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static class NullClassLoader
    extends ClassLoader {
        private NullClassLoader() {
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            throw new ClassNotFoundException(name);
        }

        @Override
        protected URL findResource(String name) {
            return null;
        }

        @Override
        protected String findLibrary(String libname) {
            return null;
        }

        @Override
        protected Enumeration<URL> findResources(String name) throws IOException {
            return new Vector().elements();
        }
    }

    private static class ServiceRegistration {
        final URL url;
        final Module module;
        final ServiceRegistry serviceRegistry;
        Object providerImpl;

        public ServiceRegistration(URL url, Module module, ServiceRegistry serviceRegistry) {
            this.url = url;
            this.module = module;
            this.serviceRegistry = serviceRegistry;
        }

        public int hashCode() {
            return this.url.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            return this.url.equals(((ServiceRegistration)obj).url);
        }

        public String toString() {
            return this.url.toString();
        }
    }
}

