/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.core.runtime.internal;

import com.bc.ceres.core.Assert;
import com.bc.ceres.core.CanceledException;
import com.bc.ceres.core.CoreException;
import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.core.SubProgressMonitor;
import com.bc.ceres.core.runtime.Module;
import com.bc.ceres.core.runtime.ProxyConfig;
import com.bc.ceres.core.runtime.internal.HrefParser;
import com.bc.ceres.core.runtime.internal.ModuleImpl;
import com.bc.ceres.core.runtime.internal.ModuleReader;
import com.bc.ceres.core.runtime.internal.UrlHelper;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class RepositoryScanner {
    private Logger logger;
    private URL url;
    private ProxyConfig proxyConfig;

    public RepositoryScanner(Logger logger, URL url, ProxyConfig proxyConfig) {
        Assert.notNull(logger, "logger");
        Assert.notNull(url, "url");
        Assert.notNull(proxyConfig, "proxyConfig");
        this.logger = logger;
        this.url = url;
        this.proxyConfig = proxyConfig;
    }

    public Module[] scan(ProgressMonitor progressMonitor) throws CoreException {
        try {
            Assert.notNull(progressMonitor, "progressMonitor");
            return this.scanImpl(progressMonitor);
        }
        catch (IOException e) {
            throw new CoreException(e);
        }
    }

    private Module[] scanImpl(ProgressMonitor progressMonitor) throws IOException, CanceledException {
        ArrayList<Module> repositoryModules = new ArrayList<Module>(64);
        progressMonitor.beginTask("Retrieving module information from repository", 100);
        progressMonitor.setSubTaskName("Connecting...");
        URLConnection urlConnection = this.url.getProtocol().equalsIgnoreCase("http") ? UrlHelper.openConnection(this.url, this.proxyConfig, "GET") : this.url.openConnection();
        progressMonitor.worked(10);
        InputStream inputStream = urlConnection.getInputStream();
        InputStreamReader reader = new InputStreamReader(inputStream);
        try {
            progressMonitor.setSubTaskName("Scanning...");
            String[] hrefs = "text/plain".equals(urlConnection.getContentType()) ? RepositoryScanner.parseTextPlain(reader) : RepositoryScanner.parseTextHtml(reader);
            progressMonitor.worked(10);
            if (hrefs.length > 0) {
                this.collectModules(hrefs, repositoryModules, SubProgressMonitor.create(progressMonitor, 80));
            } else {
                progressMonitor.worked(80);
            }
        }
        finally {
            reader.close();
            progressMonitor.done();
        }
        return repositoryModules.toArray(new Module[repositoryModules.size()]);
    }

    private void collectModules(String[] hrefs, List<Module> repositoryModules, ProgressMonitor pm) throws CanceledException {
        pm.beginTask("Loading modules...", hrefs.length);
        try {
            String[] stringArray = hrefs;
            int n = hrefs.length;
            int n2 = 0;
            while (n2 < n) {
                String href = stringArray[n2];
                if (pm.isCanceled()) {
                    throw new CanceledException();
                }
                this.collectModule(href, repositoryModules);
                pm.worked(1);
                ++n2;
            }
        }
        finally {
            pm.done();
        }
    }

    private void collectModule(String href, List<Module> repositoryModules) {
        ModuleImpl module;
        String urlString;
        if (href.startsWith("http:")) {
            return;
        }
        String moduleName = href;
        if (moduleName.startsWith("/")) {
            moduleName = moduleName.substring(1);
        }
        if (moduleName.endsWith("/")) {
            moduleName = moduleName.substring(0, moduleName.length() - 1);
        }
        if (!(urlString = this.url.toExternalForm()).endsWith("/")) {
            urlString = String.valueOf(urlString) + "/";
        }
        String urlBase = String.valueOf(urlString) + moduleName + '/';
        try {
            URL manifestUrl = new URL(String.valueOf(urlBase) + "module.xml");
            module = new ModuleReader(this.logger).readFromManifest(manifestUrl, this.proxyConfig);
        }
        catch (CoreException e) {
            this.logger.warning(String.format("Repository entry [%s] is invalid: %s", moduleName, e.getMessage()));
            return;
        }
        catch (MalformedURLException e) {
            this.logger.warning(String.format("Repository entry [%s] is invalid: %s", moduleName, e.getMessage()));
            return;
        }
        Module repositoryModule = this.createRepositoryModule(module, urlBase, String.valueOf(moduleName) + ".jar");
        if (repositoryModule == null) {
            repositoryModule = this.createRepositoryModule(module, urlBase, String.valueOf(moduleName) + ".zip");
        }
        if (repositoryModule == null) {
            this.logger.warning(String.format("Repository entry [%s] is invalid, no archive found.", moduleName));
            return;
        }
        this.logger.info(String.format("Repository entry [%s] found.", moduleName));
        repositoryModules.add(repositoryModule);
    }

    private Module createRepositoryModule(ModuleImpl module, String urlBase, String archiveName) {
        URLConnection urlConnection;
        URL archiveUrl;
        try {
            archiveUrl = new URL(String.valueOf(urlBase) + archiveName);
            urlConnection = UrlHelper.openConnection(archiveUrl, this.proxyConfig, "HEAD");
            urlConnection.connect();
        }
        catch (IOException iOException) {
            return null;
        }
        int contentLength = urlConnection.getContentLength();
        long lastModified = urlConnection.getLastModified();
        String aboutUrlString = String.valueOf(urlBase) + "about.html";
        if (!UrlHelper.existsResource(aboutUrlString, this.proxyConfig)) {
            aboutUrlString = null;
        }
        module.setLocation(archiveUrl);
        module.setContentLength(contentLength);
        module.setLastModified(lastModified);
        module.setAboutUrl(aboutUrlString);
        return module;
    }

    private static String[] parseTextHtml(InputStreamReader reader) throws IOException {
        return new HrefParser(reader).parse();
    }

    private static String[] parseTextPlain(InputStreamReader reader) throws IOException {
        int type;
        StreamTokenizer st = new StreamTokenizer(reader);
        st.resetSyntax();
        st.whitespaceChars(0, 32);
        st.wordChars(33, 255);
        st.eolIsSignificant(false);
        ArrayList<String> list = new ArrayList<String>(32);
        while ((type = st.nextToken()) != -1) {
            list.add(st.sval);
        }
        return list.toArray(new String[list.size()]);
    }
}

