/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.core;

import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.core.ProgressMonitorWrapper;

public class SubProgressMonitor
extends ProgressMonitorWrapper {
    public static final int SUPPRESS_SUBTASK_LABEL = 2;
    public static final int PREPEND_MAIN_LABEL_TO_SUBTASK = 4;
    private int parentTicks = 0;
    private double sentToParent = 0.0;
    private double scale = 0.0;
    private int nestedBeginTasks = 0;
    private boolean usedUp = false;
    private boolean hasSubTask = false;
    private int style;
    private String taskName;
    private int totalWork;
    private long t0;
    private static final boolean traceTimeStat = Boolean.getBoolean("com.bc.ceres.core.SubProgressMonitor.traceTimeStat");

    public static ProgressMonitor create(ProgressMonitor monitor, int ticks) {
        if (monitor == ProgressMonitor.NULL) {
            return monitor;
        }
        return new SubProgressMonitor(monitor, ticks);
    }

    public SubProgressMonitor(ProgressMonitor monitor, int ticks) {
        this(monitor, ticks, 0);
    }

    public SubProgressMonitor(ProgressMonitor monitor, int ticks, int style) {
        super(monitor);
        this.parentTicks = ticks;
        this.style = style;
    }

    @Override
    public void beginTask(String taskName, int totalWork) {
        ++this.nestedBeginTasks;
        if (this.nestedBeginTasks > 1) {
            return;
        }
        this.t0 = System.currentTimeMillis();
        this.taskName = taskName;
        this.totalWork = totalWork;
        this.scale = totalWork <= 0 ? 0.0 : (double)this.parentTicks / (double)totalWork;
    }

    @Override
    public void done() {
        if (this.nestedBeginTasks == 0 || --this.nestedBeginTasks > 0) {
            return;
        }
        double remaining = (double)this.parentTicks - this.sentToParent;
        if (remaining > 0.0) {
            super.internalWorked(remaining);
        }
        if (this.hasSubTask) {
            this.setSubTaskName("");
        }
        this.sentToParent = 0.0;
        if (traceTimeStat) {
            long dt = System.currentTimeMillis() - this.t0;
            System.out.println("Task '" + this.taskName + "':");
            System.out.println("  ParentTicks:      " + this.parentTicks);
            System.out.println("  Total work:       " + this.totalWork);
            System.out.println("  Total time:       " + dt + " ms");
            System.out.println("  Time / work unit: " + (double)dt / (double)this.totalWork + " ms");
        }
    }

    @Override
    public void internalWorked(double work) {
        if (this.usedUp || this.nestedBeginTasks != 1) {
            return;
        }
        double realWork = this.scale * work;
        super.internalWorked(realWork);
        this.sentToParent += realWork;
        if (this.sentToParent >= (double)this.parentTicks) {
            this.usedUp = true;
        }
    }

    @Override
    public void setSubTaskName(String subTaskName) {
        if ((this.style & 2) != 0) {
            return;
        }
        this.hasSubTask = true;
        String label = subTaskName;
        if ((this.style & 4) != 0 && this.taskName != null && this.taskName.length() > 0) {
            label = String.valueOf(this.taskName) + ' ' + label;
        }
        super.setSubTaskName(label);
    }

    @Override
    public void worked(int work) {
        this.internalWorked(work);
    }
}

