/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.binding.converters;

import com.bc.ceres.binding.ConversionException;
import com.bc.ceres.binding.Converter;

public abstract class NumberConverter<T extends Number>
implements Converter<T> {
    @Override
    public abstract Class<? extends T> getValueType();

    @Override
    public T parse(String value) throws ConversionException {
        if (value.isEmpty()) {
            return null;
        }
        try {
            return this.parseNumber(NumberConverter.trimNumberString(value));
        }
        catch (NumberFormatException numberFormatException) {
            throw new ConversionException("'" + value + "' cannot be converted to a " + this.getValueType().getSimpleName().toLowerCase() + ".");
        }
    }

    protected abstract T parseNumber(String var1) throws NumberFormatException;

    @Override
    public String format(T value) {
        if (value == null) {
            return "";
        }
        return value.toString();
    }

    private static String trimNumberString(String s) {
        if ((s = s.trim()).startsWith("+")) {
            s = s.substring(1);
        }
        return s;
    }
}

