/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.binding.converters;

import com.bc.ceres.binding.ConversionException;
import com.bc.ceres.binding.Converter;
import com.bc.ceres.binding.converters.ArrayConverter;
import com.bc.ceres.binding.converters.IntegerConverter;
import java.awt.Color;
import java.text.MessageFormat;

public class ColorConverter
implements Converter<Color> {
    @Override
    public Class<Color> getValueType() {
        return Color.class;
    }

    @Override
    public Color parse(String text) throws ConversionException {
        int[] array;
        if (text.isEmpty()) {
            return null;
        }
        try {
            array = (int[])new ArrayConverter(int[].class, new IntegerConverter()).parse(text);
        }
        catch (ConversionException e) {
            throw new ConversionException(MessageFormat.format("Cannot parse ''{0}'' into a color: {1}", text, e.getMessage()), e);
        }
        if (array.length < 3) {
            throw new ConversionException(MessageFormat.format("Cannot parse ''{0}'' into a color.", text));
        }
        int r = array[0];
        int g = array[1];
        int b = array[2];
        int a = array.length == 4 ? array[3] : 255;
        try {
            return new Color(r, g, b, a);
        }
        catch (Exception e) {
            throw new ConversionException(MessageFormat.format("Cannot parse ''{0}'' into a color: {1}", text, e.getMessage()), e);
        }
    }

    @Override
    public String format(Color color) {
        if (color == null) {
            return "";
        }
        int r = color.getRed();
        int g = color.getGreen();
        int b = color.getBlue();
        int a = color.getAlpha();
        if (a == 255) {
            return String.format("%d,%d,%d", r, g, b);
        }
        return String.format("%d,%d,%d,%d", r, g, b, a);
    }
}

