/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.util;

import java.io.File;
import java.net.URL;

public abstract class ResourceListEntry {
    private static final String PATH_SEP = System.getProperty("file.separator");
    protected LocType loctype_;
    protected Object address_;
    protected String name_;
    protected Object item_;
    private boolean favorite_ = true;

    public ResourceListEntry(LocType loctype, Object address, Object item) {
        this.loctype_ = loctype;
        this.address_ = address;
        this.item_ = item;
        String astring = this.address_.toString();
        int lastSlash = astring.lastIndexOf(47);
        int lastSeparator = Math.max(lastSlash, astring.lastIndexOf(PATH_SEP));
        this.name_ = astring.substring(lastSeparator + 1);
    }

    public String toString() {
        return this.name_;
    }

    public String getName() {
        return this.name_;
    }

    Object getObject() {
        if (this.item_ == null) {
            if (this.address_ instanceof File) {
                this.load((File)this.address_);
            } else if (this.address_ instanceof URL) {
                this.load((URL)this.address_);
            } else {
                throw new RuntimeException("Unknown library item address type.");
            }
        }
        return this.item_;
    }

    LocType getLocType() {
        return this.loctype_;
    }

    Object getAddress() {
        return this.address_;
    }

    boolean isInUserLib() {
        return this.loctype_ == LocType.USERLIB;
    }

    protected abstract void load(File var1);

    protected abstract void load(URL var1);

    public boolean isFavorite() {
        return this.favorite_;
    }

    public void setFavorite(boolean fave) {
        this.favorite_ = fave;
    }

    public static enum LocType {
        INCODE,
        JAR,
        USERLIB,
        OTHER;

    }
}

