/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.util;

import gov.nasa.giss.graphics.GraphicUtils;
import gov.nasa.giss.io.FileUtils;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.util.JarUtils;
import gov.nasa.giss.util.PlatformUtils;
import gov.nasa.giss.util.ResourceListDataEvent;
import gov.nasa.giss.util.ResourceListDataListener;
import gov.nasa.giss.util.ResourceListEntry;
import java.awt.Component;
import java.awt.EventQueue;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.text.CollationKey;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Objects;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.event.EventListenerList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ResourceList {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected static final EntryComparator FS_COMPARATOR = new EntryComparator();
    private FilenameFilter ffilter_;
    private static boolean appSupportDisabled_;
    private boolean appSupportFailed_;
    private ArrayList<ResourceListEntry> alist_;
    private EventListenerList listeners_;

    protected ResourceList(FilenameFilter ff) {
        this.ffilter_ = ff;
        this.alist_ = new ArrayList(50);
        this.listeners_ = new EventListenerList();
    }

    public void scanJarDirectory(ResourceList o, String dirName) {
        if (o == null) {
            return;
        }
        this.scanJarDirectory(o.getClass(), dirName);
    }

    public void scanJarDirectory(Class<?> c, String dirName) {
        String[] fnames;
        block8: {
            fnames = null;
            try {
                fnames = JarUtils.getResourceListing(c, dirName);
            }
            catch (Exception exc) {
                LOGGER.info("Exception scanning resource jar directory: {}", (Object)exc.toString());
                if (!LOGGER.isDebugEnabled()) break block8;
                exc.printStackTrace();
            }
        }
        if (fnames != null) {
            for (String s : fnames) {
                try {
                    String where = dirName + "/" + s;
                    URL url = c.getResource(where);
                    if (url == null) {
                        LOGGER.info("No resource at {}", (Object)where);
                        continue;
                    }
                    this.addToArrayList(null, ResourceListEntry.LocType.JAR, url, null);
                }
                catch (Exception exc) {
                    LOGGER.info("Could not open resource {} due to {}", (Object)s, (Object)exc.toString());
                    if (LOGGER.isDebugEnabled()) {
                        exc.printStackTrace();
                    }
                    System.exit(1);
                }
            }
        }
    }

    public static void disableAppSupportDirectory() {
        appSupportDisabled_ = true;
    }

    protected void scanAppSupportDirectory(String dirName) {
        if (appSupportDisabled_) {
            this.appSupportFailed_ = true;
            return;
        }
        File appSupport = null;
        try {
            appSupport = this.findAppSupportDirectory(dirName);
        }
        catch (Exception exc) {
            this.appSupportFailed_ = true;
            return;
        }
        if (this.appSupportFailed_) {
            return;
        }
        if (appSupport == null) {
            return;
        }
        if (!appSupport.exists()) {
            return;
        }
        if (!appSupport.isDirectory()) {
            return;
        }
        for (File file : appSupport.listFiles(this.ffilter_)) {
            if (file.isDirectory() || file.getName().startsWith(".")) continue;
            try {
                this.addToArrayList(null, ResourceListEntry.LocType.USERLIB, file, null);
            }
            catch (Exception exc) {
                if (!LOGGER.isDebugEnabled()) continue;
                exc.printStackTrace();
            }
        }
    }

    private File findAppSupportDirectory(String dirName) {
        boolean created;
        if (this.appSupportFailed_) {
            return null;
        }
        Objects.requireNonNull(dirName, "Resource directory name cannot be null.");
        if (dirName.isEmpty()) {
            throw new IllegalArgumentException("Empty resource directory name.");
        }
        File dir = FileUtils.getGISSAppSupportSubdirectory(dirName);
        if (dir == null) {
            return null;
        }
        if (!dir.exists() && !(created = dir.mkdirs())) {
            this.appSupportFailed_ = true;
            return null;
        }
        return dir;
    }

    public abstract String getResourceDescription();

    public abstract String getResourceDescriptionPlural();

    public abstract String getAppSupportDirectoryName();

    public int getSize() {
        return this.alist_.size();
    }

    public ResourceListEntry getElementAt(int index) {
        if (index < 0 || index >= this.alist_.size()) {
            throw new IndexOutOfBoundsException("Index " + index + " out of range");
        }
        return this.alist_.get(index);
    }

    public ResourceListEntry getElement(String name) {
        Objects.requireNonNull(name, "Name cannot be null.");
        for (ResourceListEntry ii : this.alist_) {
            if (!name.equalsIgnoreCase(ii.getName())) continue;
            return ii;
        }
        return null;
    }

    public Object getBackingObject(int index) {
        try {
            return this.alist_.get(index).getObject();
        }
        catch (Exception exc) {
            ResourceListEntry ee = this.getElementAt(index);
            String ename = ee.toString();
            if (PlatformUtils.isHeadless()) {
                LOGGER.error("Could not retrieve resource object for {}", (Object)ename);
            }
            return null;
        }
    }

    public Object getBackingObject(String name) {
        Objects.requireNonNull(name, "Search term cannot be null.");
        for (ResourceListEntry ii : this.alist_) {
            if (!name.equalsIgnoreCase(ii.getName())) continue;
            return ii.getObject();
        }
        return null;
    }

    public String getName(int index) {
        if (index < 0 || index >= this.alist_.size()) {
            throw new IndexOutOfBoundsException("Index " + index + " out of range");
        }
        return this.alist_.get(index).getName();
    }

    public boolean isFavorite(int index) {
        if (index < 0 || index >= this.alist_.size()) {
            throw new IndexOutOfBoundsException("Index " + index + " out of range");
        }
        return this.alist_.get(index).isFavorite();
    }

    public void setFavorite(int index, boolean fave) {
        if (index < 0 || index >= this.alist_.size()) {
            throw new IndexOutOfBoundsException("Index " + index + " out of range");
        }
        this.alist_.get(index).setFavorite(fave);
    }

    public ResourceListEntry.LocType getLocType(int index) {
        if (index < 0 || index >= this.alist_.size()) {
            throw new IndexOutOfBoundsException("Index " + index + " out of range");
        }
        return this.alist_.get(index).getLocType();
    }

    public Object[] addAlphabetic(ArrayList<File> flist) {
        if (flist.size() == 0) {
            return null;
        }
        return this.addAlphabetic(flist.toArray(new File[0]));
    }

    public Object[] addAlphabetic(File ... files) {
        JFrame jff = null;
        if (!GraphicUtils.isHeadless() && (jff = GuiUtils.getActiveFrame()) == null) {
            jff = new JFrame();
        }
        return this.addAlphabetic((Component)jff, files);
    }

    public Object[] addAlphabetic(Component source, ArrayList<File> flist) {
        if (flist.size() == 0) {
            return null;
        }
        return this.addAlphabetic(source, flist.toArray(new File[0]));
    }

    public Object[] addAlphabetic(Component source, File ... files) {
        if (source == null) {
            return this.addAlphabetic(null, false, files);
        }
        EventQueue.invokeLater(() -> {
            Object[] options = new String[]{"Okay", "No"};
            String count = files.length > 1 ? this.getResourceDescriptionPlural() : this.getResourceDescription();
            int choice = JOptionPane.showOptionDialog(source, "Should I import the " + count + " into your support\nlibrary for future use?", "Library", 0, 3, null, options, 0);
            boolean importToLib = choice == 0;
            this.addAlphabetic(source, importToLib, files);
        });
        return null;
    }

    public Object[] addAlphabetic(Component source, boolean importToLib, File ... files) {
        ArrayList<Object> added = new ArrayList<Object>();
        for (File f : files) {
            String fname = f.getName();
            LOGGER.info("Attempting to add {}", (Object)fname);
            if (this.getElement(fname) != null) {
                LOGGER.warn("Already an entry with name {} in ResourceList. Skipping.", (Object)fname);
                continue;
            }
            Object o = null;
            try {
                o = this.createObject(f);
                LOGGER.trace("... added");
            }
            catch (Exception exc) {
                if (source == null) {
                    LOGGER.warn("Could not open {} {}.", (Object)this.getResourceDescription(), (Object)fname);
                    LOGGER.warn("Message is {}", (Object)exc.toString());
                }
                String msg = exc.toString().replaceFirst(".*Exception: ", "");
                FileUtils.showFileError(source, fname, msg);
            }
            if (o != null) {
                if (importToLib) {
                    File xf = this.copyToAppSupportDirectory(source, f, this.getAppSupportDirectoryName(), false);
                    if (xf != null) {
                        this.addToArrayList(source, ResourceListEntry.LocType.USERLIB, xf, o);
                    }
                } else {
                    this.addToArrayList(source, ResourceListEntry.LocType.OTHER, f, o);
                }
            }
            if (o == null) continue;
            added.add(o);
        }
        return added.toArray(new Object[0]);
    }

    private Object addToArrayList(Component source, ResourceListEntry.LocType loctype, Object address, Object o) {
        Objects.requireNonNull(address, "Address cannot be null.");
        ResourceListEntry info = this.createSetEntry(loctype, address, o);
        int isize = this.getSize();
        for (int i = 0; i < isize; ++i) {
            int compare = FS_COMPARATOR.compare(info, this.getElementAt(i));
            if (compare == 0) {
                LOGGER.warn("Item {} - {} already in fileset.", address, o);
                return this.getBackingObject(i);
            }
            if (compare >= 0) continue;
            this.alist_.add(i, info);
            this.fireIntervalAdded(source, i);
            return o;
        }
        this.alist_.add(info);
        this.fireIntervalAdded(source, isize);
        return o;
    }

    protected abstract Object createObject(File var1);

    protected abstract ResourceListEntry createSetEntry(ResourceListEntry.LocType var1, Object var2, Object var3);

    public Object[] toArray() {
        int isize = this.alist_.size();
        Object[] result = new Object[isize];
        for (int i = 0; i < isize; ++i) {
            result[i] = this.getBackingObject(i);
        }
        return result;
    }

    public String[] getNames() {
        int isize = this.alist_.size();
        String[] result = new String[isize];
        for (int i = 0; i < isize; ++i) {
            result[i] = this.getBackingObject(i).toString();
        }
        return result;
    }

    public boolean canRemove(int index) {
        ResourceListEntry.LocType loctype = this.getLocType(index);
        if (loctype == null) {
            return false;
        }
        return loctype == ResourceListEntry.LocType.USERLIB || loctype == ResourceListEntry.LocType.OTHER;
    }

    public Object remove(int index) {
        ResourceListEntry info;
        block7: {
            if (index < 0 || index >= this.alist_.size()) {
                throw new IndexOutOfBoundsException("Index " + index + " out of range");
            }
            LOGGER.trace("removing {}", (Object)index);
            info = this.alist_.remove(index);
            this.fireIntervalRemoved(null, index);
            ResourceListEntry.LocType grp = info.getLocType();
            if (grp == ResourceListEntry.LocType.USERLIB) {
                try {
                    File f = (File)info.getAddress();
                    if (f.exists()) {
                        f.delete();
                    }
                }
                catch (Exception exc) {
                    LOGGER.trace("Failed to delete resource item: {}", (Object)exc.toString());
                    if (!LOGGER.isDebugEnabled()) break block7;
                    exc.printStackTrace();
                }
            }
        }
        try {
            return info.getObject();
        }
        catch (Exception exc) {
            return null;
        }
    }

    public void printList() {
        for (ResourceListEntry ii : this.alist_) {
            System.out.println(ii.toString());
        }
    }

    private File copyToAppSupportDirectory(Component source, File input, String outputDirName, boolean overwrite) {
        if (this.appSupportFailed_) {
            LOGGER.trace("Cannot save resource to library because we do not have access.");
            return null;
        }
        try {
            return this.copyToAppSupportDirectory(input, outputDirName, overwrite);
        }
        catch (Exception exc) {
            if (source != null && exc.toString().contains("already exists")) {
                GuiUtils.showSlowMessage(source, "Library Error", "There is already a resource by that name in the support directory.");
            } else if (exc.toString().contains("already exists")) {
                LOGGER.debug("There is already a resource by that name in the library.");
            } else {
                LOGGER.debug("Could not save resource to library: {}", (Object)exc.toString());
            }
            return null;
        }
    }

    private File copyToAppSupportDirectory(File input, String outputDirName, boolean overwrite) throws IOException {
        if (this.appSupportFailed_) {
            LOGGER.debug("Cannot save resource to library because we do not have access.");
            return null;
        }
        File appSupport = null;
        try {
            appSupport = this.findAppSupportDirectory(outputDirName);
        }
        catch (Exception exc) {
            return null;
        }
        if (appSupport == null) {
            return null;
        }
        if (!appSupport.exists()) {
            return null;
        }
        if (!appSupport.isDirectory()) {
            return null;
        }
        Objects.requireNonNull(input, "Resource file cannot be null.");
        if (!input.isFile()) {
            throw new IllegalArgumentException("Input is not a file.");
        }
        String name = input.getName();
        File output = new File(appSupport, name);
        if (output.exists() && !overwrite) {
            throw new IOException("Resource by that name already exists in the support directory");
        }
        try (FileInputStream fis = new FileInputStream(input);
             FileOutputStream fos = new FileOutputStream(output);
             FileChannel inputChannel = fis.getChannel();
             FileChannel outputChannel = fos.getChannel();){
            outputChannel.transferFrom(inputChannel, 0L, inputChannel.size());
        }
        return output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListDataListener(ResourceListDataListener l) {
        EventListenerList eventListenerList = this.listeners_;
        synchronized (eventListenerList) {
            this.listeners_.add(ResourceListDataListener.class, l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListDataListener(ResourceListDataListener l) {
        EventListenerList eventListenerList = this.listeners_;
        synchronized (eventListenerList) {
            this.listeners_.remove(ResourceListDataListener.class, l);
        }
    }

    private void fireContentsChanged(Component component) {
        ResourceListDataEvent e = new ResourceListDataEvent(this, component, 0, 0, -1);
        for (ResourceListDataListener l : (ResourceListDataListener[])this.listeners_.getListeners(ResourceListDataListener.class)) {
            l.contentsChanged(e);
        }
    }

    private void fireIntervalAdded(Component component, int index) {
        ResourceListDataEvent e = new ResourceListDataEvent(this, component, 1, index, index);
        for (ResourceListDataListener l : (ResourceListDataListener[])this.listeners_.getListeners(ResourceListDataListener.class)) {
            l.intervalAdded(e);
        }
    }

    private void fireIntervalRemoved(Component component, int index) {
        ResourceListDataEvent e = new ResourceListDataEvent(this, component, 2, index, index);
        for (ResourceListDataListener l : (ResourceListDataListener[])this.listeners_.getListeners(ResourceListDataListener.class)) {
            l.intervalRemoved(e);
        }
    }

    protected static class EntryComparator
    implements Comparator<ResourceListEntry> {
        private Collator collator_ = Collator.getInstance();

        protected EntryComparator() {
        }

        @Override
        public int compare(ResourceListEntry o1, ResourceListEntry o2) {
            CollationKey k1 = this.collator_.getCollationKey(o1.toString());
            CollationKey k2 = this.collator_.getCollationKey(o2.toString());
            return k1.compareTo(k2);
        }
    }
}

