/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.ui.windoid;

import gov.nasa.giss.ui.windoid.WindoidHeaderMouseAdapter;
import gov.nasa.giss.util.PlatformUtils;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.lang.invoke.MethodHandles;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WindoidHeader
extends JComponent {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static ImageIcon backgroundIcon_;
    private static ImageIcon inactiveIcon_;
    private static ImageIcon semiactiveIcon_;
    private static ImageIcon closeIcon_;
    private static ImageIcon resizeIcon_;
    private static Image backgroundImage_;
    private static Image inactiveImage_;
    private static Image semiactiveImage_;
    private static Image closeImage_;
    private static Image resizeImage_;
    private String title_;
    private int titleWidth_;
    private int lineHeight_;
    private int lineAscent_;
    private boolean measured_;
    private int whHeight_;
    private int btnWidth_;
    private int btnsWidth_;
    private int closeLeft_ = -1000;
    private int hideLeft_ = -1000;
    private int resizeLeft_ = -1000;
    private boolean resizeVisible_;
    private boolean closeable_;
    private boolean resizeable_;
    private boolean closeHighlighted_;
    private boolean resizeHighlighted_;

    public WindoidHeader(String title, boolean closeable) {
        this.title_ = title;
        this.setCloseable(closeable);
        try {
            if (backgroundImage_ == null) {
                Class<?> c = this.getClass();
                backgroundIcon_ = new ImageIcon(c.getResource("resources/hed_background.png"));
                if (PlatformUtils.isMacintosh()) {
                    inactiveIcon_ = new ImageIcon(c.getResource("resources/hed_inactive.png"));
                    semiactiveIcon_ = new ImageIcon(c.getResource("resources/hed_semiactive.png"));
                    closeIcon_ = new ImageIcon(c.getResource("resources/hed_close.png"));
                    resizeIcon_ = new ImageIcon(c.getResource("resources/hed_resize.png"));
                    this.resizeVisible_ = true;
                } else {
                    inactiveIcon_ = new ImageIcon(c.getResource("resources/hed_inactive_win.png"));
                    semiactiveIcon_ = new ImageIcon(c.getResource("resources/hed_semiactive_win.png"));
                    closeIcon_ = new ImageIcon(c.getResource("resources/hed_close_win.png"));
                    resizeIcon_ = null;
                    this.resizeVisible_ = false;
                }
                backgroundImage_ = backgroundIcon_.getImage();
                inactiveImage_ = inactiveIcon_.getImage();
                semiactiveImage_ = semiactiveIcon_.getImage();
                closeImage_ = closeIcon_.getImage();
                if (this.resizeVisible_) {
                    resizeImage_ = resizeIcon_.getImage();
                }
            }
            this.whHeight_ = backgroundIcon_.getIconHeight();
            this.btnWidth_ = semiactiveIcon_.getIconWidth();
            this.btnsWidth_ = this.resizeVisible_ ? 3 * this.btnWidth_ + 6 : 2 * this.btnWidth_ + 3;
        }
        catch (Exception exc) {
            LOGGER.warn("Windoid header load error; ignoring all icons");
            if (LOGGER.isDebugEnabled()) {
                exc.printStackTrace();
            }
            this.btnsWidth_ = 0;
        }
        this.setBorder(null);
        this.setLayout(null);
        Font f = UIManager.getDefaults().getFont("Label.font");
        if (f != null) {
            f = f.deriveFont((float)((double)this.whHeight_ * 3.0 / 4.0));
            this.setFont(f);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        if (!this.measured_) {
            this.measure();
        }
        int tw = Math.max(50, this.titleWidth_) + 16;
        return new Dimension(4 + this.btnsWidth_ + tw + this.btnsWidth_ + 4, this.whHeight_);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getMaximumSize() {
        Dimension d = new Dimension(this.getPreferredSize());
        d.width = 4000;
        return d;
    }

    public void addStandardMouseAdapter() {
        LOGGER.trace("");
        this.addMouseAdapter(new WindoidHeaderMouseAdapter(this));
    }

    public void addMouseAdapter(WindoidHeaderMouseAdapter whma) {
        this.addMouseListener(whma);
        this.addMouseMotionListener(whma);
    }

    public boolean isCloseable() {
        return this.closeable_;
    }

    public void setCloseable(boolean closeable) {
        this.closeable_ = closeable;
    }

    public void setCloseHighlighted(boolean highlighted) {
        this.closeHighlighted_ = highlighted;
    }

    public boolean isResizeable() {
        return this.resizeable_;
    }

    public void setResizeable(boolean resizeable) {
        this.resizeable_ = resizeable;
    }

    public void setResizeHighlighted(boolean highlighted) {
        this.resizeHighlighted_ = highlighted;
    }

    @Override
    public void paintComponent(Graphics g) {
        int w = this.getWidth();
        int h = this.getHeight();
        if (backgroundImage_ != null) {
            g.drawImage(backgroundImage_, 0, 0, w, h, this);
        }
        if (closeImage_ != null) {
            if (PlatformUtils.isMacintosh()) {
                this.closeLeft_ = 4;
                this.hideLeft_ = this.closeLeft_ + this.btnWidth_ + 3;
                this.resizeLeft_ = this.hideLeft_ + this.btnWidth_ + 3;
            } else {
                this.closeLeft_ = w - 4 - this.btnWidth_;
                this.hideLeft_ = this.closeLeft_ - 3 - this.btnWidth_;
                this.resizeLeft_ = -1000;
            }
            if (this.closeHighlighted_) {
                g.drawImage(closeImage_, this.closeLeft_, 0, this);
            } else if (this.closeable_) {
                g.drawImage(semiactiveImage_, this.closeLeft_, 0, this);
            } else {
                g.drawImage(inactiveImage_, this.closeLeft_, 0, this);
            }
            g.drawImage(inactiveImage_, this.hideLeft_, 0, this);
            if (this.resizeVisible_) {
                if (this.resizeHighlighted_) {
                    g.drawImage(resizeImage_, this.resizeLeft_, 0, this);
                } else if (this.resizeable_) {
                    g.drawImage(semiactiveImage_, this.resizeLeft_, 0, this);
                } else {
                    g.drawImage(inactiveImage_, this.resizeLeft_, 0, this);
                }
            }
        }
        if (this.titleWidth_ > 0) {
            int x = Math.max(0, (this.getSize().width - this.titleWidth_) / 2);
            int y = (this.getSize().height - this.lineHeight_) / 2 + this.lineAscent_;
            g.drawString(this.title_, x, y);
        }
    }

    private void measure() {
        if (this.title_ == null || this.title_.length() == 0) {
            this.titleWidth_ = 0;
        } else {
            FontMetrics fm = this.getFontMetrics(this.getFont());
            this.lineHeight_ = fm.getHeight();
            this.lineAscent_ = fm.getAscent();
            this.titleWidth_ = fm.stringWidth(this.title_);
        }
        this.measured_ = true;
    }

    public boolean inCloseButton(Point p) {
        if (!this.closeable_) {
            return false;
        }
        return p.x >= this.closeLeft_ && p.x < this.closeLeft_ + this.btnWidth_;
    }

    public boolean inResizeButton(Point p) {
        if (!this.resizeVisible_ || !this.resizeable_) {
            return false;
        }
        return p.x >= this.resizeLeft_ && p.x < this.resizeLeft_ + this.btnWidth_;
    }
}

