/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.ui.menu;

import gov.nasa.giss.ui.menu.GissMenu;
import javax.swing.Action;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

public class GissMenuBar
extends JMenuBar {
    public GissMenu getMenuByName(String propertyID) {
        int isize = this.getMenuCount();
        for (int i = 0; i < isize; ++i) {
            if (this.getMenu(i).getName().equals(propertyID)) {
                return (GissMenu)this.getMenu(i);
            }
            JMenuItem c = ((GissMenu)this.getMenu(i)).getItemByName(propertyID);
            if (c == null || !(c instanceof GissMenu)) continue;
            return (GissMenu)c;
        }
        return null;
    }

    public JMenuItem getItemByName(String menuName, String itemName) {
        GissMenu m = this.getMenuByName(menuName);
        if (m == null) {
            return null;
        }
        return m.getItemByName(itemName);
    }

    public JMenuItem getItemByText(String menuName, String itemText) {
        GissMenu m = this.getMenuByName(menuName);
        if (m == null) {
            return null;
        }
        return m.getItemByText(itemText);
    }

    public Action getItemActionByName(String menuName, String itemName) {
        JMenuItem jmi = this.getItemByName(menuName, itemName);
        if (jmi == null) {
            return null;
        }
        return jmi.getAction();
    }

    public JMenuItem getItemByKeyStroke(KeyStroke ks) {
        int isize = this.getMenuCount();
        for (int i = 0; i < isize; ++i) {
            JMenuItem found = ((GissMenu)this.getMenu(i)).getItemByKeyStroke(ks);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    public void refresh() {
        int isize = this.getMenuCount();
        for (int i = 0; i < isize; ++i) {
            if (this.getMenu(i) == null || !(this.getMenu(i) instanceof GissMenu)) continue;
            ((GissMenu)this.getMenu(i)).refresh();
        }
    }
}

