/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.ui;

import gov.nasa.giss.ui.BrushMetalUtils;
import gov.nasa.giss.ui.WindowDragger;
import gov.nasa.giss.ui.border.FocusStateMatteBorder;
import gov.nasa.giss.util.PlatformUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.MatteBorder;

public class BottomBar
extends JPanel {
    private static final int VERT_PADDING = 1;
    private static final int HORZ_PADDING = 5;
    private int size_;

    public BottomBar() {
        this(16);
    }

    public BottomBar(int size) {
        this.size_ = size;
        this.setOpaque(!PlatformUtils.isMacintosh());
        this.setLayout(new BoxLayout(this, 0));
        if (PlatformUtils.isMacintosh()) {
            WindowDragger dragger = new WindowDragger(this);
            this.addMouseListener(dragger);
            this.addMouseMotionListener(dragger);
        }
    }

    public void setSize(int size) {
        this.size_ = size;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(10, this.size_);
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(10, this.size_);
    }

    @Override
    public Dimension getMaximumSize() {
        return new Dimension(5000, this.size_);
    }

    @Override
    protected void paintComponent(Graphics g) {
    }

    @Override
    public Insets getInsets() {
        return new Insets(3, 5, 1, 5);
    }

    @Override
    public void setBorder(Border border) {
    }

    @Override
    public Border getBorder() {
        Color focusedColor = BrushMetalUtils.getShadowColor(true);
        Color unfocusedColor = BrushMetalUtils.getShadowColor(false);
        Color highlightColor = BrushMetalUtils.getHighlightColor();
        FocusStateMatteBorder topDarkBorder = new FocusStateMatteBorder(1, 0, 0, 0, focusedColor, unfocusedColor);
        MatteBorder topLightBorder = BorderFactory.createMatteBorder(1, 0, 0, 0, highlightColor);
        CompoundBorder topBorder = BorderFactory.createCompoundBorder(topDarkBorder, topLightBorder);
        Border innerBorder = BorderFactory.createEmptyBorder(1, 5, 1, 5);
        return BorderFactory.createCompoundBorder(topBorder, innerBorder);
    }
}

