/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.time.mission;

import gov.nasa.giss.time.mission.MarsLanderID;
import gov.nasa.giss.time.mission.MarsLanderTime;
import gov.nasa.giss.time.mission.MissionStatus;
import gov.nasa.giss.time.planet.MarsTime;

public class MarsVikingLander
extends MarsLanderTime {
    private static final long VIKING1_LAUNCH_MILLIS = 177801720000L;
    private static final String VIKING1_LANDING_STRING = "1976-07-20 11:53:06";
    private static final String VIKING1_LANDING_ERT_STRING = "1976-07-20 11:34:05";
    private static final long VIKING1_LANDING_MILLIS = 206711586000L;
    private static final double VIKING1_T0 = -7.40074758816E8;
    private static final long VIKING2_LAUNCH_MILLIS = 179519940000L;
    private static final String VIKING2_LANDING_STRING = "1976-09-03 22:37:50";
    private static final String VIKING2_LANDING_ERT_STRING = "1976-09-03 22:17:19";
    private static final long VIKING2_LANDING_MILLIS = 210638270000L;
    private static final double VIKING2_T0 = -7.36125027816E8;
    private boolean isViking1_ = true;
    private long launchMillis_;
    private long landingMillis_;
    private long descentMillis_;
    private double t0_;

    private MarsVikingLander() {
        super("Viking Lander 1");
    }

    public MarsVikingLander(MarsLanderID lid, MarsTime marsTime) {
        super(lid.toString(), marsTime);
        if (lid == MarsLanderID.VL1) {
            this.isViking1_ = true;
        } else if (lid == MarsLanderID.VL2) {
            this.isViking1_ = false;
        } else {
            throw new IllegalArgumentException("Lander ID is not a Viking mission");
        }
        this.launchMillis_ = this.isViking1_ ? 177801720000L : 179519940000L;
        this.landingMillis_ = this.isViking1_ ? 206711586000L : 210638270000L;
        this.descentMillis_ = this.landingMillis_ - 300000L;
        this.t0_ = this.isViking1_ ? -7.40074758816E8 : -7.36125027816E8;
    }

    @Override
    protected void update() {
        long millis = this.mTime_.getMillis();
        if (millis < this.launchMillis_) {
            this.status_ = MissionStatus.NOT_LAUNCHED;
            this.sol_ = Long.MIN_VALUE;
            this.fraction_ = 0.0;
            return;
        }
        double lltSec = (this.mTime_.getJ2000Seconds() - this.t0_) * 0.9732442960905843;
        double llt = lltSec * 1.1574074074074073E-5;
        this.sol_ = (long)Math.floor(llt);
        this.fraction_ = llt - (double)this.sol_;
        this.status_ = millis < this.descentMillis_ ? MissionStatus.IN_FLIGHT : (millis < this.landingMillis_ ? MissionStatus.DESCENDING : MissionStatus.ACTIVE);
        this.needsUpdate_ = false;
    }
}

