/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.time;

import gov.nasa.giss.time.CalendarUtils;
import gov.nasa.giss.time.ClimateModelCalendar;
import gov.nasa.giss.time.PatternTime;
import gov.nasa.giss.time.TimeFormatter;
import gov.nasa.giss.time.TimePatterns;
import java.lang.invoke.MethodHandles;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.SimpleTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RelativeTime
implements PatternTime,
TimeFormatter {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private int incrementField_;
    private boolean fractionalIncrements_;
    private SimpleDateFormat outputFormatter_;
    private Date epoch_;
    private Calendar calendar_;
    private boolean zeroBasedYear_;

    public RelativeTime(String units) throws ParseException {
        this(units, "gregorian", false);
    }

    public RelativeTime(String units, String calendarName) throws ParseException {
        this(units, calendarName, false);
    }

    public RelativeTime(String units, String calendarName, boolean fractional) throws ParseException {
        this.initMe(units, calendarName, fractional);
    }

    protected void initMe(String units, String calendarName, boolean fractional) throws ParseException {
        int firstDash;
        this.fractionalIncrements_ = fractional;
        if (units == null || units.isEmpty()) {
            throw new IllegalArgumentException("Variable has no units!");
        }
        String lcunits = units.toLowerCase();
        int sinceIndex = lcunits.indexOf(" since ");
        if (sinceIndex < 1) {
            throw new ParseException("Not relative time units", -1);
        }
        this.initIncrementUnits(units);
        this.calendar_ = CalendarUtils.getCalendar(calendarName);
        String originString = units.substring(sinceIndex + 7);
        if (this.calendar_ instanceof ClimateModelCalendar && (firstDash = originString.indexOf(45)) > 0) {
            String ystr = originString.substring(0, firstDash);
            try {
                ystr = ystr.replaceAll("\\D", "");
                int year = Integer.parseInt(ystr);
                if (year == 0) {
                    this.zeroBasedYear_ = true;
                    originString = "0001" + originString.substring(firstDash);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (originString.matches(".* \\+\\d\\d:.*")) {
            originString = originString.replaceAll(" \\+", " GMT+");
        } else if (originString.matches(".* \\-\\d\\d:.*")) {
            originString = originString.replaceAll(" \\-", "GMT-");
        }
        this.initFormat(originString);
    }

    private void initIncrementUnits(String units) throws ParseException {
        String lcunits = units.toLowerCase();
        if (lcunits.startsWith("year")) {
            this.incrementField_ = 1;
        } else if (lcunits.startsWith("month")) {
            this.incrementField_ = 2;
        } else if (lcunits.startsWith("day")) {
            this.incrementField_ = 5;
        } else if (lcunits.startsWith("hour")) {
            this.incrementField_ = 10;
        } else if (lcunits.startsWith("minute")) {
            this.incrementField_ = 12;
        } else if (lcunits.startsWith("sec")) {
            this.incrementField_ = 13;
        } else if (lcunits.startsWith("msec") || lcunits.startsWith("millisec")) {
            this.incrementField_ = 14;
        } else {
            throw new ParseException("I don't know how to handle units '" + units + "'", -1);
        }
    }

    private void initFormat(String originString) throws ParseException {
        this.outputFormatter_ = new SimpleDateFormat();
        this.outputFormatter_.setLenient(true);
        this.outputFormatter_.setCalendar(this.calendar_);
        String matchedFormat = null;
        String outputFormat = null;
        boolean hasTimeZone = false;
        for (String pattern : TimePatterns.PATTERNS) {
            try {
                this.outputFormatter_.applyPattern(pattern);
                this.epoch_ = this.outputFormatter_.parse(originString);
                matchedFormat = pattern;
                hasTimeZone = matchedFormat.toLowerCase().contains("z") || originString.endsWith("UTC");
                this.outputFormatter_.applyPattern("yyyy-MM-dd HH:mm:ss.SSS");
                if (this.incrementField_ == 14) {
                    outputFormat = "yyyy-MM-dd HH:mm:ss.SSS";
                    break;
                }
                this.calendar_.setTime(this.epoch_);
                if (this.calendar_.get(14) != 0) {
                    outputFormat = "yyyy-MM-dd HH:mm:ss.SSS";
                    break;
                }
                this.outputFormatter_.applyPattern("yyyy-MM-dd HH:mm:ss");
                if (this.incrementField_ == 14 || this.incrementField_ == 13) {
                    outputFormat = "yyyy-MM-dd HH:mm:ss";
                    break;
                }
                this.calendar_.setTime(this.epoch_);
                if (this.calendar_.get(13) != 0) {
                    outputFormat = "yyyy-MM-dd HH:mm:ss";
                    break;
                }
                this.outputFormatter_.applyPattern("yyyy-MM-dd HH:mm");
                if (this.calendar_.get(12) != 0 || this.incrementField_ == 12) {
                    outputFormat = "yyyy-MM-dd HH:mm";
                    if (!this.fractionalIncrements_) break;
                    outputFormat = "yyyy-MM-dd HH:mm:ss";
                    break;
                }
                if (this.incrementField_ == 5 && pattern.contains("mm")) {
                    outputFormat = "yyyy-MM-dd HH:mm";
                    break;
                }
                this.outputFormatter_.applyPattern("yyyy-MM-dd HH");
                if (this.calendar_.get(10) != 0 || this.incrementField_ == 10) {
                    outputFormat = "yyyy-MM-dd HH:mm";
                    break;
                }
                this.outputFormatter_.applyPattern("yyyy-MM-dd");
                if (this.calendar_.get(5) != 1 || this.incrementField_ == 5) {
                    outputFormat = "yyyy-MM-dd";
                    break;
                }
                this.outputFormatter_.applyPattern("yyyy-MM");
                outputFormat = "yyyy-MM";
                if (outputFormat.startsWith("yyyy-MM-dd")) {
                    outputFormat = "yyyy-MM-dd HH:mm";
                    break;
                }
                if (!outputFormat.startsWith("yyyy-MM")) break;
                outputFormat = "yyyy-MM-dd";
                break;
            }
            catch (Exception exception) {
            }
        }
        if (matchedFormat == null) {
            throw new ParseException("Cannot parse '" + originString + "'", -1);
        }
        if (hasTimeZone) {
            outputFormat = outputFormat + " Z";
        }
        this.outputFormatter_.applyPattern(outputFormat);
        if (hasTimeZone && originString.endsWith("UTC")) {
            SimpleTimeZone utc = new SimpleTimeZone(0, "UTC");
            this.calendar_.setTimeZone(utc);
            this.outputFormatter_.setTimeZone(utc);
        }
    }

    @Override
    public String getPattern() {
        return this.outputFormatter_.toPattern();
    }

    @Override
    public void applyPattern(String pattern) {
        this.outputFormatter_.applyPattern(pattern);
    }

    @Override
    public String format(Number delta) {
        if (delta instanceof Long || delta instanceof Integer || delta instanceof Short) {
            return this.format(delta.longValue());
        }
        return this.format(delta.doubleValue());
    }

    @Override
    public String format(long delta) {
        this.applyOffset(this.incrementField_, delta);
        return this.formatDate();
    }

    @Override
    public String format(double delta) {
        if (delta == Double.NaN) {
            throw new IllegalArgumentException("Cannot add NaN value.");
        }
        if (Double.isInfinite(delta)) {
            throw new IllegalArgumentException("Cannot add infinite value.");
        }
        if (delta > 9.223372036854776E18) {
            LOGGER.error("Relative format error: {} > Long.MAX_VALUE", (Object)delta);
            throw new IllegalArgumentException("Time delta out of valid range.");
        }
        double whole = Math.floor(delta);
        if (delta == whole) {
            return this.format((long)delta);
        }
        this.applyOffset(this.incrementField_, (long)whole);
        double fraction = delta - whole;
        double seconds = 0.0;
        if (this.incrementField_ == 1) {
            seconds = fraction * 12.0 * 30.0 * 24.0 * 60.0 * 60.0;
        } else if (this.incrementField_ == 2) {
            seconds = fraction * 30.0 * 24.0 * 60.0 * 60.0;
        } else if (this.incrementField_ == 5) {
            seconds = fraction * 24.0 * 60.0 * 60.0;
        } else if (this.incrementField_ == 10) {
            seconds = fraction * 60.0 * 60.0;
        } else if (this.incrementField_ == 12) {
            seconds = fraction * 60.0;
        }
        RelativeTime.applyOffset(13, (long)seconds, this.calendar_);
        return this.formatDate();
    }

    private void applyOffset(int field, long delta) {
        this.calendar_.setTime(this.epoch_);
        RelativeTime.applyOffset(field, delta, this.calendar_);
    }

    private static void applyOffset(int field, long delta, Calendar cal) {
        if (delta == 0L) {
            return;
        }
        if (delta < Integer.MAX_VALUE && delta > Integer.MIN_VALUE) {
            cal.add(field, (int)delta);
        } else if (delta >= Integer.MAX_VALUE) {
            long d;
            LOGGER.trace("{} > MAX_INT", (Object)delta);
            for (d = delta; d > 2147483000L; d -= 2147483000L) {
                cal.add(field, 2147483000);
            }
            cal.add(field, (int)d);
        } else {
            long d;
            LOGGER.trace("{} < MIN_INT", (Object)delta);
            for (d = delta; d < -2147483000L; d += 2147483000L) {
                cal.add(field, -2147483000);
            }
            cal.add(field, (int)d);
        }
    }

    private String formatDate() {
        Date d = this.calendar_.getTime();
        if (!this.zeroBasedYear_) {
            return this.outputFormatter_.format(d);
        }
        int year = this.calendar_.get(1);
        if (year == 1) {
            return this.outputFormatter_.format(d).replaceFirst("1", "0");
        }
        this.calendar_.set(1, year - 1);
        return this.outputFormatter_.format(this.calendar_.getTime());
    }
}

