/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.time;

import gov.nasa.giss.time.TimeFormatter;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.Objects;

public class AbsoluteTime
implements TimeFormatter {
    private static final int SECOND = 1;
    private static final int MINUTE = 2;
    private static final int HOUR = 3;
    private static final int DAY = 4;
    private static final int MONTH = 5;
    private static final int YEAR = 6;
    private int incrementField_;
    private int biggestField_;
    private int smallestField_;
    private boolean hasFraction_;
    private String unitsName_;
    private DecimalFormat nf_;

    public AbsoluteTime(String units) throws ParseException {
        Objects.requireNonNull(units, "Units cannot be null");
        if (units.isEmpty()) {
            throw new IllegalArgumentException("Units string has no units!");
        }
        int asIndex = units.indexOf(" as ");
        if (asIndex < 1) {
            throw new ParseException("Not absolute time units", -1);
        }
        this.unitsName_ = units.substring(0, asIndex);
        String formatString = units.substring(asIndex + 4);
        if (units.startsWith("year") || units.startsWith("calendar_year")) {
            this.incrementField_ = 6;
        } else if (units.startsWith("month") || units.startsWith("calendar_month")) {
            this.incrementField_ = 5;
        } else if (units.startsWith("day")) {
            this.incrementField_ = 4;
        } else if (units.startsWith("hour")) {
            this.incrementField_ = 3;
        } else if (units.startsWith("minute")) {
            this.incrementField_ = 2;
        } else if (units.startsWith("sec")) {
            this.incrementField_ = 1;
        } else {
            throw new ParseException("Unrecognized absolute time units '" + units + "'", -1);
        }
        if (formatString.contains("%f")) {
            this.hasFraction_ = true;
        }
        if (formatString.contains("%Y")) {
            this.biggestField_ = 6;
        } else if (formatString.contains("%m")) {
            this.biggestField_ = 5;
        } else if (formatString.contains("%d")) {
            this.biggestField_ = 4;
        } else if (formatString.contains("%H")) {
            this.biggestField_ = 3;
        } else if (formatString.contains("%M")) {
            this.biggestField_ = 2;
        } else if (formatString.contains("%S")) {
            this.biggestField_ = 1;
        } else if (this.hasFraction_) {
            this.biggestField_ = this.incrementField_;
        } else {
            throw new ParseException("Unrecognized absolute time format '" + formatString + "'", -1);
        }
        if (formatString.contains("%S")) {
            this.smallestField_ = 1;
        } else if (formatString.contains("%M")) {
            this.smallestField_ = 2;
        } else if (formatString.contains("%H")) {
            this.smallestField_ = 3;
        } else if (formatString.contains("%d")) {
            this.smallestField_ = 4;
        } else if (formatString.contains("%m")) {
            this.smallestField_ = 5;
        } else if (formatString.contains("%Y")) {
            this.smallestField_ = 6;
        } else if (this.hasFraction_) {
            this.smallestField_ = this.incrementField_;
        } else {
            throw new ParseException("Unrecognized absolute time format '" + formatString + "'", -1);
        }
        this.nf_ = new DecimalFormat();
    }

    public String getUnits() {
        return this.unitsName_;
    }

    @Override
    public String format(Number timeval) {
        return this.format((Double)timeval);
    }

    @Override
    public String format(long timeval) {
        return this.format((double)timeval);
    }

    @Override
    public String format(double timeval) {
        StringBuilder sb = new StringBuilder();
        double thisOne = 0.0;
        switch (this.incrementField_) {
            case 1: {
                thisOne = timeval % 100.0;
                timeval = (int)(timeval / 100.0);
                if (this.hasFraction_ && this.smallestField_ == 1) {
                    this.nf_.setMinimumFractionDigits(3);
                    this.nf_.setMaximumFractionDigits(3);
                } else {
                    this.nf_.setMinimumFractionDigits(0);
                    this.nf_.setMaximumFractionDigits(0);
                }
                if (this.biggestField_ > 1) {
                    this.nf_.setMinimumIntegerDigits(2);
                    this.nf_.setMaximumIntegerDigits(2);
                } else {
                    this.nf_.setMinimumIntegerDigits(1);
                    this.nf_.setMaximumIntegerDigits(12);
                }
                sb.insert(0, this.nf_.format(thisOne));
                if (this.biggestField_ <= 1) break;
                sb.insert(0, ":");
            }
            case 2: {
                thisOne = timeval % 100.0;
                timeval = (int)(timeval / 100.0);
                if (this.hasFraction_ && this.smallestField_ == 2) {
                    this.nf_.setMinimumFractionDigits(3);
                    this.nf_.setMaximumFractionDigits(3);
                } else {
                    this.nf_.setMinimumFractionDigits(0);
                    this.nf_.setMaximumFractionDigits(0);
                }
                if (this.biggestField_ > 2) {
                    this.nf_.setMinimumIntegerDigits(2);
                    this.nf_.setMaximumIntegerDigits(2);
                } else {
                    this.nf_.setMinimumIntegerDigits(1);
                    this.nf_.setMaximumIntegerDigits(12);
                }
                sb.insert(0, this.nf_.format(thisOne));
                if (this.biggestField_ <= 2) break;
                sb.insert(0, ":");
            }
            case 3: {
                thisOne = timeval % 100.0;
                timeval = (int)(timeval / 100.0);
                if (this.hasFraction_ && this.smallestField_ == 3) {
                    this.nf_.setMinimumFractionDigits(3);
                    this.nf_.setMaximumFractionDigits(3);
                } else {
                    this.nf_.setMinimumFractionDigits(0);
                    this.nf_.setMaximumFractionDigits(0);
                }
                if (this.biggestField_ > 3) {
                    this.nf_.setMinimumIntegerDigits(2);
                    this.nf_.setMaximumIntegerDigits(2);
                } else {
                    this.nf_.setMinimumIntegerDigits(1);
                    this.nf_.setMaximumIntegerDigits(12);
                }
                sb.insert(0, this.nf_.format(thisOne));
                if (this.biggestField_ <= 3) break;
                sb.insert(0, " ");
            }
            case 4: {
                thisOne = timeval % 100.0;
                timeval = (int)(timeval / 100.0);
                if (this.hasFraction_ && this.smallestField_ == 4) {
                    this.nf_.setMinimumFractionDigits(3);
                    this.nf_.setMaximumFractionDigits(3);
                } else {
                    this.nf_.setMinimumFractionDigits(0);
                    this.nf_.setMaximumFractionDigits(0);
                }
                if (this.biggestField_ > 4) {
                    this.nf_.setMinimumIntegerDigits(2);
                    this.nf_.setMaximumIntegerDigits(2);
                } else {
                    this.nf_.setMinimumIntegerDigits(1);
                    this.nf_.setMaximumIntegerDigits(12);
                }
                sb.insert(0, this.nf_.format(thisOne));
                if (this.biggestField_ <= 4) break;
                sb.insert(0, "-");
            }
            case 5: {
                thisOne = timeval % 100.0;
                timeval = (int)(timeval / 100.0);
                if (this.hasFraction_ && this.smallestField_ == 5) {
                    this.nf_.setMinimumFractionDigits(3);
                    this.nf_.setMaximumFractionDigits(3);
                } else {
                    this.nf_.setMinimumFractionDigits(0);
                    this.nf_.setMaximumFractionDigits(0);
                }
                if (this.biggestField_ > 5) {
                    this.nf_.setMinimumIntegerDigits(2);
                    this.nf_.setMaximumIntegerDigits(2);
                } else {
                    this.nf_.setMinimumIntegerDigits(1);
                    this.nf_.setMaximumIntegerDigits(12);
                }
                sb.insert(0, this.nf_.format(thisOne));
                if (this.biggestField_ <= 5) break;
                sb.insert(0, "-");
            }
            case 6: {
                if (this.hasFraction_ && this.smallestField_ == 6) {
                    this.nf_.setMinimumFractionDigits(3);
                    this.nf_.setMaximumFractionDigits(3);
                } else {
                    this.nf_.setMinimumFractionDigits(0);
                    this.nf_.setMaximumFractionDigits(0);
                }
                this.nf_.setMinimumIntegerDigits(1);
                this.nf_.setMaximumIntegerDigits(12);
                this.nf_.setGroupingSize(12);
                sb.insert(0, this.nf_.format(timeval));
            }
        }
        return sb.toString();
    }
}

