/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.util;

import gov.nasa.giss.graphics.ColorTableResourceList;
import gov.nasa.giss.map.OverlayFactory;
import gov.nasa.giss.map.kml.KMLDataResourceList;
import gov.nasa.giss.map.overlay.OverlayResourceList;
import gov.nasa.giss.panoply.Panoply;
import gov.nasa.giss.panoply.overlay.PanMaskOverlay;
import gov.nasa.giss.panoply.util.PanProperties;
import gov.nasa.giss.util.PlatformUtils;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PanUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final Object LOCK = new Object();
    private static String userAgent_;
    private static ColorTableResourceList colorTableSet_;
    private static OverlayResourceList overlaySet_;
    private static KMLDataResourceList kmlSet_;
    private static boolean jfxChecked_;
    private static boolean jfxEnabled_;

    public static void initProperties() {
        System.setProperty("awt.useSystemAAFontSettings", "lcd");
        System.setProperty("sun.java2d.cmm", "sun.java2d.cmm.kcms.KcmsServiceProvider");
        System.setProperty("http.agent", PanUtils.getUserAgent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getUserAgent() {
        Object object = LOCK;
        synchronized (object) {
            if (userAgent_ == null) {
                StringBuilder sb = new StringBuilder("Panoply/").append(PanProperties.VERSION_PROPS.getString("version")).append(" (").append(System.getProperty("os.name")).append(" ").append(System.getProperty("os.version")).append("; ").append("Java ").append(System.getProperty("java.version")).append(")");
                userAgent_ = sb.toString();
            }
            return userAgent_;
        }
    }

    public static boolean isJfxEnabled() {
        if (jfxChecked_) {
            return jfxEnabled_;
        }
        try {
            LOGGER.debug("Trying to initializing JavaFX.");
            Class<?> platformClass = Class.forName("javafx.application.Platform");
            Method invMethod = platformClass.getDeclaredMethod("runLater", Runnable.class);
            Runnable r = new Runnable(){

                @Override
                public void run() {
                }
            };
            invMethod.invoke(null, r);
            LOGGER.debug("Succeeded.");
            jfxEnabled_ = true;
        }
        catch (Exception exc) {
            LOGGER.debug("Failed.");
            jfxEnabled_ = false;
        }
        jfxChecked_ = true;
        return jfxEnabled_;
    }

    public static void reportGraphicsDevices() {
        if (PlatformUtils.isHeadless()) {
            LOGGER.debug("Current environment is headless.");
            return;
        }
        Toolkit tk = Toolkit.getDefaultToolkit();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] devices = ge.getScreenDevices();
        LOGGER.debug("Discovered {} graphics devices", (Object)devices.length);
        int count = 0;
        for (GraphicsDevice device : devices) {
            GraphicsConfiguration gc = device.getDefaultConfiguration();
            int dtype = device.getType();
            LOGGER.debug("Device              {}", (Object)(++count));
            LOGGER.debug("- Is default device {}", (Object)device.equals(ge.getDefaultScreenDevice()));
            LOGGER.debug("- Device type       {}", (Object)dtype);
            LOGGER.debug("- Type is raster    {}", (Object)(dtype == 0 ? 1 : 0));
            LOGGER.debug("- Config bounds     {}", (Object)gc.getBounds());
            LOGGER.debug("- Config insets     {}", (Object)tk.getScreenInsets(gc));
        }
    }

    public static int min0max100(int value) {
        return PanUtils.min0max(100, value);
    }

    public static int min0max(int max, int value) {
        int result = Math.min(value, max);
        result = Math.max(result, 0);
        return result;
    }

    public static Object getDefaultColorTable() {
        return PanUtils.getColorTableResourceList().getBackingObject("panoply.act");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ColorTableResourceList getColorTableResourceList() {
        Object object = LOCK;
        synchronized (object) {
            if (colorTableSet_ == null) {
                LOGGER.trace("Initting color table resource set");
                colorTableSet_ = new ColorTableResourceList();
                LOGGER.trace("Scanning jar");
                colorTableSet_.scanJarDirectory(Panoply.class, "resources/colorbars");
            }
            return colorTableSet_;
        }
    }

    public static Object getDefaultOverlay() {
        return PanUtils.getOverlayResourceList().getBackingObject("Earth.cno");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OverlayResourceList getOverlayResourceList() {
        Object object = LOCK;
        synchronized (object) {
            if (overlaySet_ == null) {
                OverlayFactory.registerOverlayExt("gif", PanMaskOverlay.class);
                OverlayFactory.registerOverlayExt("png", PanMaskOverlay.class);
                LOGGER.trace("Initting overlay resource set");
                overlaySet_ = new OverlayResourceList();
                LOGGER.trace("Scanning jar");
                overlaySet_.scanJarDirectory(Panoply.class, "resources/overlays");
            }
            return overlaySet_;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KMLDataResourceList getUnderlayResourceList() {
        Object object = LOCK;
        synchronized (object) {
            if (kmlSet_ == null) {
                kmlSet_ = new KMLDataResourceList();
                kmlSet_.scanJarDirectory(Panoply.class, "resources/underlays");
            }
            return kmlSet_;
        }
    }

    private PanUtils() {
    }
}

