/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.util;

import gov.nasa.giss.graphics.GraphicUtils;
import gov.nasa.giss.panoply.util.PanStrokeStyle;
import gov.nasa.giss.text.PrintfFormat;
import java.awt.BasicStroke;
import java.awt.Font;
import java.awt.font.TextAttribute;
import java.text.AttributedString;

public final class PanGraphicUtils {
    public static Font getFont(String fname, float size) {
        return PanGraphicUtils.getFont(fname, 0, size);
    }

    public static Font getFont(String fname, int style, float size) {
        Font ff;
        try {
            ff = new Font(fname, style, 10);
        }
        catch (Exception exc) {
            ff = new Font("SansSerif", style, 10);
        }
        ff = ff.deriveFont(size);
        return ff;
    }

    public static BasicStroke tickStroke(int sfactor) {
        return GraphicUtils.buttMiterStroke(sfactor);
    }

    public static BasicStroke solidStroke(int weight, int sfactor) {
        return PanGraphicUtils.buttMiterStroke(PanStrokeStyle.SOLID, weight, sfactor);
    }

    public static BasicStroke buttMiterStroke(String style, int weight, int sfactor) {
        PanStrokeStyle gs = PanStrokeStyle.matching(style);
        if (gs == null) {
            return null;
        }
        return PanGraphicUtils.buttMiterStroke(gs, weight, sfactor);
    }

    public static BasicStroke buttMiterStroke(PanStrokeStyle style, int weight, int scaling) {
        if (style == PanStrokeStyle.NONE) {
            return null;
        }
        if (weight <= 0) {
            return null;
        }
        float sqs = (float)Math.sqrt(0.01f * (float)scaling);
        int ww = (int)((float)weight * sqs);
        float[] pattern = style.getDashPattern();
        if (pattern == null) {
            return GraphicUtils.buttMiterStroke(ww);
        }
        int i = 0;
        while (i < pattern.length) {
            int n = i++;
            pattern[n] = pattern[n] * sqs;
        }
        return GraphicUtils.buttMiterStroke(ww, pattern);
    }

    public static BasicStroke roundStroke(String style, int weight, int sfactor) {
        PanStrokeStyle gs = PanStrokeStyle.matching(style);
        if (gs == null) {
            return null;
        }
        return PanGraphicUtils.roundStroke(gs, weight, sfactor);
    }

    public static BasicStroke roundStroke(PanStrokeStyle style, int weight, int scaling) {
        if (weight <= 0) {
            return null;
        }
        float sqs = (float)Math.sqrt(0.01f * (float)scaling);
        int ww = (int)((float)weight * sqs);
        float[] pattern = style.getDashPattern();
        if (pattern == null) {
            return GraphicUtils.roundStroke(ww);
        }
        int i = 0;
        while (i < pattern.length) {
            int n = i++;
            pattern[n] = pattern[n] * sqs;
        }
        return GraphicUtils.roundStroke(ww, pattern);
    }

    public static BasicStroke squareMiterStroke(String style, int weight, int sfactor) {
        PanStrokeStyle gs = PanStrokeStyle.matching(style);
        if (gs == null) {
            return null;
        }
        return PanGraphicUtils.squareMiterStroke(gs, weight, sfactor);
    }

    public static BasicStroke squareMiterStroke(PanStrokeStyle style, int weight, int scaling) {
        if (weight <= 0) {
            return null;
        }
        float sqs = (float)Math.sqrt(0.01f * (float)scaling);
        int ww = (int)((float)weight * sqs);
        float[] pattern = style.getDashPattern();
        if (pattern == null) {
            return GraphicUtils.squareMiterStroke(ww);
        }
        int i = 0;
        while (i < pattern.length) {
            int n = i++;
            pattern[n] = pattern[n] * sqs;
        }
        return GraphicUtils.squareMiterStroke(ww, pattern);
    }

    public static AttributedString getSuperscripted10(double power, Font font) {
        String expo = PrintfFormat.PFORMAT_7G.sprintg(power);
        if (expo.endsWith(".0") || expo.endsWith(",0")) {
            expo = expo.substring(0, expo.length() - 2);
        }
        if (expo.equals("0")) {
            return new AttributedString("1");
        }
        if (expo.equals("1")) {
            return new AttributedString("10");
        }
        String tenstr = "10" + expo;
        tenstr = tenstr.replaceAll("\\b", "");
        AttributedString astr = new AttributedString(tenstr);
        int strLen = tenstr.length();
        if (strLen > 2) {
            astr.addAttribute(TextAttribute.FAMILY, font.getFontName());
            astr.addAttribute(TextAttribute.SIZE, Float.valueOf(font.getSize2D()));
            astr.addAttribute(TextAttribute.SUPERSCRIPT, TextAttribute.SUPERSCRIPT_SUPER, 2, strLen);
        }
        return astr;
    }

    public static AttributedString getSuperscriptedE(double power, Font font) {
        String expo = PrintfFormat.PFORMAT_7G.sprintg(power);
        if (expo.endsWith(".0") || expo.endsWith(",0")) {
            expo = expo.substring(0, expo.length() - 2);
        }
        if (expo.equals("0")) {
            return new AttributedString("1");
        }
        if (expo.equals("1")) {
            return new AttributedString("\u212f");
        }
        String estr = "\u212f" + expo;
        estr = estr.replaceAll("\\b", "");
        AttributedString astr = new AttributedString(estr);
        int strLen = estr.length();
        if (strLen > 1) {
            astr.addAttribute(TextAttribute.FAMILY, font.getFontName());
            astr.addAttribute(TextAttribute.SIZE, Float.valueOf(font.getSize2D()));
            astr.addAttribute(TextAttribute.SUPERSCRIPT, TextAttribute.SUPERSCRIPT_SUPER, 1, strLen);
        }
        return astr;
    }

    private PanGraphicUtils() {
    }
}

