/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.ui;

import gov.nasa.giss.graphics.GraphicUtils;
import gov.nasa.giss.img.ImageUtils;
import gov.nasa.giss.ui.GuiUtils;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.lang.invoke.MethodHandles;
import javax.swing.Action;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanLinkButton
extends JButton {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static ImageIcon closedIcon_;
    private static ImageIcon openIcon_;
    private int isize_ = 20;
    private boolean linked_;

    public PanLinkButton(Action action) {
        this(action, false);
    }

    public PanLinkButton(Action action, boolean linked) {
        this.setAction(action);
        this.setText(null);
        this.setBorder(null);
        this.setAlignmentY(0.5f);
        this.setLinked(linked);
    }

    public void setButtonSize(int isize) {
        if (isize <= 0) {
            throw new IllegalArgumentException("Bad button size.");
        }
        this.isize_ = isize;
    }

    public boolean isLinked() {
        return this.linked_;
    }

    public void setLinked(boolean linked) {
        this.linked_ = linked;
        if (linked) {
            this.setIcon(closedIcon_);
        } else {
            this.setIcon(openIcon_);
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        PanLinkButton b = this;
        ButtonModel model = b.getModel();
        Icon icon = b.getIcon();
        BufferedImage bimage = ImageUtils.toBufferedImage(icon);
        Graphics2D g2d = GraphicUtils.createAntialiasedGfx(g);
        if (!model.isEnabled()) {
            g2d.setComposite(AlphaComposite.getInstance(3, 0.33f));
        } else if (model.isArmed()) {
            g2d.setColor(new Color(0, 0, 0, 51));
            GraphicUtils.fillRect(g2d, 0.0, 0.0, this.isize_, this.isize_);
        } else if (!GuiUtils.isParentWindowFocused(this)) {
            g2d.setComposite(AlphaComposite.getInstance(3, 0.5f));
        }
        double scaling = (double)this.isize_ / (double)icon.getIconWidth();
        g2d.scale(scaling, scaling);
        g2d.drawImage((Image)bimage, 0, 0, null);
        g2d.dispose();
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.isize_, this.isize_);
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(this.isize_, this.isize_);
    }

    @Override
    public Dimension getMaximumSize() {
        return new Dimension(this.isize_, this.isize_);
    }

    static {
        try {
            closedIcon_ = new ImageIcon(PanLinkButton.class.getResource("resources/link_closed.png"));
        }
        catch (Exception exc) {
            LOGGER.debug("Could not create closed-link icon");
        }
        try {
            openIcon_ = new ImageIcon(PanLinkButton.class.getResource("resources/link_open.png"));
        }
        catch (Exception exc) {
            LOGGER.debug("Could not create open-link icon");
        }
    }
}

