/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.sources;

import gov.nasa.giss.panoply.bookmarks.PanBookmark;
import gov.nasa.giss.panoply.bookmarks.PanBookmarkNode;
import gov.nasa.giss.panoply.prefs.PanPreferences;
import gov.nasa.giss.panoply.sources.PanBookmarkTreeTablePanel;
import gov.nasa.giss.panoply.sources.PanSourcesFrame;
import gov.nasa.giss.panoply.sources.PanSourcesPanel;
import gov.nasa.giss.panoply.util.PanActionHash;
import gov.nasa.giss.ui.event.TreeTableEvent;
import gov.nasa.giss.ui.treetable.TreeTableNode;
import javax.swing.JComponent;

public class PanBookmarksPanel
extends PanSourcesPanel {
    public PanBookmarksPanel(PanSourcesFrame parent) {
        super(parent, false);
        if (PanPreferences.getSharedInstance().getBoolean("sources:bookmarks.find.vis")) {
            this.showSearch(true);
        }
    }

    @Override
    protected JComponent makeTreeHolder() {
        this.ttPanel_ = new PanBookmarkTreeTablePanel();
        this.ttPanel_.addTreeTableListener(this);
        return this.ttPanel_;
    }

    @Override
    public synchronized void refreshActions() {
        TreeTableNode node;
        PanActionHash actionHash = this.parent_.getActionHash();
        actionHash.disableAll();
        if (this.ttPanel_.getModel().getRowCount() > 0) {
            actionHash.enable("find", true);
            actionHash.enable("find-next", true);
        }
        if ((node = this.getSelectedNode()) == null) {
            return;
        }
        actionHash.enable("remove-one", true);
    }

    @Override
    public final void showSearch(boolean visible) {
        super.showSearch(visible);
        PanPreferences.getSharedInstance().setBoolean("sources:bookmarks.find.vis", visible);
    }

    @Override
    protected void refreshInfoBox() {
    }

    @Override
    public void clear() {
    }

    public PanBookmarkNode addNode(PanBookmarkNode node) {
        if (node == null) {
            return null;
        }
        return ((PanBookmarkTreeTablePanel)this.ttPanel_).addNode(node);
    }

    @Override
    public void removeNode(TreeTableNode node) {
        if (node == null) {
            return;
        }
        ((PanBookmarkTreeTablePanel)this.ttPanel_).removeNode(node);
        this.refreshActions();
    }

    @Override
    public void selectionMade(TreeTableEvent e) {
        this.refreshActions();
        TreeTableNode node = this.getSelectedNode();
        if (node == null) {
            return;
        }
        int id = e.getID();
        if (id == 102 && node instanceof PanBookmark) {
            ((PanBookmark)node).open(this.parent_);
        }
    }

    @Override
    public void itemAdded(TreeTableEvent e) {
    }
}

