/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.prefsui;

import gov.nasa.giss.io.FileUtils;
import gov.nasa.giss.map.kml.KMLDataFilenameFilter;
import gov.nasa.giss.map.kml.KMLDataResourceList;
import gov.nasa.giss.panoply.io.PanFileUtils;
import gov.nasa.giss.panoply.prefsui.PanAbstractPrefsPanel;
import gov.nasa.giss.panoply.prefsui.PanCommonPrefsTable;
import gov.nasa.giss.panoply.prefsui.PanUnderlayTableModel;
import gov.nasa.giss.panoply.ui.PanCheckBox;
import gov.nasa.giss.panoply.ui.PanFrame;
import gov.nasa.giss.panoply.ui.PanGuiConstants;
import gov.nasa.giss.panoply.ui.PanLabel;
import gov.nasa.giss.panoply.util.PanUtils;
import gov.nasa.giss.ui.GuiUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.TransferHandler;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import net.schmunk.ui.FGConstraint;
import net.schmunk.ui.FlexingGridLayout;
import net.schmunk.ui.PlusMinus;

public class PanUnderlayPrefsPanel
extends PanAbstractPrefsPanel
implements DropTargetListener {
    private JScrollPane ppanel_;
    private PlusMinus pmwidget_;
    private PanCommonPrefsTable table_;
    private PanCheckBox autoimportCB_;
    private KeyStroke cutKS_;
    private Border focusedTableBorder_;
    private Border unfocusedTableBorder_;

    public PanUnderlayPrefsPanel() {
        this.createLayout();
        this.attachListeners();
    }

    private final void createLayout() {
        this.setBorder(GuiUtils.createPaddedTitleBorder("Underlays Library"));
        this.setOpaque(false);
        this.autoimportCB_ = PanCheckBox.create("Always import new KMZ map underlays into support library", false);
        this.ppanel_ = this.createTable();
        Border ob = this.ppanel_.getBorder();
        this.focusedTableBorder_ = new CompoundBorder(PanGuiConstants.THIN_FOCUSED_BORDER, ob);
        this.unfocusedTableBorder_ = new CompoundBorder(PanGuiConstants.THIN_UNFOCUSED_BORDER, ob);
        this.ppanel_.setBorder(this.unfocusedTableBorder_);
        GuiUtils.makeRecursiveDropTarget(this.ppanel_, this);
        this.pmwidget_ = new PlusMinus();
        this.pmwidget_.setMaximumSize(this.pmwidget_.getPreferredSize());
        this.pmwidget_.setIconEnabled(2001, false);
        PanLabel bText = PanLabel.createSmall("Built-in underlays cannot be removed.");
        FlexingGridLayout fgl = new FlexingGridLayout(2, 3, 12, 2);
        fgl.setRowWeight(1, 9999.0f);
        fgl.setColumnWeight(1, 9999.0f);
        this.setLayout(fgl);
        this.add((Component)this.autoimportCB_, new FGConstraint(0, 0, 2, 1));
        this.add((Component)this.ppanel_, new FGConstraint(0, 1, 2, 1, true));
        this.add((Component)this.pmwidget_, new FGConstraint(0, 2));
        this.add((Component)bText, new FGConstraint(1, 2, 1.0, 0.5));
    }

    private JScrollPane createTable() {
        this.table_ = new PanCommonPrefsTable(new PanUnderlayTableModel());
        JScrollPane jsp = new JScrollPane(this.table_);
        jsp.setVerticalScrollBarPolicy(22);
        jsp.setHorizontalScrollBarPolicy(30);
        jsp.setOpaque(false);
        jsp.setMinimumSize(new Dimension(this.getPreferredSize().width / 2, 160));
        return jsp;
    }

    private final void attachListeners() {
        this.autoimportCB_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            prefs_.setBoolean("files:autoimport.underlays", this.autoimportCB_.isSelected());
        });
        this.pmwidget_.addActionListener(e -> {
            if (e.getID() == 2000) {
                PanFrame pf = (PanFrame)this.getTopLevelAncestor();
                File[] ff = PanFileUtils.showOpenKMLFileChooser(pf);
                if (ff != null) {
                    PanUtils.getUnderlayResourceList().addAlphabetic((Component)pf, ff);
                }
            } else if (e.getID() == 2001) {
                int row = this.table_.getSelectedRow();
                this.table_.getSelectionModel().clearSelection();
                this.deletionRequested(row);
            }
            this.refresh();
        });
        this.table_.getModel().addTableModelListener(e -> this.refresh());
        this.table_.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                PanUnderlayPrefsPanel.this.refresh();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                PanUnderlayPrefsPanel.this.refresh();
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                PanUnderlayPrefsPanel.this.refresh();
            }
        });
        Action cut = TransferHandler.getCutAction();
        ActionMap am = this.table_.getActionMap();
        Object cutKey = null;
        for (Object key : am.allKeys()) {
            Action a = am.get(key);
            if (a != cut) continue;
            cutKey = key;
            break;
        }
        InputMap im = this.table_.getInputMap(1);
        this.cutKS_ = null;
        for (KeyStroke ks : im.allKeys()) {
            Object o = im.get(ks);
            if (!o.equals(cutKey)) continue;
            this.cutKS_ = ks;
            break;
        }
        this.table_.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int row = PanUnderlayPrefsPanel.this.table_.getSelectedRow();
                KeyStroke ks = KeyStroke.getKeyStrokeForEvent(e);
                if (PanUnderlayPrefsPanel.this.cutKS_ != null && ks.equals(PanUnderlayPrefsPanel.this.cutKS_)) {
                    PanUnderlayPrefsPanel.this.deletionRequested(row);
                    PanUnderlayPrefsPanel.this.refresh();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                int row = PanUnderlayPrefsPanel.this.table_.getSelectedRow();
                KeyStroke ks = KeyStroke.getKeyStrokeForEvent(e);
                if ((e.getKeyCode() == 8 || e.getKeyCode() == 127) && e.getModifiersEx() == 0) {
                    PanUnderlayPrefsPanel.this.deletionRequested(row);
                } else if (PanUnderlayPrefsPanel.this.cutKS_ != null && ks.equals(PanUnderlayPrefsPanel.this.cutKS_)) {
                    PanUnderlayPrefsPanel.this.deletionRequested(row);
                }
                PanUnderlayPrefsPanel.this.refresh();
            }
        });
    }

    private final void deletionRequested(int index) {
        KMLDataResourceList list = PanUtils.getUnderlayResourceList();
        list.remove(index);
        this.refresh();
    }

    @Override
    public void refresh() {
        this.refreshing_ = true;
        this.autoimportCB_.setSelected(prefs_.getBoolean("files:autoimport.underlays"));
        this.pmwidget_.setIconEnabled(2000, true);
        int row = this.table_.getSelectedRow();
        KMLDataResourceList kset = PanUtils.getUnderlayResourceList();
        if (row >= kset.getSize()) {
            this.pmwidget_.setIconEnabled(2001, false);
        } else if (row >= 0) {
            this.pmwidget_.setIconEnabled(2001, kset.canRemove(row));
        } else {
            this.pmwidget_.setIconEnabled(2001, false);
        }
        this.refreshing_ = false;
    }

    @Override
    public void dragEnter(DropTargetDragEvent e) {
        if (e.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            e.acceptDrag(1);
            this.ppanel_.setBorder(this.focusedTableBorder_);
            this.repaint();
        } else {
            e.rejectDrag();
        }
    }

    @Override
    public void drop(DropTargetDropEvent e) {
        Transferable t = e.getTransferable();
        if (t.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            e.acceptDrop(1);
            List<File> droplist = FileUtils.getTransferredFileList(t);
            if (droplist != null) {
                ArrayList<File> addlist = new ArrayList<File>();
                for (File f : droplist) {
                    if (!KMLDataFilenameFilter.isKMLName(f)) continue;
                    addlist.add(f);
                }
                PanUtils.getUnderlayResourceList().addAlphabetic((Component)this, addlist);
            }
            e.dropComplete(true);
            this.repaint();
        } else {
            e.rejectDrop();
        }
        this.ppanel_.setBorder(this.unfocusedTableBorder_);
        this.ppanel_.invalidate();
        this.validate();
    }

    @Override
    public void dragExit(DropTargetEvent e) {
        this.ppanel_.setBorder(this.unfocusedTableBorder_);
        this.repaint();
    }

    @Override
    public void dragOver(DropTargetDragEvent e) {
        if (e.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            e.acceptDrag(1);
            this.ppanel_.setBorder(this.focusedTableBorder_);
            this.repaint();
        } else {
            e.rejectDrag();
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent e) {
        this.ppanel_.setBorder(this.focusedTableBorder_);
        this.repaint();
    }
}

