/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.prefsui;

import gov.nasa.giss.math.MathUtils;
import gov.nasa.giss.panoply.prefsui.PanAbstractPrefsPanel;
import gov.nasa.giss.panoply.ui.PanLabel;
import gov.nasa.giss.panoply.ui.PanTextField;
import gov.nasa.giss.text.PrintfFormat;
import gov.nasa.giss.text.StringUtils;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.QuickBox;
import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.Box;
import net.schmunk.ui.FGConstraint;
import net.schmunk.ui.FlexingGridLayout;

public class PanTimeLatPrefsPanel
extends PanAbstractPrefsPanel {
    private PanTextField val1TF_;
    private PanTextField val2TF_;

    public PanTimeLatPrefsPanel() {
        this.createLayout();
        this.refreshPrivate();
        this.attachListeners();
    }

    private final void createLayout() {
        this.setBorder(GuiUtils.createPaddedTitleBorder("Time-Lat Plot Defaults"));
        this.setOpaque(false);
        PanLabel topText = PanLabel.create("When creating a time-lat plot, set\u2026");
        this.val1TF_ = PanTextField.createDoubleField(null, -90.0);
        this.val2TF_ = PanTextField.createDoubleField(null, 90.0);
        FlexingGridLayout fgl = new FlexingGridLayout(3, 5, 0, 2);
        fgl.setColumnWeight(2, 9999.0f);
        this.setLayout(fgl);
        this.add((Component)topText, new FGConstraint(0, 0, 3, 1));
        this.add(Box.createVerticalStrut(2), new FGConstraint(1, 1));
        this.add((Component)PanLabel.create("Lat Axis Bottom: "), new FGConstraint(0, 2, 1.0));
        this.add((Component)QuickBox.createLeftBox(this.val1TF_, PanLabel.create("\u00b0N, Top "), this.val2TF_, PanLabel.create("\u00b0N")), new FGConstraint(1, 2));
    }

    private final void attachListeners() {
        FocusAdapter latFL = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                PanTimeLatPrefsPanel.this.handleLatExtrema();
            }
        };
        this.val1TF_.addFocusListener(latFL);
        this.val2TF_.addFocusListener(latFL);
        this.val1TF_.addActionListener(e -> this.handleLatExtrema());
        this.val2TF_.addActionListener(e -> this.handleLatExtrema());
    }

    @Override
    public void refresh() {
        this.refreshPrivate();
    }

    private final void refreshPrivate() {
        this.refreshing_ = true;
        this.val1TF_.setText(PrintfFormat.PFORMAT_7G.sprintg(prefs_.getDouble("plot:timelat.yaxis.bottom")));
        this.val2TF_.setText(PrintfFormat.PFORMAT_7G.sprintg(prefs_.getDouble("plot:timelat.yaxis.top")));
        this.refreshing_ = false;
    }

    private final void handleLatExtrema() {
        double oldval2;
        double oldval1;
        double val1 = oldval1 = prefs_.getDouble("plot:timelat.yaxis.bottom");
        try {
            val1 = StringUtils.parseDouble(this.val1TF_.getText());
        }
        catch (Exception exc) {
            this.val1TF_.setText(PrintfFormat.PFORMAT_7G.sprintg(oldval1));
            return;
        }
        if (val1 < -90.0 || val1 > 90.0) {
            val1 = MathUtils.minmax(-90.0, 90.0, val1);
            this.val1TF_.setText(PrintfFormat.PFORMAT_7G.sprintg(val1));
        }
        double val2 = oldval2 = prefs_.getDouble("plot:timelat.yaxis.top");
        try {
            val2 = StringUtils.parseDouble(this.val2TF_.getText());
        }
        catch (Exception exc) {
            this.val2TF_.setText(PrintfFormat.PFORMAT_7G.sprintg(oldval2));
            return;
        }
        if (val2 < -90.0 || val2 > 90.0) {
            val2 = MathUtils.minmax(-90.0, 90.0, val2);
            this.val2TF_.setText(PrintfFormat.PFORMAT_7G.sprintg(val2));
        }
        if (val2 == val1) {
            if (val2 == -90.0) {
                val1 = -89.999;
                this.val1TF_.setText(PrintfFormat.PFORMAT_7G.sprintg(val1));
            } else if (val2 == 90.0) {
                val2 = 89.999;
                this.val2TF_.setText(PrintfFormat.PFORMAT_7G.sprintg(val2));
            } else {
                val1 = val2 + 0.001;
                if (val1 >= 90.0) {
                    val2 = 89.999;
                    val1 = 90.0;
                }
                this.val2TF_.setText(PrintfFormat.PFORMAT_7G.sprintg(val2));
                this.val1TF_.setText(PrintfFormat.PFORMAT_7G.sprintg(val1));
            }
        }
        prefs_.setDouble("plot:timelat.yaxis.top", val2);
        prefs_.setDouble("plot:timelat.yaxis.bottom", val1);
    }
}

