/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.prefsui;

import gov.nasa.giss.panoply.prefsui.PanAbstractPrefsPanel;
import gov.nasa.giss.panoply.ui.PanCheckBox;
import gov.nasa.giss.panoply.ui.PanFloatComboBox;
import gov.nasa.giss.panoply.ui.PanIntSpinner;
import gov.nasa.giss.panoply.ui.PanLabel;
import gov.nasa.giss.panoply.ui.PanScaleMethodComboBox;
import gov.nasa.giss.panoply.ui.PanStringComboBox;
import gov.nasa.giss.panoply.util.PanScaleMethod;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.QuickBox;
import java.awt.Component;
import javax.swing.Box;
import net.schmunk.ui.FGConstraint;
import net.schmunk.ui.FlexingGridLayout;

public class PanScalePrefsPanel
extends PanAbstractPrefsPanel {
    private PanCheckBox autoFitCB_;
    private PanScaleMethodComboBox methodCombo_;
    private PanIntSpinner majorDivSpinner_;
    private PanIntSpinner minorDivSpinner_;
    private PanStringComboBox tickFormatCombo_;
    private PanFloatComboBox tickSizeCombo_;
    private PanCheckBox minmaxCB_;
    private PanStringComboBox minmaxFormatCombo_;

    public PanScalePrefsPanel() {
        this.setBorder(GuiUtils.createPaddedTitleBorder("Plot Scale Defaults"));
        this.setOpaque(false);
        this.createLayout();
        this.refreshPrivate();
        this.attachListeners();
    }

    private final void createLayout() {
        PanLabel topText = PanLabel.create("When creating a plot, set\u2026");
        this.autoFitCB_ = PanCheckBox.create("Always fit to data range");
        this.methodCombo_ = PanScaleMethodComboBox.create("plot:scale.method");
        this.majorDivSpinner_ = PanIntSpinner.createDivs(null, 2);
        this.minorDivSpinner_ = PanIntSpinner.createDivs(null, 1);
        this.tickSizeCombo_ = PanFloatComboBox.create(7.0f, 12.0f);
        this.tickFormatCombo_ = PanStringComboBox.createNumberFormatCB(null);
        this.minmaxCB_ = PanCheckBox.create("Show min-max footnote");
        this.minmaxFormatCombo_ = PanStringComboBox.createSmallNumberFormatCB("plot:scale.minmax.format");
        this.minmaxFormatCombo_.insertItemAt("Same as Scale Ticks", 0);
        FlexingGridLayout fgl = new FlexingGridLayout(4, 9, 0, 2);
        fgl.setColumnWeight(3, 9999.0f);
        this.setLayout(fgl);
        int row = 0;
        this.add((Component)topText, new FGConstraint(0, row, 4, 1));
        this.add(Box.createVerticalStrut(4), new FGConstraint(0, ++row));
        this.add((Component)PanLabel.create("Scale Method: "), new FGConstraint(0, ++row));
        this.add((Component)this.methodCombo_, new FGConstraint(1, row));
        this.add((Component)PanLabel.create("Min/Max: "), new FGConstraint(0, ++row));
        this.add((Component)this.autoFitCB_, new FGConstraint(1, row));
        this.add((Component)PanLabel.create("Divisions: "), new FGConstraint(0, ++row));
        this.add((Component)QuickBox.createLeftBox(PanLabel.create("Major: "), this.majorDivSpinner_, PanLabel.create(", Minor: "), this.minorDivSpinner_), new FGConstraint(1, row));
        this.add((Component)PanLabel.create("Tick Labels: "), new FGConstraint(0, ++row));
        this.add((Component)QuickBox.createLeftBox(PanLabel.create("Format: "), this.tickFormatCombo_, PanLabel.create(", Size: "), this.tickSizeCombo_), new FGConstraint(1, row));
        this.add((Component)PanLabel.create("Footnote: "), new FGConstraint(0, ++row));
        this.add((Component)this.minmaxCB_, new FGConstraint(1, row));
        this.add((Component)QuickBox.createLeftBox(Box.createHorizontalStrut(36), PanLabel.createSmall("Format:\u2009"), this.minmaxFormatCombo_), new FGConstraint(1, ++row));
        this.tickFormatCombo_.setMaximumSize(this.tickFormatCombo_.getPreferredSize());
        this.majorDivSpinner_.setMaximumSize(this.majorDivSpinner_.getPreferredSize());
        this.minorDivSpinner_.setMaximumSize(this.minorDivSpinner_.getPreferredSize());
    }

    private final void attachListeners() {
        this.methodCombo_.addItemListener(e -> {
            if (e.getStateChange() != 1) {
                return;
            }
            if (this.refreshing_) {
                return;
            }
            prefs_.set("plot:scale.method", ((PanScaleMethod)this.methodCombo_.getSelectedItem()).name());
        });
        this.autoFitCB_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            prefs_.setBoolean("plot:scale.autofit", this.autoFitCB_.isSelected());
        });
        this.minmaxCB_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            prefs_.setBoolean("plot:scale.minmax.note", this.minmaxCB_.isSelected());
        });
        this.majorDivSpinner_.addChangeListener(e -> {
            if (this.refreshing_) {
                return;
            }
            prefs_.setInt("plot:scale.div.major", this.majorDivSpinner_.getIntValue());
        });
        this.minorDivSpinner_.addChangeListener(e -> {
            if (this.refreshing_) {
                return;
            }
            prefs_.setInt("plot:scale.div.minor", this.minorDivSpinner_.getIntValue());
        });
        this.tickFormatCombo_.addItemListener(e -> {
            if (e.getStateChange() != 1) {
                return;
            }
            if (this.refreshing_) {
                return;
            }
            prefs_.set("plot:scale.tick.format", this.tickFormatCombo_.getSelectedString());
        });
        this.tickSizeCombo_.addItemListener(e -> {
            if (e.getStateChange() != 1) {
                return;
            }
            if (this.refreshing_) {
                return;
            }
            float value = this.tickSizeCombo_.getValue();
            prefs_.setFloat("plot:scale.tick.size", value);
        });
    }

    @Override
    public void refresh() {
        this.refreshPrivate();
    }

    private final void refreshPrivate() {
        this.refreshing_ = true;
        PanScaleMethod smethod = PanScaleMethod.matching(prefs_.getString("plot:scale.method"));
        this.autoFitCB_.setSelected(prefs_.getBoolean("plot:scale.autofit"));
        this.methodCombo_.setSelectedItem(smethod);
        this.tickFormatCombo_.setSelectedItem(prefs_.getString("plot:scale.tick.format"));
        this.tickSizeCombo_.setSelectedItem(prefs_.getFloat("plot:scale.tick.size"));
        this.majorDivSpinner_.setValue(prefs_.getInt("plot:scale.div.major"));
        this.minorDivSpinner_.setValue(prefs_.getInt("plot:scale.div.minor"));
        this.minmaxCB_.setSelected(prefs_.getBoolean("plot:scale.minmax.note"));
        this.minmaxFormatCombo_.setEnabled(this.minmaxCB_.isSelected());
        String mmf = prefs_.getString("plot:scale.minmax.format");
        if (mmf == null || mmf.isEmpty() || mmf.toLowerCase().startsWith("same")) {
            this.minmaxFormatCombo_.setSelectedIndex(0);
        } else {
            this.minmaxFormatCombo_.setSelectedItem(mmf);
        }
        this.refreshing_ = false;
    }
}

