/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.prefsui;

import gov.nasa.giss.panoply.prefs.PanProjectionPrefs;
import gov.nasa.giss.panoply.prefsui.PanPrefsTableModel;

public class PanProjectionTableModel
extends PanPrefsTableModel {
    private final String[] pnames_;
    private final PanProjectionPrefs pprefs_ = PanProjectionPrefs.getSharedInstance();

    public PanProjectionTableModel() {
        this.pnames_ = this.pprefs_.getAllNames();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public int getRowCount() {
        if (this.pnames_ == null) {
            return 0;
        }
        return this.pnames_.length;
    }

    @Override
    public Class<?> getColumnClass(int col) {
        switch (col) {
            case 0: {
                return Boolean.class;
            }
            case 1: {
                return String.class;
            }
        }
        return String.class;
    }

    @Override
    public String getColumnName(int col) {
        switch (col) {
            case 0: {
                return "Fave?";
            }
            case 1: {
                return "Name";
            }
        }
        return "";
    }

    @Override
    public Object getValueAt(int row, int col) {
        switch (col) {
            case 0: {
                return this.pprefs_.isFavorite(this.pnames_[row]);
            }
            case 1: {
                return this.pnames_[row];
            }
        }
        return "";
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        if (col > 0) {
            return false;
        }
        String lcname = this.pnames_[row].toLowerCase();
        boolean isRequired = lcname.contains("equirectangular");
        return !isRequired;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        if (col > 0) {
            return;
        }
        if (this.isCellEditable(row, col)) {
            this.pprefs_.setFavorite(this.pnames_[row], (Boolean)value);
        } else {
            this.pprefs_.setFavorite(this.pnames_[row], true);
        }
        this.fireTableDataChanged();
    }
}

