/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.prefsui;

import gov.nasa.giss.map.kml.KMLData;
import gov.nasa.giss.panoply.prefsui.PanAbstractPrefsPanel;
import gov.nasa.giss.panoply.ui.PanCheckBox;
import gov.nasa.giss.panoply.ui.PanEnumComboBox;
import gov.nasa.giss.panoply.ui.PanGuiSize;
import gov.nasa.giss.panoply.ui.PanIntSpinner;
import gov.nasa.giss.panoply.ui.PanLabel;
import gov.nasa.giss.panoply.ui.PanUnderlayComboBox;
import gov.nasa.giss.panoply.util.PanAlphaMethod;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.QuickBox;
import java.awt.Component;
import net.schmunk.ui.FGConstraint;
import net.schmunk.ui.FlexingGridLayout;

public class PanMainAlphaPrefsPanel
extends PanAbstractPrefsPanel {
    private PanCheckBox ulayVisCB_;
    private PanUnderlayComboBox underlayCombo_;
    private PanEnumComboBox mainAlphaCombo_;
    private PanIntSpinner[] mainAlphaSpinners_ = new PanIntSpinner[2];
    private PanCheckBox mainKnockoutCB_;

    public PanMainAlphaPrefsPanel() {
        this.createLayout();
        this.refreshPrivate();
        this.attachListeners();
    }

    private final void createLayout() {
        this.setBorder(GuiUtils.createPaddedTitleBorder("Map Underlays"));
        this.setOpaque(false);
        PanLabel topText = PanLabel.create("When creating a map plot, set\u2026");
        PanLabel ulayLabel = PanLabel.create("Underlay: ");
        this.ulayVisCB_ = PanCheckBox.create("Enabled", true);
        PanLabel nameLabel = PanLabel.create("Name: ");
        this.underlayCombo_ = new PanUnderlayComboBox(PanGuiSize.REGULAR);
        PanLabel m1Label1 = PanLabel.create("Main Layer: ");
        PanLabel m1Label2 = PanLabel.create("Alpha Method: ");
        this.mainAlphaCombo_ = PanEnumComboBox.create(PanAlphaMethod.class);
        QuickBox m1Box = QuickBox.createLeftBox(m1Label2, this.mainAlphaCombo_);
        PanLabel m2Label2 = PanLabel.create("Min: ");
        PanLabel m2Label3 = PanLabel.create("%");
        PanLabel m2Label4 = PanLabel.create(", Max:");
        PanLabel m2Label5 = PanLabel.create("%");
        this.mainAlphaSpinners_[0] = PanIntSpinner.createPct(100);
        this.mainAlphaSpinners_[1] = PanIntSpinner.createPct(100);
        QuickBox m2Box = QuickBox.createLeftBox(m2Label2, this.mainAlphaSpinners_[0], m2Label3, m2Label4, this.mainAlphaSpinners_[1], m2Label5);
        this.mainKnockoutCB_ = PanCheckBox.create("Invalids are completely transparent", true);
        FlexingGridLayout fgl = new FlexingGridLayout(3, 6, 0, 2);
        fgl.setColumnWeight(2, 9999.0f);
        fgl.setRigidHeight(true);
        this.setLayout(fgl);
        this.add((Component)topText, new FGConstraint(0, 0, 3, 1));
        this.add((Component)ulayLabel, new FGConstraint(0, 1));
        this.add((Component)this.ulayVisCB_, new FGConstraint(1, 1));
        this.add((Component)nameLabel, new FGConstraint(0, 2));
        this.add((Component)this.underlayCombo_, new FGConstraint(1, 2));
        this.add((Component)m1Label1, new FGConstraint(0, 3));
        this.add((Component)m1Box, new FGConstraint(1, 3));
        this.add((Component)m2Box, new FGConstraint(1, 4));
        this.add((Component)this.mainKnockoutCB_, new FGConstraint(1, 5));
    }

    private final void attachListeners() {
        this.ulayVisCB_.addItemListener(e -> prefs_.setBoolean("plot:lonlat.underlay.vis", e.getStateChange() == 1));
        this.underlayCombo_.addItemListener(e -> {
            if (e.getStateChange() != 1) {
                return;
            }
            KMLData underlay = this.underlayCombo_.getUnderlay();
            prefs_.set("plot:lonlat.underlay.name", underlay);
            this.refresh2();
        });
        this.mainAlphaCombo_.addItemListener(e -> {
            if (e.getStateChange() != 1) {
                return;
            }
            PanAlphaMethod amethod = (PanAlphaMethod)this.mainAlphaCombo_.getSelectedItem();
            prefs_.set("plot:main.alpha.method", amethod.name());
            this.refresh2();
        });
        this.mainAlphaSpinners_[0].addChangeListener(e -> {
            int ival = this.mainAlphaSpinners_[0].getIntValue();
            prefs_.setInt("plot:main.alpha.1", ival);
        });
        this.mainAlphaSpinners_[1].addChangeListener(e -> {
            int ival = this.mainAlphaSpinners_[1].getIntValue();
            prefs_.setInt("plot:main.alpha.2", ival);
        });
        this.mainKnockoutCB_.addItemListener(e -> prefs_.setBoolean("plot:main.alpha.knockout", e.getStateChange() == 1));
    }

    @Override
    public void refresh() {
        this.refreshPrivate();
    }

    private final void refreshPrivate() {
        this.refreshing_ = true;
        Object uname = prefs_.get("plot:lonlat.underlay.name");
        this.ulayVisCB_.setSelected(prefs_.getBoolean("plot:lonlat.underlay.vis"));
        this.underlayCombo_.setSelectedItem(uname);
        this.mainAlphaCombo_.setSelectedItem(PanAlphaMethod.matching(prefs_.getString("plot:main.alpha.method")));
        this.mainAlphaSpinners_[0].setValue(prefs_.getInt("plot:main.alpha.1"));
        this.mainAlphaSpinners_[1].setValue(prefs_.getInt("plot:main.alpha.2"));
        this.mainKnockoutCB_.setSelected(prefs_.getBoolean("plot:main.alpha.knockout"));
        this.refresh2();
    }

    private final void refresh2() {
        KMLData underlay = this.underlayCombo_.getUnderlay();
        boolean enabled = underlay != null;
        PanAlphaMethod amethod = (PanAlphaMethod)this.mainAlphaCombo_.getSelectedItem();
        int acount = amethod.getAlphaCount();
        this.mainAlphaCombo_.setEnabled(enabled);
        this.mainAlphaSpinners_[0].setEnabled(enabled);
        this.mainAlphaSpinners_[1].setEnabled(enabled && acount > 1);
        this.mainKnockoutCB_.setEnabled(enabled);
        this.repaint();
        this.refreshing_ = false;
    }
}

