/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.prefsui;

import gov.nasa.giss.map.SymbolID;
import gov.nasa.giss.map.overlay.MapOverlay;
import gov.nasa.giss.map.overlay.ShapefileOverlay;
import gov.nasa.giss.panoply.overlay.PanMaskOverlay;
import gov.nasa.giss.panoply.prefsui.PanAbstractPrefsPanel;
import gov.nasa.giss.panoply.ui.PanCheckBox;
import gov.nasa.giss.panoply.ui.PanColorComboBox;
import gov.nasa.giss.panoply.ui.PanEnumComboBox;
import gov.nasa.giss.panoply.ui.PanFloatComboBox;
import gov.nasa.giss.panoply.ui.PanIntSpinner;
import gov.nasa.giss.panoply.ui.PanLabel;
import gov.nasa.giss.panoply.ui.PanOverlayComboBox;
import gov.nasa.giss.panoply.util.PanParameterKeys;
import gov.nasa.giss.panoply.util.PanStrokeStyle;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.QuickBox;
import java.awt.Component;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JSeparator;
import net.schmunk.ui.FGConstraint;
import net.schmunk.ui.FlexingGridLayout;

public class PanLonLatOverlaysPrefsPanel
extends PanAbstractPrefsPanel {
    private PanOverlayComboBox[] overlayCombo_;
    private PanColorComboBox[] overlayColorCombo_;
    private PanLabel[] overlayWeightLabel_;
    private PanIntSpinner[] overlayWeightSpinner_;
    private PanCheckBox[] overlayMaskInvertCB_;
    private PanEnumComboBox[] overlayStyleCombo_;
    private PanEnumComboBox[] overlaySymbolCombo_;
    private PanFloatComboBox[] overlaySymbolSizeCombo_;
    private JComponent[] overlayColorBox_;
    private JComponent[] overlayWeightBox_;
    private JComponent[] overlayMaskBox_;
    private JComponent[] overlayStrokeBox_;
    private JComponent[] overlaySymbolBox_;
    private JComponent[] row3Box_;

    public PanLonLatOverlaysPrefsPanel() {
        this.createLayout();
        this.refreshPrivate();
        this.attachListeners();
    }

    private final void createLayout() {
        this.overlayCombo_ = new PanOverlayComboBox[3];
        this.overlayColorCombo_ = new PanColorComboBox[3];
        this.overlayWeightLabel_ = new PanLabel[3];
        this.overlayWeightSpinner_ = new PanIntSpinner[3];
        this.overlayMaskInvertCB_ = new PanCheckBox[3];
        this.overlayStyleCombo_ = new PanEnumComboBox[3];
        this.overlaySymbolCombo_ = new PanEnumComboBox[3];
        this.overlaySymbolSizeCombo_ = new PanFloatComboBox[3];
        this.overlayColorBox_ = new JComponent[3];
        this.overlayWeightBox_ = new JComponent[3];
        this.overlayMaskBox_ = new JComponent[3];
        this.overlayStrokeBox_ = new JComponent[3];
        this.overlaySymbolBox_ = new JComponent[3];
        this.row3Box_ = new JComponent[3];
        PanLabel topText = PanLabel.create("When creating a lon-lat map plot, set\u2026");
        for (int i = 0; i < 3; ++i) {
            this.overlayCombo_[i] = new PanOverlayComboBox(true);
            this.overlayColorCombo_[i] = PanColorComboBox.createRainbow(null);
            this.overlayWeightLabel_[i] = PanLabel.create(", Weight:");
            this.overlayWeightSpinner_[i] = PanIntSpinner.createWeight(null, prefs_.getInt(PanParameterKeys.P_LON_LAT_OVERLAY_WEIGHT[i]), 200);
            this.overlayMaskInvertCB_[i] = PanCheckBox.create("Invert");
            this.overlayStyleCombo_[i] = PanEnumComboBox.create(PanStrokeStyle.class);
            this.overlaySymbolCombo_[i] = PanEnumComboBox.create(PanParameterKeys.P_LON_LAT_OVERLAY_SYMBOL_ID[i], SymbolID.class);
            this.overlaySymbolCombo_[i].removeItem(SymbolID.NONE);
            this.overlaySymbolSizeCombo_[i] = PanFloatComboBox.create(3.0f, 8.0f);
            this.overlayCombo_[i].setToolTipText("Select " + (i + 1) + "st overlay to apply to new map plots");
            this.overlayColorBox_[i] = QuickBox.createLeftBox(PanLabel.create("Color: "), this.overlayColorCombo_[i]);
            this.overlayWeightBox_[i] = QuickBox.createLeftBox(this.overlayWeightLabel_[i], this.overlayWeightSpinner_[i]);
            this.overlayMaskBox_[i] = QuickBox.createLeftBox(PanLabel.create("Mask: "), this.overlayMaskInvertCB_[i]);
            this.overlayStrokeBox_[i] = QuickBox.createLeftBox(PanLabel.create("Stroke Style: "), this.overlayStyleCombo_[i]);
            this.overlaySymbolBox_[i] = QuickBox.createLeftBox(PanLabel.create("Point Symbol: "), this.overlaySymbolCombo_[i], PanLabel.create(", Size: "), this.overlaySymbolSizeCombo_[i]);
            this.row3Box_[i] = QuickBox.createLeftBox(this.overlayStrokeBox_[i]);
        }
        FlexingGridLayout fgl = new FlexingGridLayout(3, 15, 0, 2);
        fgl.setColumnWeight(2, 9999.0f);
        this.setLayout(fgl);
        this.setBorder(GuiUtils.createPaddedTitleBorder("Map Plot Overlay Defaults"));
        this.add((Component)topText, new FGConstraint(0, 0, 2, 1));
        for (int i = 0; i < 3; ++i) {
            int row1 = i * 5 + 1;
            this.add((Component)PanLabel.create("Overlay " + (i + 1) + ": "), new FGConstraint(0, row1, 1.0));
            this.add((Component)this.overlayCombo_[i], new FGConstraint(1, row1));
            this.add((Component)this.overlayColorBox_[i], new FGConstraint(1, row1 + 1));
            this.add((Component)this.row3Box_[i], new FGConstraint(1, row1 + 2));
            if (i >= 2) continue;
            this.add((Component)new JSeparator(), new FGConstraint(0, row1 + 4, 3, 1));
        }
    }

    private final void attachListeners() {
        int ii = 0;
        while (ii < 3) {
            int i = ii++;
            this.overlayCombo_[i].addItemListener(e -> {
                if (e.getStateChange() != 1) {
                    return;
                }
                if (this.refreshing_) {
                    return;
                }
                MapOverlay oo = this.overlayCombo_[i].getOverlay();
                prefs_.set(PanParameterKeys.P_LON_LAT_OVERLAY_NAME[i], oo);
                this.refreshPrivate();
            });
            this.overlayStyleCombo_[i].addItemListener(e -> {
                if (e.getStateChange() != 1) {
                    return;
                }
                prefs_.set(PanParameterKeys.P_LON_LAT_OVERLAY_STYLE[i], this.overlayStyleCombo_[i].getStringValue());
            });
            this.overlayWeightSpinner_[i].addChangeListener(e -> {
                if (this.refreshing_) {
                    return;
                }
                prefs_.setInt(PanParameterKeys.P_LON_LAT_OVERLAY_WEIGHT[i], this.overlayWeightSpinner_[i].getIntValue());
            });
            this.overlayMaskInvertCB_[i].addItemListener(e -> {
                if (this.refreshing_) {
                    return;
                }
                prefs_.setBoolean(PanParameterKeys.P_LON_LAT_OVERLAY_INVERT[i], this.overlayMaskInvertCB_[i].isSelected());
            });
            this.overlayColorCombo_[i].addItemListener(e -> {
                if (e.getStateChange() != 1) {
                    return;
                }
                if (this.refreshing_) {
                    return;
                }
                prefs_.set(PanParameterKeys.P_LON_LAT_OVERLAY_COLOR[i], this.overlayColorCombo_[i].getSelectedColor());
            });
            this.overlaySymbolCombo_[i].addItemListener(e -> {
                if (e.getStateChange() != 1) {
                    return;
                }
                prefs_.set(PanParameterKeys.P_LON_LAT_OVERLAY_SYMBOL_ID[i], this.overlaySymbolCombo_[i].getStringValue());
            });
            this.overlaySymbolSizeCombo_[i].addItemListener(e -> {
                if (e.getStateChange() != 1) {
                    return;
                }
                if (this.refreshing_) {
                    return;
                }
                prefs_.setFloat(PanParameterKeys.P_LON_LAT_OVERLAY_SYMBOL_SIZE[i], this.overlaySymbolSizeCombo_[i].getValue());
            });
        }
    }

    @Override
    public void refresh() {
        this.refreshPrivate();
    }

    private final void refreshPrivate() {
        this.refreshing_ = true;
        for (int i = 0; i < 3; ++i) {
            int row1 = i * 5 + 1;
            MapOverlay oo = this.overlayCombo_[i].getOverlay();
            boolean isMask = oo instanceof PanMaskOverlay;
            boolean isShapefile = oo instanceof ShapefileOverlay;
            PanStrokeStyle ostyle = PanStrokeStyle.matching(prefs_.getString(PanParameterKeys.P_LON_LAT_OVERLAY_STYLE[i]));
            this.row3Box_[i].removeAll();
            this.remove(this.overlaySymbolBox_[i]);
            if (isMask) {
                this.row3Box_[i].add(this.overlayMaskBox_[i]);
                this.row3Box_[i].add(this.overlayWeightBox_[i]);
                this.row3Box_[i].add(Box.createHorizontalGlue());
                this.overlayWeightLabel_[i].setText(", Opacity:");
            } else {
                this.row3Box_[i].add(this.overlayStrokeBox_[i]);
                this.row3Box_[i].add(this.overlayWeightBox_[i]);
                this.row3Box_[i].add(Box.createHorizontalGlue());
                this.overlayWeightLabel_[i].setText(", Weight:");
                if (isShapefile) {
                    this.add((Component)this.overlaySymbolBox_[i], new FGConstraint(1, row1 + 3));
                }
            }
            this.overlayCombo_[i].setEnabled(true);
            this.overlayColorCombo_[i].setEnabled(oo != null);
            this.overlayWeightSpinner_[i].setEnabled(oo != null);
            this.overlayMaskInvertCB_[i].setEnabled(isMask);
            this.overlayStyleCombo_[i].setEnabled(oo != null && !isMask);
            this.overlaySymbolCombo_[i].setEnabled(isShapefile);
            this.overlaySymbolSizeCombo_[i].setEnabled(isShapefile);
            this.overlayCombo_[i].setSelectedItem((MapOverlay)prefs_.get(PanParameterKeys.P_LON_LAT_OVERLAY_NAME[i]));
            this.overlayMaskInvertCB_[i].setSelected(prefs_.getBoolean(PanParameterKeys.P_LON_LAT_OVERLAY_INVERT[i]));
            this.overlayColorCombo_[i].setSelectedColor(prefs_.getColor(PanParameterKeys.P_LON_LAT_OVERLAY_COLOR[i]));
            this.overlayWeightSpinner_[i].setValue(prefs_.getInt(PanParameterKeys.P_LON_LAT_OVERLAY_WEIGHT[i]));
            this.overlayStyleCombo_[i].setSelectedItem(ostyle);
            this.overlaySymbolCombo_[i].setSelectedItem(prefs_.getString(PanParameterKeys.P_LON_LAT_OVERLAY_SYMBOL_ID[i]));
            this.overlaySymbolSizeCombo_[i].setValue(prefs_.getFloat(PanParameterKeys.P_LON_LAT_OVERLAY_SYMBOL_SIZE[i]));
        }
        JFrame jf = (JFrame)this.getTopLevelAncestor();
        if (jf != null) {
            this.invalidate();
            jf.validate();
            jf.pack();
        }
        this.refreshing_ = false;
    }
}

