/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plotui;

import gov.nasa.giss.graphics.plot.PlotHolder;
import gov.nasa.giss.panoply.plot.PanPlot;
import gov.nasa.giss.panoply.ui.PanGuiConstants;
import gov.nasa.giss.ui.cursor.CursorUtils;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.EventListener;
import javax.swing.BorderFactory;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;

public class PanPlotHolder
extends PlotHolder {
    public static final Border focusedBorder_ = new CompoundBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6), BorderFactory.createLineBorder(PanGuiConstants.FOCUS_COLOR, 2));
    public static final Border unfocusedBorder_ = BorderFactory.createEmptyBorder(8, 8, 8, 8);
    private final PanPlot plot_;
    private BufferedImage buffer_;
    private int bWidth_;
    private int bHeight_;

    public PanPlotHolder(PanPlot plot) {
        super(plot);
        this.plot_ = plot;
        this.setBorder(null);
        this.setFocusable(false);
        this.setOpaque(false);
    }

    @Override
    public boolean isFocusable() {
        return true;
    }

    @Override
    public void paint(Graphics g) {
        Cursor oldCursor = null;
        if (EventQueue.isDispatchThread()) {
            oldCursor = this.getCursor();
            CursorUtils.setWaitCursor(this);
        }
        super.paint(g);
        if (oldCursor != null && EventQueue.isDispatchThread()) {
            this.setCursor(oldCursor);
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        boolean newBuffer;
        int w = this.getWidth();
        int h = this.getHeight();
        boolean bl = newBuffer = this.buffer_ == null || w != this.bWidth_ || h != this.bHeight_;
        if (newBuffer) {
            this.buffer_ = new BufferedImage(w, h, 2);
            this.bWidth_ = w;
            this.bHeight_ = h;
        }
        if (newBuffer || this.plot_.needsRepaint()) {
            Graphics2D g2d = this.buffer_.createGraphics();
            super.paintComponent(g2d);
            g2d.dispose();
        }
        g.drawImage(this.buffer_, 0, 0, this);
    }

    public Point2D.Double transformXY2GridCoords(Point pt) {
        return this.transformXY2GridCoords(pt.x, pt.y);
    }

    public Point2D.Double transformXY2GridCoords(int x, int y) {
        PanPlot plot = (PanPlot)this.getPlot();
        Point p = plot.getLocation();
        if (p == null) {
            return null;
        }
        return plot.transformXY2GridCoords(x - p.x, y - p.y);
    }

    public String describePoint(int x, int y) {
        PanPlot plot = (PanPlot)this.getPlot();
        Point p = plot.getLocation();
        if (p == null) {
            return null;
        }
        return plot.describePoint(x - p.x, y - p.y);
    }

    public void toggleBorderActive(boolean active) {
        if (active) {
            this.setBorder(focusedBorder_);
        } else {
            this.setBorder(unfocusedBorder_);
        }
        Graphics g = this.getGraphics();
        this.getBorder().paintBorder(this, g, 0, 0, this.getWidth(), this.getHeight());
        g.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        PanPlotHolder panPlotHolder = this;
        synchronized (panPlotHolder) {
            for (KeyListener keyListener : this.getKeyListeners()) {
                this.removeKeyListener(keyListener);
            }
            for (EventListener eventListener : this.getMouseListeners()) {
                this.removeMouseListener((MouseListener)eventListener);
            }
            for (EventListener eventListener : this.getMouseMotionListeners()) {
                this.removeMouseMotionListener((MouseMotionListener)eventListener);
            }
            this.removeAll();
        }
    }
}

