/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plot;

import gov.nasa.giss.data.nc.NcArray;
import gov.nasa.giss.data.nc.NcAxis;
import gov.nasa.giss.data.nc.NcTimeAxis;
import gov.nasa.giss.data.nc.NcVariable;
import gov.nasa.giss.data.nc.array.NcArray1D;
import gov.nasa.giss.graphics.plot.PlotPropertyMap;
import gov.nasa.giss.map.proj.AbstractProjection;
import gov.nasa.giss.math.MathUtils;
import gov.nasa.giss.panoply.data.PanData;
import gov.nasa.giss.panoply.data.PanData1D;
import gov.nasa.giss.panoply.data.PanDataEvent;
import gov.nasa.giss.panoply.data.PanDataGeneral2D;
import gov.nasa.giss.panoply.data.PanDataLatTime;
import gov.nasa.giss.panoply.data.PanDataLatVert;
import gov.nasa.giss.panoply.data.PanDataLonLat;
import gov.nasa.giss.panoply.data.PanDataLonLatTrajectory;
import gov.nasa.giss.panoply.data.PanDataLonTime;
import gov.nasa.giss.panoply.data.PanDataLonVert;
import gov.nasa.giss.panoply.data.PanDataTime1D;
import gov.nasa.giss.panoply.data.PanDataTimeLat;
import gov.nasa.giss.panoply.data.PanDataTimeVert;
import gov.nasa.giss.panoply.io.PanNcUtils;
import gov.nasa.giss.panoply.plot.PanGeneral2DPlot;
import gov.nasa.giss.panoply.plot.PanHorizontalLinePlot;
import gov.nasa.giss.panoply.plot.PanLatTimePlot;
import gov.nasa.giss.panoply.plot.PanLatVertPlot;
import gov.nasa.giss.panoply.plot.PanLonLatPlot;
import gov.nasa.giss.panoply.plot.PanLonTimePlot;
import gov.nasa.giss.panoply.plot.PanLonVertPlot;
import gov.nasa.giss.panoply.plot.PanPlot;
import gov.nasa.giss.panoply.plot.PanPlotLayoutMeta;
import gov.nasa.giss.panoply.plot.PanProjectionMeta;
import gov.nasa.giss.panoply.plot.PanScaleMeta;
import gov.nasa.giss.panoply.plot.PanTimeLatPlot;
import gov.nasa.giss.panoply.plot.PanTimeYPlot;
import gov.nasa.giss.panoply.plot.PanVerticalLinePlot;
import gov.nasa.giss.panoply.plotui.PanControlsTabbedPane;
import gov.nasa.giss.panoply.plotui.PanPlotFrame;
import gov.nasa.giss.panoply.plotui.PanPlotHolder;
import gov.nasa.giss.panoply.prefs.PanPreferences;
import gov.nasa.giss.panoply.util.PanActionHash;
import gov.nasa.giss.panoply.util.PanAxisMethod;
import gov.nasa.giss.panoply.util.PanCombinationType;
import gov.nasa.giss.panoply.util.PanParameterKeys;
import gov.nasa.giss.panoply.util.PanPlotType;
import gov.nasa.giss.panoply.util.PanScaleMethod;
import gov.nasa.giss.panoply.util.PanVectorType;
import gov.nasa.giss.text.StringUtils;
import gov.nasa.giss.util.PlatformUtils;
import gov.nasa.giss.util.task.Task;
import gov.nasa.giss.util.task.TaskListener;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.lang.invoke.MethodHandles;
import javax.swing.Action;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanPlotMeta
extends PlotPropertyMap {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final boolean NO_TASKS = true;
    private final PanPlotType plotType_;
    private PanData data_;
    private PanPlot plot_;
    private PanPlotFrame pframe_;
    private PanScaleMeta smeta_;
    private PanProjectionMeta projmeta_;
    private PanPlotLayoutMeta layout_;
    private final PanActionHash actionHash_;
    private boolean initializing_;

    public PanPlotMeta(PanPlotType ptype, int sizeFactor) {
        this.plotType_ = ptype;
        this.actionHash_ = new PanActionHash(50);
        this.layout_ = new PanPlotLayoutMeta(this);
        this.initParameters(sizeFactor);
    }

    protected void initParameters(int sizeFactor) {
        int heightFactor;
        int widthFactor;
        this.initializing_ = true;
        PanPreferences prefs = PanPreferences.getSharedInstance();
        this.setSizeFactor(sizeFactor);
        switch (this.plotType_) {
            case LON_LAT: {
                widthFactor = prefs.getInt("plot:lonlat.size.width");
                heightFactor = prefs.getInt("plot:lonlat.size.height");
                break;
            }
            case LL_TRAJ: {
                widthFactor = prefs.getInt("plot:lonlat.size.width");
                heightFactor = prefs.getInt("plot:lonlat.size.height");
                break;
            }
            case LAT_TIME: {
                widthFactor = prefs.getInt("plot:lattime.size.width");
                heightFactor = prefs.getInt("plot:lattime.size.height");
                break;
            }
            case LAT_VERT: {
                widthFactor = prefs.getInt("plot:latvert.size.width");
                heightFactor = prefs.getInt("plot:latvert.size.height");
                break;
            }
            case LON_TIME: {
                widthFactor = prefs.getInt("plot:lontime.size.width");
                heightFactor = prefs.getInt("plot:lontime.size.height");
                break;
            }
            case LON_VERT: {
                widthFactor = prefs.getInt("plot:lonvert.size.width");
                heightFactor = prefs.getInt("plot:lonvert.size.height");
                break;
            }
            case TIME_LAT: {
                widthFactor = prefs.getInt("plot:timelat.size.width");
                heightFactor = prefs.getInt("plot:timelat.size.height");
                break;
            }
            case TIME_VERT: {
                widthFactor = prefs.getInt("plot:timevert.size.width");
                heightFactor = prefs.getInt("plot:timevert.size.height");
                break;
            }
            case GENERAL_2D: {
                widthFactor = prefs.getInt("plot:xy.size.width");
                heightFactor = prefs.getInt("plot:xy.size.height");
                break;
            }
            case HORZ_LINE: {
                widthFactor = prefs.getInt("plot:lineplot.horz.size.width");
                heightFactor = prefs.getInt("plot:lineplot.horz.size.height");
                break;
            }
            case VERT_LINE: {
                widthFactor = prefs.getInt("plot:lineplot.vert.size.width");
                heightFactor = prefs.getInt("plot:lineplot.vert.size.height");
                break;
            }
            default: {
                LOGGER.trace("Uncoded plot type {}", (Object)this.plotType_);
                widthFactor = 80;
                heightFactor = 45;
            }
        }
        if (heightFactor < 20) {
            LOGGER.warn("Height factor {} too small; using minimum {}.", (Object)sizeFactor, (Object)20);
            heightFactor = 20;
        } else if (heightFactor > 400) {
            LOGGER.warn("Height factor {} too big; using maximum {}.", (Object)sizeFactor, (Object)400);
            heightFactor = 400;
        }
        if (widthFactor < 20) {
            LOGGER.warn("Width factor {} too small; using minimum {}.", (Object)sizeFactor, (Object)20);
            widthFactor = 20;
        } else if (widthFactor > 100) {
            LOGGER.warn("Width factor {} too big; using maximum {}.", (Object)sizeFactor, (Object)100);
            widthFactor = 100;
        }
        this.setInt("size.height", heightFactor);
        this.setInt("size.width", widthFactor);
        this.setFloat("title.size", 16.0f);
        this.setFloat("subtitle.size", 12.0f);
        this.setFloat("footnote.size", 8.0f);
        this.set("type", this.plotType_);
        this.set("combination", PanCombinationType.A1_ONLY.name());
        this.setBoolean("include.title", true);
        this.setBoolean("include.scale", true);
        this.setBoolean("include.axes", true);
        this.setBoolean("include.footnotes", true);
        this.setBoolean("include.margins", true);
        this.setColor("color.background", prefs.getColor("plot:color.background"));
        this.setString("font.master", prefs.getString("plot:font.master"));
        this.setString("title.text", "PLOT TITLE");
        this.setString("subtitle.text", "");
        this.setString("footnote.left", "");
        this.setString("footnote.right", "");
        if (this.plotType_.isLinePlot()) {
            this.setBoolean("scale.autofit", false);
        } else {
            this.setColor("scale.invalids", prefs.getColor("plot:scale.invalids"));
            this.setBoolean("interpolate", prefs.getBoolean("plot:interpolate"));
            this.setBoolean("scale.autofit", prefs.getBoolean("plot:scale.autofit"));
        }
        this.setDouble("scale.min", 0.0);
        this.setDouble("scale.max", 1.0);
        this.setInt("scale.exponent", 0);
        this.setString("scale.units", "XXX");
        this.setString("scale.method", prefs.getString("plot:scale.method"));
        this.setInt("scale.div.major", prefs.getInt("plot:scale.div.major"));
        this.setInt("scale.div.minor", prefs.getInt("plot:scale.div.minor"));
        this.setString("scale.tick.format", prefs.getString("plot:scale.tick.format"));
        this.setFloat("scale.tick.size", prefs.getFloat("plot:scale.tick.size"));
        this.setBoolean("scale.label.custom", false);
        this.setString("scale.label.text", "SCALE CAPTION");
        this.setBoolean("scale.minmax.note", prefs.getBoolean("plot:scale.minmax.note"));
        this.setString("scale.minmax.format", prefs.getString("plot:scale.minmax.format"));
        if (this.plotType_.isLinePlot()) {
            this.setFloat("xaxis.label.size", prefs.getFloat("plot:1d.xaxis.label.size"));
            this.setFloat("yaxis.label.size", prefs.getFloat("plot:1d.yaxis.label.size"));
            if (this.plotType_ == PanPlotType.VERT_LINE) {
                this.setString("scale.method", PanScaleMethod.SCALAR.name().toLowerCase());
                this.setFloat("scale.label.size", prefs.getFloat("plot:1d.xaxis.label.size"));
                this.setFloat("scale.tick.size", prefs.getFloat("plot:1d.xaxis.tick.size"));
            } else {
                this.setFloat("scale.tick.size", prefs.getFloat("plot:1d.yaxis.tick.size"));
                this.setFloat("scale.label.size", prefs.getFloat("plot:1d.yaxis.label.size"));
            }
        } else {
            this.setFloat("scale.label.size", 14.0f);
        }
        if (this.plotType_.is2D()) {
            this.set("scale.colorbar", prefs.get("plot:scale.colorbar"));
            this.set("scale.width", prefs.getInt("plot:scale.width"));
            this.setBoolean("scale.reverse", prefs.getBoolean("plot:scale.reverse"));
            this.setString("scale.outlier.shape", prefs.getString("plot:scale.outlier.shape"));
            this.setString("scale.outlier.side", prefs.getString("plot:scale.outlier.side"));
            this.setString("scale.outlier.gap", prefs.getString("plot:scale.outlier.gap"));
            this.setString("scale.label.location", prefs.getString("plot:scale.label.location"));
            this.setFloat("xaxis.label.size", prefs.getFloat("plot:2d.xaxis.label.size"));
            this.setFloat("yaxis.label.size", prefs.getFloat("plot:2d.yaxis.label.size"));
        }
        this.setString("xaxis.method", PanAxisMethod.SCALAR.name());
        this.setDouble("xaxis.left", Double.NaN);
        this.setDouble("xaxis.right", Double.NaN);
        this.setString("xaxis.units", "");
        this.setString("xaxis.tick.format", "%.1f");
        this.setInt("xaxis.div.major", prefs.getInt("plot:xaxis.div.major"));
        this.setInt("xaxis.div.minor", prefs.getInt("plot:xaxis.div.minor"));
        this.setBoolean("xaxis.label.custom", false);
        this.setString("xaxis.label.text", "X AXIS");
        this.setString("yaxis.method", PanAxisMethod.SCALAR.name());
        this.setDouble("yaxis.bottom", Double.NaN);
        this.setDouble("yaxis.top", Double.NaN);
        this.setString("yaxis.units", "");
        this.setInt("yaxis.div.major", prefs.getInt("plot:yaxis.div.major"));
        this.setInt("yaxis.div.minor", prefs.getInt("plot:yaxis.div.minor"));
        this.setString("yaxis.tick.format", "%.1f");
        this.setBoolean("yaxis.label.custom", false);
        this.setString("yaxis.label.text", "Y AXIS");
        if (this.plotType_.isLinePlot()) {
            this.setInt("grid.weight", prefs.getInt("plot:1d.grid.weight"));
            this.setString("grid.style", prefs.getString("plot:1d.grid.style"));
            this.setBoolean("axes.offset", prefs.getBoolean("plot:1d.axes.offset"));
            this.setInt("axes.tickmark.weight", prefs.getInt("plot:1d.axes.tickmark.weight"));
            this.setString("axes.tickmark.color", prefs.getString("plot:1d.axes.tickmark.color"));
            this.setFloat("xaxis.tick.size", prefs.getFloat("plot:1d.xaxis.tick.size"));
            this.setFloat("yaxis.tick.size", prefs.getFloat("plot:1d.yaxis.tick.size"));
            this.setFloat("stroke.label.size", 11.0f);
            this.setColor(PanParameterKeys.STROKE_COLOR[0], prefs.getColor(PanParameterKeys.P_LINE_STROKE_COLOR[0]));
            this.setColor(PanParameterKeys.STROKE_COLOR[1], prefs.getColor(PanParameterKeys.P_LINE_STROKE_COLOR[1]));
            this.setString(PanParameterKeys.STROKE_STYLE[0], prefs.getString(PanParameterKeys.P_LINE_STROKE_STYLE[0]));
            this.setString(PanParameterKeys.STROKE_STYLE[1], prefs.getString(PanParameterKeys.P_LINE_STROKE_STYLE[1]));
            this.setInt(PanParameterKeys.STROKE_WEIGHT[0], prefs.getInt(PanParameterKeys.P_LINE_STROKE_WEIGHT[0]));
            this.setInt(PanParameterKeys.STROKE_WEIGHT[1], prefs.getInt(PanParameterKeys.P_LINE_STROKE_WEIGHT[1]));
            this.setBoolean(PanParameterKeys.STROKE_LABEL_CUSTOM[0], false);
            this.setBoolean(PanParameterKeys.STROKE_LABEL_CUSTOM[1], false);
            this.setString(PanParameterKeys.STROKE_LABEL_TEXT[0], "STROKE 1 CAPTION");
            this.setString(PanParameterKeys.STROKE_LABEL_TEXT[1], "STROKE 2 CAPTION");
        }
        if (!this.plotType_.isLinePlot()) {
            this.setColor("grid.color", prefs.getColor("plot:2d.grid.color"));
            this.setInt("grid.weight", prefs.getInt("plot:2d.grid.weight"));
            this.setString("grid.style", prefs.getString("plot:2d.grid.style"));
            this.setBoolean("axes.offset", prefs.getBoolean("plot:2d.axes.offset"));
            this.setInt("axes.tickmark.weight", prefs.getInt("plot:2d.axes.tickmark.weight"));
            this.setString("axes.tickmark.color", prefs.getString("plot:2d.axes.tickmark.color"));
            this.setFloat("xaxis.tick.size", prefs.getFloat("plot:2d.xaxis.tick.size"));
            this.setFloat("yaxis.tick.size", prefs.getFloat("plot:2d.yaxis.tick.size"));
            if (!this.plotType_.isFeatureType()) {
                this.setInt("contour.weight", prefs.getInt("plot:contour.weight"));
                this.setString("contour.style", prefs.getString("plot:contour.style"));
                this.setColor("contour.color", prefs.getColor("plot:contour.color"));
                this.setString("contour.location", prefs.getString("plot:contour.location"));
                this.setBoolean("contour.label.vis", prefs.getBoolean("plot:contour.label.vis"));
                this.setFloat("contour.label.size", prefs.getFloat("plot:contour.label.size"));
                this.setInt("vector.weight", prefs.getInt("plot:vector.weight"));
                this.setString("vector.style", prefs.getString("plot:vector.style"));
                this.setColor("vector.color", prefs.getColor("plot:vector.color"));
                this.setInt("vector.spacing", prefs.getInt("plot:vector.spacing"));
                this.setDouble("vector.refvalue", 1.0);
                this.setBoolean("vector.sample", prefs.getBoolean("plot:vector.sample"));
            }
            if (this.plotType_ == PanPlotType.LON_LAT || this.plotType_.isFeatureType()) {
                int i;
                String pname = prefs.getString("plot:lonlat.proj.name");
                this.projmeta_ = new PanProjectionMeta();
                this.projmeta_.setProjection(pname);
                this.setString("lonlat.lltype", prefs.getString("plot:lonlat.lltype"));
                this.setString("lonlat.proj.name", pname);
                this.setDouble("lonlat.proj.lon0", prefs.getDouble("plot:lonlat.proj.lon0"));
                this.setDouble("lonlat.proj.lat0", prefs.getDouble("plot:lonlat.proj.lat0"));
                for (i = 0; i < 5; ++i) {
                    Object s = this.projmeta_.getXParamValue(i);
                    if (s == null) continue;
                    String k = "lonlat.proj.xparam." + (i + 1);
                    try {
                        this.set(k, s);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.setInt("lonlat.border.weight", prefs.getInt("plot:lonlat.border.weight"));
                this.setFloat("grid.spacing.lon", prefs.getFloat("plot:grid.spacing.lon"));
                this.setFloat("grid.spacing.lat", prefs.getFloat("plot:grid.spacing.lat"));
                this.setBoolean("grid.offset.lat", prefs.getBoolean("plot:grid.offset.lat"));
                this.setInt("grid.label.step", prefs.getInt("plot:grid.label.step"));
                this.setFloat("grid.label.size", prefs.getFloat("plot:grid.label.size"));
                for (i = 0; i < 3; ++i) {
                    this.set(PanParameterKeys.LON_LAT_OVERLAY_NAME[i], prefs.get(PanParameterKeys.P_LON_LAT_OVERLAY_NAME[i]));
                    this.setColor(PanParameterKeys.LON_LAT_OVERLAY_COLOR[i], prefs.getColor(PanParameterKeys.P_LON_LAT_OVERLAY_COLOR[i]));
                    this.setBoolean(PanParameterKeys.LON_LAT_OVERLAY_INVERT[i], prefs.getBoolean(PanParameterKeys.P_LON_LAT_OVERLAY_INVERT[i]));
                    this.set(PanParameterKeys.LON_LAT_OVERLAY_STYLE[i], prefs.get(PanParameterKeys.P_LON_LAT_OVERLAY_STYLE[i]));
                    this.set(PanParameterKeys.LON_LAT_OVERLAY_SYMBOL_ID[i], prefs.get(PanParameterKeys.P_LON_LAT_OVERLAY_SYMBOL_ID[i]));
                    this.setFloat(PanParameterKeys.LON_LAT_OVERLAY_SYMBOL_SIZE[i], prefs.getFloat(PanParameterKeys.P_LON_LAT_OVERLAY_SYMBOL_SIZE[i]));
                    this.setInt(PanParameterKeys.LON_LAT_OVERLAY_WEIGHT[i], prefs.getInt(PanParameterKeys.P_LON_LAT_OVERLAY_WEIGHT[i]));
                }
                if (this.plotType_.isFeatureType()) {
                    this.setColor("feature.background", prefs.getColor("plot:feature.background"));
                    this.setBoolean("feature.nanskip", prefs.getBoolean("plot:feature.nanskip"));
                    this.set(PanParameterKeys.FEATURE_SYMBOL_ID[0], prefs.get(PanParameterKeys.P_FEATURE_SYMBOL_ID[0]));
                    this.set(PanParameterKeys.FEATURE_SYMBOL_ID[1], prefs.get(PanParameterKeys.P_FEATURE_SYMBOL_ID[1]));
                    this.setFloat(PanParameterKeys.FEATURE_SYMBOL_SIZE[0], prefs.getFloat(PanParameterKeys.P_FEATURE_SYMBOL_SIZE[0]));
                    this.setFloat(PanParameterKeys.FEATURE_SYMBOL_SIZE[1], prefs.getFloat(PanParameterKeys.P_FEATURE_SYMBOL_SIZE[1]));
                    this.setBoolean(PanParameterKeys.FEATURE_SYMBOL_FILL[0], prefs.getBoolean(PanParameterKeys.P_FEATURE_SYMBOL_FILL[0]));
                    this.setBoolean(PanParameterKeys.FEATURE_SYMBOL_FILL[1], prefs.getBoolean(PanParameterKeys.P_FEATURE_SYMBOL_FILL[1]));
                    this.setColor(PanParameterKeys.STROKE_COLOR[0], prefs.getColor(PanParameterKeys.P_TRAJ_STROKE_COLOR[0]));
                    this.setColor(PanParameterKeys.STROKE_COLOR[1], prefs.getColor(PanParameterKeys.P_TRAJ_STROKE_COLOR[1]));
                    this.setString(PanParameterKeys.STROKE_STYLE[0], prefs.getString(PanParameterKeys.P_TRAJ_STROKE_STYLE[0]));
                    this.setString(PanParameterKeys.STROKE_STYLE[1], prefs.getString(PanParameterKeys.P_TRAJ_STROKE_STYLE[1]));
                    this.setInt(PanParameterKeys.STROKE_WEIGHT[0], prefs.getInt(PanParameterKeys.P_TRAJ_STROKE_WEIGHT[0]));
                    this.setInt(PanParameterKeys.STROKE_WEIGHT[1], prefs.getInt(PanParameterKeys.P_TRAJ_STROKE_WEIGHT[1]));
                    this.setFloat("stroke.label.size", 11.0f);
                    this.setBoolean(PanParameterKeys.STROKE_LABEL_CUSTOM[0], false);
                    this.setBoolean(PanParameterKeys.STROKE_LABEL_CUSTOM[1], false);
                    this.setString(PanParameterKeys.STROKE_LABEL_TEXT[0], "STROKE 1 CAPTION");
                    this.setString(PanParameterKeys.STROKE_LABEL_TEXT[1], "STROKE 2 CAPTION");
                } else {
                    this.setBoolean("axes.offset", prefs.getBoolean("plot:1d.axes.offset"));
                    this.setString("vector.dir1", prefs.getString("plot:lonlat.vector.dir1"));
                    this.setString("vector.dir2", prefs.getString("plot:lonlat.vector.dir2"));
                    this.setDouble("xaxis.left", prefs.getDouble("plot:lonlat.zonal.xaxis.left"));
                    this.setDouble("xaxis.right", prefs.getDouble("plot:lonlat.zonal.xaxis.right"));
                    this.setString("xaxis.label.text", "Latitude (\u00b0N)");
                    this.setColor(PanParameterKeys.STROKE_COLOR[0], prefs.getColor(PanParameterKeys.P_LINE_STROKE_COLOR[0]));
                    this.setString(PanParameterKeys.STROKE_STYLE[0], prefs.getString(PanParameterKeys.P_LINE_STROKE_STYLE[0]));
                    this.setInt(PanParameterKeys.STROKE_WEIGHT[0], prefs.getInt(PanParameterKeys.P_LINE_STROKE_WEIGHT[0]));
                    this.setFloat("stroke.label.size", 11.0f);
                    this.setBoolean(PanParameterKeys.STROKE_LABEL_CUSTOM[0], false);
                    this.setString(PanParameterKeys.STROKE_LABEL_TEXT[0], "STROKE LABEL");
                }
                if (prefs.getBoolean("beta:numberlays")) {
                    this.setBoolean("lonlat.numbers.vis", prefs.getBoolean("plot:lonlat.numbers.vis"));
                    this.setBoolean("lonlat.numbers.invalids", prefs.getBoolean("plot:lonlat.numbers.invalids"));
                    this.setColor("lonlat.numbers.color", prefs.getColor("plot:lonlat.numbers.color"));
                    this.setInt("lonlat.numbers.weight", prefs.getInt("plot:lonlat.numbers.weight"));
                    this.setFloat("lonlat.numbers.size", prefs.getFloat("plot:lonlat.numbers.size"));
                    this.setDouble("lonlat.numbers.spacing.lon", prefs.getDouble("plot:lonlat.numbers.spacing.lon"));
                    this.setDouble("lonlat.numbers.spacing.lat", prefs.getDouble("plot:lonlat.numbers.spacing.lat"));
                    this.setBoolean("lonlat.numbers.offset.lon", prefs.getBoolean("plot:lonlat.numbers.offset.lon"));
                    this.setBoolean("lonlat.numbers.offset.lat", prefs.getBoolean("plot:lonlat.numbers.offset.lat"));
                } else {
                    this.setBoolean("lonlat.numbers.vis", false);
                }
                if (prefs.getBoolean("beta:underlays")) {
                    this.setBoolean("lonlat.underlay.vis", prefs.getBoolean("plot:lonlat.underlay.vis"));
                    this.set("lonlat.underlay.name", prefs.get("plot:lonlat.underlay.name"));
                    this.setString("main.alpha.method", prefs.getString("plot:main.alpha.method"));
                    this.setInt("main.alpha.1", prefs.getInt("plot:main.alpha.1"));
                    this.setInt("main.alpha.2", prefs.getInt("plot:main.alpha.2"));
                    this.setBoolean("main.alpha.knockout", prefs.getBoolean("plot:main.alpha.knockout"));
                } else {
                    this.setBoolean("main.alpha.knockout", false);
                }
                this.setBoolean("lonlat.proj.shading.vis", prefs.getBoolean("plot:lonlat.proj.shading.vis"));
                this.setInt("lonlat.proj.shading.opacity", prefs.getInt("plot:lonlat.proj.shading.opacity"));
                this.setDouble("lonlat.proj.subsolar.lon", prefs.getDouble("plot:lonlat.proj.subsolar.lon"));
                this.setDouble("lonlat.proj.subsolar.lat", prefs.getDouble("plot:lonlat.proj.subsolar.lat"));
            } else {
                switch (this.plotType_) {
                    case LAT_TIME: {
                        this.setDouble("xaxis.left", prefs.getDouble("plot:lattime.xaxis.left"));
                        this.setDouble("xaxis.right", prefs.getDouble("plot:lattime.xaxis.right"));
                        this.setString("xaxis.label.text", "Latitude (\u00b0N)");
                        this.setString("yaxis.tick.format", "yyyy-MM-dd");
                        this.setString("yaxis.label.text", "TIME AXIS");
                        break;
                    }
                    case LAT_VERT: {
                        this.setDouble("xaxis.left", prefs.getDouble("plot:latvert.xaxis.left"));
                        this.setDouble("xaxis.right", prefs.getDouble("plot:latvert.xaxis.right"));
                        this.setString("xaxis.label.text", "Latitude (\u00b0N)");
                        this.setString("yaxis.method", prefs.getString("plot:latvert.yaxis.method"));
                        this.setString("yaxis.label.text", "VERTICAL AXIS");
                        this.setString("yaxis.tick.format", prefs.getString("plot:latvert.yaxis.tick.format"));
                        this.setString("vector.dir1", "North");
                        this.setString("vector.dir2", "Up");
                        break;
                    }
                    case LON_TIME: {
                        this.setDouble("xaxis.left", prefs.getDouble("plot:lontime.xaxis.left"));
                        this.setDouble("xaxis.right", prefs.getDouble("plot:lontime.xaxis.right"));
                        this.setString("xaxis.label.text", "Longitude (\u00b0E)");
                        this.setString("yaxis.label.text", "TIME AXIS");
                        break;
                    }
                    case LON_VERT: {
                        this.setDouble("xaxis.left", prefs.getDouble("plot:lonvert.xaxis.left"));
                        this.setDouble("xaxis.right", prefs.getDouble("plot:lonvert.xaxis.right"));
                        this.setString("xaxis.label.text", "Longitude (\u00b0E)");
                        this.setString("yaxis.method", prefs.getString("plot:lonvert.yaxis.method"));
                        this.setString("yaxis.label.text", "VERTICAL AXIS");
                        this.setString("yaxis.tick.format", prefs.getString("plot:lonvert.yaxis.tick.format"));
                        this.setString("vector.dir1", "East");
                        this.setString("vector.dir2", "Up");
                        break;
                    }
                    case TIME_LAT: {
                        this.setString("xaxis.tick.format", "yyyy-MM-dd");
                        this.setInt("xaxis.div.major", prefs.getInt("plot:timelat.xaxis.div.major"));
                        this.setInt("xaxis.div.minor", prefs.getInt("plot:timelat.xaxis.div.minor"));
                        this.setString("xaxis.label.text", "TIME AXIS");
                        this.setDouble("yaxis.top", prefs.getDouble("plot:timelat.yaxis.top"));
                        this.setDouble("yaxis.bottom", prefs.getDouble("plot:timelat.yaxis.bottom"));
                        this.setString("yaxis.label.text", "Latitude (\u00b0N)");
                        break;
                    }
                    case TIME_VERT: {
                        this.setString("xaxis.tick.format", "yyyy-MM-dd");
                        this.setInt("xaxis.div.major", prefs.getInt("plot:timevert.xaxis.div.major"));
                        this.setInt("xaxis.div.minor", prefs.getInt("plot:timevert.xaxis.div.minor"));
                        this.setString("xaxis.label.text", "TIME AXIS");
                        this.setString("yaxis.method", prefs.getString("plot:timevert.yaxis.method"));
                        this.setString("yaxis.label.text", "VERTICAL AXIS");
                        this.setString("yaxis.tick.format", prefs.getString("plot:timevert.yaxis.tick.format"));
                        break;
                    }
                    case GENERAL_2D: {
                        this.setInt("xaxis.div.major", prefs.getInt("plot:xy.xaxis.div.major"));
                        this.setInt("xaxis.div.minor", prefs.getInt("plot:xy.xaxis.div.minor"));
                        this.setString("xaxis.tick.format", prefs.getString("plot:xy.xaxis.tick.format"));
                        this.setInt("yaxis.div.major", prefs.getInt("plot:xy.yaxis.div.major"));
                        this.setInt("yaxis.div.minor", prefs.getInt("plot:xy.yaxis.div.minor"));
                        this.setString("yaxis.tick.format", prefs.getString("plot:xy.yaxis.tick.format"));
                        this.setString("vector.dir1", "Right");
                        this.setString("vector.dir2", "Up");
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unknown plot type enum");
                    }
                }
            }
        }
        this.initializing_ = false;
    }

    public PanPlotLayoutMeta getLayout() {
        return this.layout_;
    }

    public PanPlotType getType() {
        return this.plotType_;
    }

    public boolean isLonLatMap() {
        return this.plotType_ == PanPlotType.LON_LAT && this.getString("lonlat.lltype").toLowerCase().contains("map") || this.plotType_.isFeatureType();
    }

    public boolean isLonLatZonal() {
        return this.plotType_ == PanPlotType.LON_LAT && this.getString("lonlat.lltype").toLowerCase().contains("zon");
    }

    public boolean isColorFillMap() {
        return this.plotType_ == PanPlotType.LON_LAT && this.getString("lonlat.lltype").toLowerCase().contains("map");
    }

    public boolean isLonLatTrajectory() {
        return this.plotType_ == PanPlotType.LL_TRAJ;
    }

    public PanData getData() {
        return this.data_;
    }

    public PanScaleMeta getScaleMeta() {
        return this.smeta_;
    }

    public PanPlot getPlot() {
        return this.plot_;
    }

    public PanProjectionMeta getProjectionMeta() {
        return this.projmeta_;
    }

    public PanPlotFrame getFrame() {
        return this.pframe_;
    }

    public void setFrame(PanPlotFrame pf) {
        this.pframe_ = pf;
    }

    public PanActionHash getActionHash() {
        return this.actionHash_;
    }

    public void putAction(String key, Action action) {
        this.actionHash_.put(key, action);
    }

    public PanData createData(NcVariable ncvar) {
        PanData data = this.createData(ncvar, new Object[0]);
        return data;
    }

    public PanData createData(NcVariable ncvar, Object ... axisinfo) {
        if (this.data_ != null) {
            throw new IllegalArgumentException("Data object already exists.");
        }
        NcArray ncarray = null;
        try {
            ncarray = PanNcUtils.createArray(ncvar, this.plotType_, axisinfo);
        }
        catch (IllegalArgumentException exc) {
            throw exc;
        }
        catch (Exception exc) {
            String msg = exc.toString().replaceFirst(".*: ", "");
            if (LOGGER.isTraceEnabled()) {
                exc.printStackTrace();
            }
            throw new RuntimeException(msg);
        }
        if (ncarray == null) {
            throw new RuntimeException("Array creation returned null object.");
        }
        Dimension dsize = (Dimension)this.layout_.getParam("size.gridding");
        try {
            switch (this.plotType_) {
                case LON_LAT: {
                    this.data_ = new PanDataLonLat(ncarray, dsize);
                    break;
                }
                case LAT_TIME: {
                    this.data_ = new PanDataLatTime(ncarray, dsize);
                    ((PanDataGeneral2D)this.data_).setGridLeftAndRight(this.getDouble("xaxis.left"), this.getDouble("xaxis.right"));
                    break;
                }
                case LAT_VERT: {
                    this.data_ = new PanDataLatVert(ncarray, dsize);
                    ((PanDataLatVert)this.data_).setYAxisMethod(PanAxisMethod.matching(this.getString("yaxis.method")));
                    ((PanDataGeneral2D)this.data_).setGridLeftAndRight(this.getDouble("xaxis.left"), this.getDouble("xaxis.right"));
                    break;
                }
                case LON_TIME: {
                    this.data_ = new PanDataLonTime(ncarray, dsize);
                    ((PanDataGeneral2D)this.data_).setGridLeftAndRight(this.getDouble("xaxis.left"), this.getDouble("xaxis.right"));
                    break;
                }
                case LON_VERT: {
                    this.data_ = new PanDataLonVert(ncarray, dsize);
                    ((PanDataLonVert)this.data_).setYAxisMethod(PanAxisMethod.matching(this.getString("yaxis.method")));
                    ((PanDataGeneral2D)this.data_).setGridLeftAndRight(this.getDouble("xaxis.left"), this.getDouble("xaxis.right"));
                    break;
                }
                case TIME_LAT: {
                    this.data_ = new PanDataTimeLat(ncarray, dsize);
                    ((PanDataGeneral2D)this.data_).setGridBottomAndTop(this.getDouble("yaxis.bottom"), this.getDouble("yaxis.top"));
                    break;
                }
                case TIME_VERT: {
                    this.data_ = new PanDataTimeVert(ncarray, dsize);
                    ((PanDataTimeVert)this.data_).setYAxisMethod(PanAxisMethod.matching(this.getString("yaxis.method")));
                    ((PanDataGeneral2D)this.data_).setGridBottomAndTop(this.getDouble("yaxis.bottom"), this.getDouble("yaxis.top"));
                    break;
                }
                case GENERAL_2D: {
                    this.data_ = new PanDataGeneral2D(ncarray, dsize);
                    break;
                }
                case LL_TRAJ: {
                    this.data_ = new PanDataLonLatTrajectory(ncarray);
                    break;
                }
                case HORZ_LINE: 
                case VERT_LINE: {
                    NcAxis a = ((NcArray1D)ncarray).getAxis();
                    if (a instanceof NcTimeAxis && ((NcTimeAxis)a).isPatternTime()) {
                        this.data_ = new PanDataTime1D(ncarray);
                        String s = ((PanDataTime1D)this.data_).getAxisPattern();
                        if (this.plotType_ == PanPlotType.HORZ_LINE) {
                            this.setString("xaxis.tick.format", s);
                            break;
                        }
                        this.setString("yaxis.tick.format", s);
                        break;
                    }
                    this.data_ = new PanData1D(ncarray);
                    break;
                }
                default: {
                    LOGGER.error("Default reached. Data obj not created");
                }
            }
        }
        catch (Exception exc) {
            String msg;
            LOGGER.error("Exception cresting data object: {}", exc);
            if (LOGGER.isTraceEnabled()) {
                exc.printStackTrace();
            }
            if ((msg = exc.toString().replaceAll(".*: ", "")).contains("EOF")) {
                msg = "End of file exception.";
            }
            throw new RuntimeException(msg);
        }
        return this.data_;
    }

    public PanPlot createPlot() {
        double[] range;
        PanAxisMethod method;
        if (this.data_ == null) {
            throw new RuntimeException("Data object not yet created.");
        }
        this.smeta_ = new PanScaleMeta(this, this.data_);
        this.setString("title.text", this.data_.getArray(0).getLongName());
        if (this.plotType_ == PanPlotType.GENERAL_2D || this.plotType_ == PanPlotType.TIME_LAT || this.plotType_ == PanPlotType.TIME_VERT) {
            method = PanAxisMethod.matching(this.getString("xaxis.method"));
            range = ((PanDataGeneral2D)this.data_).getDefaultLeftAndRight(method);
            String xunits = ((PanDataGeneral2D)this.data_).getDataXAxisUnits();
            this.setGridLeftAndRight(range[0], range[1]);
            this.setString("xaxis.units", xunits);
            ((PanDataGeneral2D)this.data_).setGridLeftAndRight(range[0], range[1]);
        }
        if (this.plotType_ == PanPlotType.GENERAL_2D || this.plotType_ == PanPlotType.LAT_VERT || this.plotType_ == PanPlotType.LON_VERT || this.plotType_ == PanPlotType.TIME_VERT || this.plotType_ == PanPlotType.LAT_TIME || this.plotType_ == PanPlotType.LON_TIME) {
            method = PanAxisMethod.matching(this.getString("yaxis.method"));
            range = ((PanDataGeneral2D)this.data_).getDefaultBottomAndTop(method);
            String yunits = ((PanDataGeneral2D)this.data_).getDataYAxisUnits();
            this.setGridBottomAndTop(range[0], range[1]);
            this.setString("yaxis.units", yunits);
        }
        if (this.plotType_.isLinePlot()) {
            method = this.plotType_ == PanPlotType.HORZ_LINE ? PanAxisMethod.matching(this.getString("xaxis.method")) : PanAxisMethod.matching(this.getString("yaxis.method"));
            range = ((PanData1D)this.data_).getDefaultAxisRange(method);
            if (this.plotType_ == PanPlotType.HORZ_LINE) {
                this.setDouble("xaxis.left", range[0]);
                this.setDouble("xaxis.right", range[1]);
            } else {
                this.setDouble("yaxis.bottom", range[0]);
                this.setDouble("yaxis.top", range[1]);
            }
            ((PanData1D)this.data_).setAxisBounds(range[0], range[1]);
        }
        double dmin = this.data_.getMinValue();
        double dmax = this.data_.getMaxValue();
        if (Double.isNaN(dmin)) {
            dmin = 0.0;
            dmax = 1.0E-25;
        }
        if (dmax == dmin) {
            dmax = dmin + 1.0E-25;
        }
        this.setDouble("scale.min", dmin);
        this.setDouble("scale.max", dmax);
        double dmag = 0.75 * MathUtils.max(1.0, Math.abs(dmin), Math.abs(dmax));
        if (this.plotType_ == PanPlotType.LON_LAT || this.plotType_ == PanPlotType.LAT_VERT || this.plotType_ == PanPlotType.LON_VERT || this.plotType_ == PanPlotType.GENERAL_2D) {
            this.setDouble("vector.refvalue", dmag);
        }
        switch (this.plotType_) {
            case LON_LAT: 
            case LL_TRAJ: {
                this.plot_ = new PanLonLatPlot(this);
                break;
            }
            case LAT_TIME: {
                this.plot_ = new PanLatTimePlot(this);
                break;
            }
            case LAT_VERT: {
                this.plot_ = new PanLatVertPlot(this);
                break;
            }
            case LON_TIME: {
                this.plot_ = new PanLonTimePlot(this);
                break;
            }
            case LON_VERT: {
                this.plot_ = new PanLonVertPlot(this);
                break;
            }
            case TIME_LAT: {
                this.plot_ = new PanTimeLatPlot(this);
                break;
            }
            case TIME_VERT: {
                this.plot_ = new PanTimeYPlot(this);
                break;
            }
            case GENERAL_2D: {
                this.plot_ = new PanGeneral2DPlot(this);
                break;
            }
            case HORZ_LINE: {
                this.plot_ = new PanHorizontalLinePlot(this);
                break;
            }
            case VERT_LINE: {
                this.plot_ = new PanVerticalLinePlot(this);
                break;
            }
            default: {
                throw new RuntimeException("Unknown plot type enum");
            }
        }
        this.plot_.setSize((Dimension)this.layout_.getParam("size.pixels"));
        return this.plot_;
    }

    @Override
    public Object put(final String key, final Object value) {
        boolean onEDT = EventQueue.isDispatchThread();
        if (onEDT && this.pframe_ != null) {
            String s = key.replaceAll(".*\\.", "");
            Task task = new Task("Setting parameter " + s){

                @Override
                protected Object beginTask() {
                    return PanPlotMeta.this.beginPut(key, value);
                }

                @Override
                protected void finishTask() {
                    PanPlotMeta.this.updateUI();
                }
            };
            this.pframe_.addTask(task);
            return null;
        }
        Object o = this.beginPut(key, value);
        this.updateUI();
        return o;
    }

    protected Object beginPut(String key, Object value) {
        try {
            if (this.isProjectionNameKey(key) || this.isProjectionParamKey(key)) {
                this.handleProjectionParam(key, value);
            }
            return super.put(key, value);
        }
        catch (IllegalArgumentException exc) {
            throw exc;
        }
        catch (Exception exc) {
            return null;
        }
    }

    private final void updateUI() {
        if (this.pframe_ == null) {
            return;
        }
        this.refreshControls();
        this.refreshPlot();
    }

    @Override
    protected synchronized void firePropertyChanged(String key) {
        super.firePropertyChanged(key);
    }

    @Override
    public Object setGroup(final Object[] ... keyValuePairs) {
        boolean onEDT = EventQueue.isDispatchThread();
        if (onEDT && this.pframe_ != null) {
            Task task = new Task("Setting parameter group"){

                @Override
                protected Object beginTask() {
                    return PanPlotMeta.this.beginSetGroup(keyValuePairs);
                }

                @Override
                protected void finishTask() {
                    PanPlotMeta.this.finishSetGroup();
                }
            };
            this.pframe_.addTask(task);
            return null;
        }
        Object o = this.beginSetGroup(keyValuePairs);
        this.finishSetGroup();
        return o;
    }

    protected Object beginSetGroup(Object[] ... keyValuePairs) {
        int i;
        for (i = 0; i < keyValuePairs.length; ++i) {
            if (!this.isProjectionNameKey((String)keyValuePairs[i][0])) continue;
            this.handleProjectionName((String)keyValuePairs[i][1]);
        }
        for (i = 0; i < keyValuePairs.length; ++i) {
            if (!this.isProjectionParamKey((String)keyValuePairs[i][0])) continue;
            this.handleProjectionParam((String)keyValuePairs[i][0], keyValuePairs[i][1]);
        }
        return super.setGroup(keyValuePairs);
    }

    protected void finishSetGroup() {
        if (this.pframe_ == null) {
            return;
        }
        this.refreshControls();
        this.refreshPlot();
    }

    private boolean isProjectionNameKey(String key) {
        return key.equals("lonlat.proj.name");
    }

    private boolean isProjectionParamKey(String key) {
        return key.equals("lonlat.proj.lon0") || key.equals("lonlat.proj.lat0") || key.contains("lonlat.proj.xparam");
    }

    private final void handleProjectionName(String name) {
        if (!(this.plot_ instanceof PanLonLatPlot)) {
            return;
        }
        this.projmeta_.setProjection(name);
        AbstractProjection proj = this.projmeta_.getProjection();
        int pcount = proj.getExtraParamCount();
        for (int i = 0; i < pcount; ++i) {
            String pkeyx = "lonlat.proj.xparam." + (i + 1);
            Object value = this.projmeta_.getXParamValue(i);
            super.set(pkeyx, value);
        }
    }

    private boolean handleProjectionParam(String pkey, Object value) {
        if (this.isProjectionNameKey(pkey)) {
            this.handleProjectionName((String)value);
        } else if (pkey.equals("lonlat.proj.lon0")) {
            if (value instanceof Double) {
                this.projmeta_.setCenterLon((Double)value);
            } else {
                this.projmeta_.setCenterLon(StringUtils.parseDouble(value.toString()));
            }
        } else if (pkey.equals("lonlat.proj.lat0")) {
            if (value instanceof Double) {
                this.projmeta_.setCenterLat((Double)value);
            } else {
                this.projmeta_.setCenterLat(StringUtils.parseDouble(value.toString()));
            }
        } else if (pkey.contains("lonlat.proj.xparam")) {
            int pid = Integer.valueOf(pkey.substring(pkey.length() - 1)) - 1;
            if (value == null) {
                return this.projmeta_.setExtraParameter(pid, null);
            }
            return this.projmeta_.setExtraParameter(pid, value);
        }
        return true;
    }

    @Override
    public void setBoolean(String pkey, boolean pvalue) {
        if (pkey.equals("interpolate")) {
            this.setDataInterpolated(pvalue, null);
        } else if (pkey.equals("include.title") || pkey.equals("include.scale") || pkey.equals("include.axes") || pkey.equals("include.footnotes") || pkey.equals("include.margins")) {
            this.layout_.setParam(pkey, pvalue);
            super.setBoolean(pkey, pvalue);
            return;
        }
        super.setBoolean(pkey, pvalue);
    }

    @Override
    public void setDouble(String pkey, double pvalue) {
        if (this.initializing_) {
            super.setDouble(pkey, pvalue);
            return;
        }
        if (pkey.equals("xaxis.left")) {
            if (this.plotType_ == PanPlotType.VERT_LINE) {
                LOGGER.trace("Trying to set X axis range on vert line plot");
                return;
            }
            double rval = this.getDouble("xaxis.right");
            this.setGridLeftAndRight(pvalue, rval);
        } else if (pkey.equals("xaxis.right")) {
            if (this.plotType_ == PanPlotType.VERT_LINE) {
                LOGGER.trace("Trying to set X axis range on vert line plot");
                return;
            }
            double lval = this.getDouble("xaxis.left");
            this.setGridLeftAndRight(lval, pvalue);
        } else if (pkey.equals("yaxis.bottom")) {
            if (this.plotType_ == PanPlotType.HORZ_LINE) {
                LOGGER.trace("Trying to set Y axis range on horizontal line plot");
                return;
            }
            double tval = this.getDouble("yaxis.top");
            this.setGridBottomAndTop(pvalue, tval);
        } else if (pkey.equals("yaxis.top")) {
            if (this.plotType_ == PanPlotType.HORZ_LINE) {
                LOGGER.trace("Trying to set Y axis range on horizontal line plot");
                return;
            }
            double bval = this.getDouble("yaxis.bottom");
            this.setGridBottomAndTop(bval, pvalue);
        }
        super.setDouble(pkey, pvalue);
    }

    @Override
    public void setFloat(String pkey, float pvalue) {
        if (pkey.equals("title.size") || pkey.equals("subtitle.size") || pkey.equals("footnote.size")) {
            this.layout_.setParam(pkey, Float.valueOf(pvalue));
            super.setFloat(pkey, pvalue);
        } else {
            super.setFloat(pkey, pvalue);
        }
    }

    @Override
    public void setInt(String pkey, int pvalue) {
        if (pkey.equals("size.factor")) {
            this.setSizeFactor(pvalue);
        } else if (pkey.equals("size.width") || pkey.equals("size.height")) {
            this.layout_.setParam(pkey, pvalue);
            super.setInt(pkey, pvalue);
        } else if (pkey.equals("scale.exponent")) {
            super.setInt(pkey, pvalue);
            this.setDataScalingExponent(pvalue, null);
        } else {
            super.setInt(pkey, pvalue);
        }
    }

    private final void setSizeFactor(int szfactor) {
        int sfactor = szfactor;
        if (sfactor == 0) {
            PanPreferences prefs = PanPreferences.getSharedInstance();
            sfactor = prefs.getInt("plot:size.factor");
        }
        if (sfactor < 80) {
            LOGGER.warn("Size factor {} too small; using min {}.", (Object)sfactor, (Object)80);
            sfactor = 80;
        } else if (PlatformUtils.isHeadless()) {
            if (sfactor > 500) {
                LOGGER.warn("Size factor {} too big; using CL max {}.", (Object)sfactor, (Object)500);
                sfactor = 500;
            }
        } else if (sfactor > 300) {
            LOGGER.warn("Size factor {} too big; using max {}.", (Object)sfactor, (Object)300);
            sfactor = 300;
        }
        this.layout_.setParam("size.factor", szfactor);
        super.setInt("size.factor", sfactor);
    }

    @Override
    public void setString(String pkey, String pvalue) {
        if (pkey.equals("xaxis.method")) {
            this.handleXAxisMethod(pvalue);
        } else if (pkey.equals("yaxis.method")) {
            this.handleYAxisMethod(pvalue);
        } else if (pkey.equals("xaxis.units")) {
            if (this.data_ != null) {
                if (this.data_ instanceof PanDataGeneral2D) {
                    ((PanDataGeneral2D)this.data_).setXAxisUnits(pvalue);
                } else {
                    ((PanData1D)this.data_).setAxisUnits(pvalue);
                }
            }
            super.setString(pkey, pvalue);
        } else if (pkey.equals("yaxis.units")) {
            if (this.data_ != null) {
                if (this.data_ instanceof PanDataGeneral2D) {
                    ((PanDataGeneral2D)this.data_).setYAxisUnits(pvalue);
                } else {
                    LOGGER.trace("Set YAXIS_UNITS {}", (Object)pvalue);
                    ((PanData1D)this.data_).setAxisUnits(pvalue);
                }
            }
            super.setString(pkey, pvalue);
        } else if (pkey.equals("combination")) {
            this.setDataCombination(pvalue, null);
        } else if (pkey.equals("scale.units")) {
            this.setScaleUnits(pvalue, null);
        } else {
            super.setString(pkey, pvalue);
        }
    }

    private final void handleXAxisMethod(String newName) {
        double newVal2;
        double newVal1;
        double[] range;
        String oldName = this.getString("xaxis.method");
        PanAxisMethod newMethod = PanAxisMethod.matching(newName);
        String xnewName = newMethod.name();
        if (this.data_ == null) {
            super.set("xaxis.method", xnewName);
            return;
        }
        if (this.data_ instanceof PanDataGeneral2D) {
            PanDataGeneral2D data2d = (PanDataGeneral2D)this.data_;
            range = data2d.getDefaultLeftAndRight(newMethod);
        } else if (this.plotType_ == PanPlotType.HORZ_LINE) {
            PanData1D data1d = (PanData1D)this.data_;
            range = data1d.getDefaultAxisRange(newMethod);
        } else {
            if (this.plotType_ == PanPlotType.VERT_LINE) {
                throw new RuntimeException("Y axis for 1D plot is the scale");
            }
            throw new RuntimeException("Mystery case");
        }
        double oldVal1 = this.getDouble("xaxis.left");
        double oldVal2 = this.getDouble("xaxis.right");
        if (Double.isNaN(oldVal1)) {
            oldVal1 = range[0];
        }
        if (Double.isNaN(oldVal2)) {
            oldVal2 = range[1];
        }
        PanAxisMethod oldMethod = PanAxisMethod.matching(oldName);
        if (newMethod == PanAxisMethod.INDEX || oldMethod == null || oldMethod == PanAxisMethod.INDEX) {
            newVal1 = range[0];
            newVal2 = range[1];
        } else if (newMethod == PanAxisMethod.LOG10) {
            newVal1 = oldVal1;
            newVal2 = oldVal2;
            if (newVal1 <= 0.0) {
                newVal1 = 1.0E-50;
            }
            if (newVal2 <= 0.0) {
                newVal2 = 1.0E-50;
            }
            if (newVal2 == newVal1) {
                newVal2 += 1.0E-25;
            }
        } else {
            newVal1 = oldVal1;
            newVal2 = oldVal2;
        }
        this.setGroup({"xaxis.method", xnewName}, {"xaxis.left", newVal1}, {"xaxis.right", newVal2});
        if (this.data_ instanceof PanDataGeneral2D) {
            PanDataGeneral2D data2d = (PanDataGeneral2D)this.data_;
            data2d.setXAxisMethod(newMethod);
            data2d.setGridLeftAndRight(newVal1, newVal2);
        } else if (this.plotType_ == PanPlotType.HORZ_LINE) {
            PanData1D data1d = (PanData1D)this.data_;
            data1d.setAxisMethod(newMethod);
            data1d.setAxisBounds(newVal1, newVal2);
        }
    }

    private final void handleYAxisMethod(String newName) {
        double newVal2;
        double newVal1;
        double[] range;
        PanAxisMethod newMethod = PanAxisMethod.matching(newName);
        String ynewName = newMethod.name();
        if (this.data_ == null) {
            super.set("yaxis.method", ynewName);
            return;
        }
        if (this.data_ instanceof PanDataGeneral2D) {
            PanDataGeneral2D data2d = (PanDataGeneral2D)this.data_;
            range = data2d.getDefaultBottomAndTop(newMethod);
        } else if (this.plotType_ == PanPlotType.VERT_LINE) {
            PanData1D data1d = (PanData1D)this.data_;
            range = data1d.getDefaultAxisRange(newMethod);
        } else {
            if (this.plotType_ == PanPlotType.HORZ_LINE) {
                throw new RuntimeException("X axis for 1D plot is the scale");
            }
            throw new RuntimeException("Mystery case");
        }
        double oldVal1 = this.getDouble("yaxis.bottom");
        double oldVal2 = this.getDouble("yaxis.top");
        if (Double.isNaN(oldVal1)) {
            oldVal1 = range[0];
        }
        if (Double.isNaN(oldVal2)) {
            oldVal2 = range[1];
        }
        String oldName = this.getString("yaxis.method");
        PanAxisMethod oldMethod = PanAxisMethod.matching(oldName);
        if (newMethod == PanAxisMethod.INDEX || oldMethod == null || oldMethod == PanAxisMethod.INDEX) {
            newVal1 = range[0];
            newVal2 = range[1];
        } else if (newMethod == PanAxisMethod.LOG10) {
            newVal1 = oldVal1;
            newVal2 = oldVal2;
            if (newVal2 <= 0.0) {
                newVal2 = 1.0E-50;
            }
            if (newVal1 <= 0.0) {
                newVal1 = 1.0E-50;
            }
            if (newVal2 == newVal1) {
                newVal2 += 1.0E-25;
            }
        } else {
            newVal1 = oldVal1;
            newVal2 = oldVal2;
        }
        this.setGroup({"yaxis.method", ynewName}, {"yaxis.bottom", newVal1}, {"yaxis.top", newVal2});
        if (this.data_ instanceof PanDataGeneral2D) {
            PanDataGeneral2D data2d = (PanDataGeneral2D)this.data_;
            data2d.setYAxisMethod(newMethod);
            data2d.setGridBottomAndTop(newVal1, newVal2);
        } else if (this.plotType_ == PanPlotType.VERT_LINE) {
            PanData1D data1d = (PanData1D)this.data_;
            data1d.setAxisMethod(newMethod);
            data1d.setAxisBounds(newVal1, newVal2);
        }
    }

    public void setGridLeftAndRight(double left, double right) {
        if (this.data_ == null) {
            return;
        }
        this.setGroup({"xaxis.left", left}, {"xaxis.right", right});
        if (this.data_ instanceof PanDataGeneral2D) {
            ((PanDataGeneral2D)this.data_).setGridLeftAndRight(left, right);
        } else if (this.plotType_ == PanPlotType.HORZ_LINE) {
            ((PanData1D)this.data_).setAxisBounds(left, right);
        } else if (this.plotType_ == PanPlotType.VERT_LINE) {
            LOGGER.trace("How did we get here?");
        } else {
            LOGGER.trace("called for plot type {}", (Object)this.plotType_);
        }
    }

    public void setGridBottomAndTop(double bottom, double top) {
        this.setGroup({"yaxis.bottom", bottom}, {"yaxis.top", top});
        if (this.data_ == null) {
            return;
        }
        if (this.data_ instanceof PanDataGeneral2D) {
            ((PanDataGeneral2D)this.data_).setGridBottomAndTop(bottom, top);
        } else if (this.plotType_ == PanPlotType.VERT_LINE) {
            ((PanData1D)this.data_).setAxisBounds(bottom, top);
        } else if (this.plotType_ == PanPlotType.HORZ_LINE) {
            LOGGER.trace("How did we get here?");
        } else {
            LOGGER.trace("called for plot type {}", (Object)this.plotType_);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNcArray(final int idx, final NcArray nca, TaskListener tl) {
        PanPlotMeta panPlotMeta = this;
        synchronized (panPlotMeta) {
            if (this.data_ == null) {
                return;
            }
            if (this.pframe_ == null) {
                this.beginSetNcArray(idx, nca);
                this.finishSetNcArray(idx);
            } else {
                Task task = new Task("Adding variable"){

                    @Override
                    protected Object beginTask() {
                        if (PanPlotMeta.this.data_ == null) {
                            LOGGER.warn("Data var now null; canceling setNcArray task.");
                            this.cancel(true);
                            return null;
                        }
                        PanPlotMeta.this.beginSetNcArray(idx, nca);
                        return null;
                    }

                    @Override
                    protected void finishTask() {
                        if (PanPlotMeta.this.data_ == null) {
                            LOGGER.warn("Data var now null; canceling setNcArray completion.");
                            return;
                        }
                        PanPlotMeta.this.finishSetNcArray(idx);
                    }
                };
                if (tl != null) {
                    task.addTaskListener(tl);
                }
                this.pframe_.addTask(task);
            }
        }
    }

    private final void beginSetNcArray(int idx, NcArray nca) {
        this.data_.setArray(idx, nca);
    }

    private final void finishSetNcArray(int idx) {
        if (this.pframe_ == null) {
            return;
        }
        this.pframe_.updateArrayDataPanel(idx);
        this.refreshControls();
        this.refreshPlot();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDataSlice(final int arrayNum, final int dimNum, final int index, TaskListener tl) {
        PanPlotMeta panPlotMeta = this;
        synchronized (panPlotMeta) {
            if (this.data_ == null) {
                return;
            }
            if (this.pframe_ == null) {
                this.beginSetDataSlice(arrayNum, dimNum, index);
                this.finishSetDataSlice();
            } else {
                Task task = new Task("Changing array slice"){

                    @Override
                    protected Object beginTask() {
                        if (PanPlotMeta.this.data_ == null) {
                            LOGGER.warn("Data var is null; canceling setDataSlice task.");
                            this.cancel(true);
                            return null;
                        }
                        PanPlotMeta.this.beginSetDataSlice(arrayNum, dimNum, index);
                        return null;
                    }

                    @Override
                    protected void finishTask() {
                        if (PanPlotMeta.this.data_ == null) {
                            LOGGER.warn("Data var is null; canceling setDataSlice completion.");
                            return;
                        }
                        PanPlotMeta.this.finishSetDataSlice();
                    }
                };
                if (tl != null) {
                    task.addTaskListener(tl);
                }
                this.pframe_.addTask(task);
            }
        }
    }

    private final void beginSetDataSlice(int arrayNum, int dimNum, int index) {
        this.data_.setSlice(arrayNum, dimNum, index);
    }

    private final void finishSetDataSlice() {
        this.data_.fireDataEvent(PanDataEvent.EType.SLICE_CHANGED);
        this.refreshPlot();
    }

    public synchronized void setDataCombination(String value, TaskListener tl) {
        final PanCombinationType ctype = PanCombinationType.matching(value);
        boolean onEDT = EventQueue.isDispatchThread();
        if (this.data_ != null) {
            if (this.pframe_ == null || onEDT) {
                this.beginSetDataCombination(ctype);
                this.finishSetDataCombination();
            } else {
                Task task = new Task("Changing array combination type"){

                    @Override
                    protected Object beginTask() {
                        if (PanPlotMeta.this.data_ == null) {
                            LOGGER.warn("Data var is null; canceling seDataCombination task.");
                            this.cancel(true);
                            return null;
                        }
                        PanPlotMeta.this.beginSetDataCombination(ctype);
                        return null;
                    }

                    @Override
                    protected void finishTask() {
                        if (PanPlotMeta.this.data_ == null) {
                            LOGGER.warn("Data var is null; canceling setDataCombination completion.");
                            return;
                        }
                        PanPlotMeta.this.finishSetDataCombination();
                    }
                };
                if (tl != null) {
                    task.addTaskListener(tl);
                }
                this.pframe_.addTask(task);
            }
        }
        super.set("combination", value);
    }

    private final void beginSetDataCombination(PanCombinationType ctype) {
        this.data_.setCombinationType(ctype);
    }

    private final void finishSetDataCombination() {
        this.data_.fireDataEvent(PanDataEvent.EType.COMBINATION_CHANGED);
        PanCombinationType ctype = this.data_.getCombinationType();
        if (ctype == PanCombinationType.VECTOR) {
            this.validateComboVectorComponents();
        }
        this.refreshPlot();
    }

    private final void validateComboVectorComponents() {
        if (!(this.data_ instanceof PanDataLonLat)) {
            return;
        }
        PanDataLonLat lldata = (PanDataLonLat)this.data_;
        lldata.getUnitsChoices();
        PanVectorType vtype = lldata.getVectorType();
        String dir1 = this.getString("vector.dir1");
        String dir2 = this.getString("vector.dir2");
        if (vtype == PanVectorType.XY) {
            if ("magnitude".equalsIgnoreCase(dir1) || "magnitude".equalsIgnoreCase(dir2)) {
                this.setGroup({"vector.dir1", this.getString("plot:lonlat.vector.dir1")}, {"vector.dir2", this.getString("plot:lonlat.vector.dir2")});
            }
        } else if (!"magnitude".equalsIgnoreCase(dir1) && !"magnitude".equalsIgnoreCase(dir2)) {
            String vdir;
            String string = vdir = lldata.isVectorAngleUpstream() ? "Upstream" : "Downstream";
            if (vtype == PanVectorType.MAG_ANGLE) {
                this.setGroup({"vector.dir1", "Magnitude"}, {"vector.dir2", vdir});
            } else {
                this.setGroup({"vector.dir1", vdir}, {"vector.dir2", "Magnitude"});
            }
        }
    }

    public synchronized void setDataInterpolated(final boolean interpolated, TaskListener tl) {
        boolean onEDT = EventQueue.isDispatchThread();
        if (this.data_ != null) {
            if (this.pframe_ == null || onEDT) {
                this.beginSetDataInterpolated(interpolated);
                this.finishSetDataInterpolated();
            } else {
                Task task = new Task("Toggling interpolation"){

                    @Override
                    protected Object beginTask() {
                        if (PanPlotMeta.this.data_ == null) {
                            LOGGER.warn("Data var is null; canceling setDataInterpolation task.");
                            this.cancel(true);
                            return null;
                        }
                        PanPlotMeta.this.beginSetDataInterpolated(interpolated);
                        return null;
                    }

                    @Override
                    protected void finishTask() {
                        if (PanPlotMeta.this.data_ == null) {
                            LOGGER.warn("Data var is null; canceling setDataInterpolated completion.");
                            return;
                        }
                        PanPlotMeta.this.finishSetDataInterpolated();
                    }
                };
                if (tl != null) {
                    task.addTaskListener(tl);
                }
                this.pframe_.addTask(task);
            }
        }
        super.setBoolean("interpolate", interpolated);
    }

    private final void beginSetDataInterpolated(boolean interpolated) {
        this.data_.setInterpolated(interpolated);
    }

    private final void finishSetDataInterpolated() {
        this.data_.fireDataEvent(PanDataEvent.EType.INTERPOLATION_CHANGED);
        this.refreshPlot();
    }

    public synchronized void setScaleUnits(final String units, TaskListener tl) {
        boolean onEDT = EventQueue.isDispatchThread();
        if (this.data_ != null) {
            if (this.pframe_ == null || onEDT) {
                this.beginSetDataUnits(units);
                this.finishSetDataUnits();
            } else {
                Task task = new Task("Setting units"){

                    @Override
                    protected Object beginTask() {
                        if (PanPlotMeta.this.data_ == null) {
                            LOGGER.warn("Data var is null; canceling setDataUnits task.");
                            this.cancel(true);
                            return null;
                        }
                        PanPlotMeta.this.beginSetDataUnits(units);
                        return null;
                    }

                    @Override
                    protected void finishTask() {
                        if (PanPlotMeta.this.data_ == null) {
                            LOGGER.warn("Data var is null; canceling setDataUnits completion.");
                            return;
                        }
                        PanPlotMeta.this.finishSetDataUnits();
                    }
                };
                if (tl != null) {
                    task.addTaskListener(tl);
                }
                this.pframe_.addTask(task);
            }
        }
        super.setString("scale.units", units);
    }

    private final void beginSetDataUnits(String units) {
        this.data_.setUnits(units);
    }

    private final void finishSetDataUnits() {
        this.data_.fireDataEvent(PanDataEvent.EType.UNITS_CHANGED);
        this.refreshPlot();
    }

    public synchronized void setDataScalingExponent(final int tenPower, TaskListener tl) {
        boolean onEDT = EventQueue.isDispatchThread();
        if (this.data_ != null) {
            if (this.pframe_ == null || onEDT) {
                this.beginSetDataScalingExponent(tenPower);
                this.finishSetDataScalingExponent();
            } else {
                Task task = new Task("Setting scaling"){

                    @Override
                    protected Object beginTask() {
                        if (PanPlotMeta.this.data_ == null) {
                            LOGGER.warn("Data var is null; canceling setDataScalingExponent task.");
                            this.cancel(true);
                            return null;
                        }
                        PanPlotMeta.this.beginSetDataScalingExponent(tenPower);
                        return null;
                    }

                    @Override
                    protected void finishTask() {
                        if (PanPlotMeta.this.data_ == null) {
                            LOGGER.warn("Data var is null; canceling setDataScalingExponent completion.");
                            return;
                        }
                        PanPlotMeta.this.finishSetDataScalingExponent();
                    }
                };
                if (tl != null) {
                    task.addTaskListener(tl);
                }
                this.pframe_.addTask(task);
            }
        }
        super.setInt("scale.exponent", tenPower);
    }

    private final void beginSetDataScalingExponent(int tenPower) {
        this.data_.setScalingExponent(tenPower);
    }

    private final void finishSetDataScalingExponent() {
        this.data_.fireDataEvent(PanDataEvent.EType.SCALING_CHANGED);
        this.refreshPlot();
    }

    private final void refreshControls() {
        if (this.pframe_ == null) {
            return;
        }
        PanControlsTabbedPane ctp = this.pframe_.getControlsTabbedPane();
        if (ctp == null) {
            return;
        }
        EventQueue.invokeLater(() -> {
            ctp.refresh();
            ctp.repaint();
        });
    }

    private final void refreshPlot() {
        if (this.pframe_ == null) {
            return;
        }
        PanPlotHolder ph = this.pframe_.getPlotHolder();
        if (ph == null) {
            return;
        }
        EventQueue.invokeLater(() -> ph.repaint());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        PanActionHash panActionHash = this.actionHash_;
        synchronized (panActionHash) {
            if (this.actionHash_ != null) {
                this.actionHash_.clear();
            }
        }
        this.removePlotPropertyListeners();
    }
}

