/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plot;

import gov.nasa.giss.panoply.data.PanData;
import gov.nasa.giss.panoply.data.PanDataLonLat;
import gov.nasa.giss.panoply.plot.PanPlotLabel;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.text.PrintfFormat;
import java.awt.Graphics2D;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanMinMaxNote
extends PanPlotLabel {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private PanData data_;
    private PrintfFormat formatter_;
    private String formatString_;

    public PanMinMaxNote(PanPlotMeta pmeta, PanData data) {
        super(pmeta, "");
        this.data_ = data;
        this.parameterChangedPrivate("all");
    }

    @Override
    protected synchronized void paintPiece(Graphics2D gx, boolean printing) {
        double mean;
        double min = this.pmeta_.getScaleMeta().getDataMinimum();
        double max = this.pmeta_.getScaleMeta().getDataMaximum();
        StringBuilder sb = new StringBuilder("Data ").append("Min = ").append(this.formatter_.sprintg(min)).append(", ").append("Max = ").append(this.formatter_.sprintg(max));
        if (this.data_ instanceof PanDataLonLat && !Double.isNaN(mean = ((PanDataLonLat)this.data_).getGlobalMeanValue())) {
            sb.append(", ").append("Mean = ").append(this.formatter_.sprintf((Object)mean));
        }
        this.setText(sb.toString());
        super.paintPiece(gx, printing);
    }

    @Override
    protected void parameterChangedSelf(String pname) {
        super.parameterChangedSelf(pname);
        this.parameterChangedPrivate(pname);
    }

    private final void parameterChangedPrivate(String pname) {
        boolean changeAll;
        boolean bl = changeAll = pname == null || "all".equals(pname);
        if (changeAll || pname.contains("scale.minmax.format") || pname.contains("scale.tick.format")) {
            String s = this.pmeta_.getString("scale.minmax.format");
            if (s == null || s.isEmpty() || s.toLowerCase().startsWith("same")) {
                s = this.pmeta_.getString("scale.tick.format");
            }
            if (s == null) {
                LOGGER.debug("Property {} has null value", (Object)"scale.tick.format");
                throw new IllegalArgumentException("Null format string");
            }
            this.formatString_ = s;
            this.formatter_ = new PrintfFormat(this.formatString_);
        }
    }
}

