/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plot;

import gov.nasa.giss.graphics.GraphicUtils;
import gov.nasa.giss.map.LonLatBounds;
import gov.nasa.giss.map.SymbolID;
import gov.nasa.giss.map.proj.AbstractProjection;
import gov.nasa.giss.math.MathUtils;
import gov.nasa.giss.math.PointLL;
import gov.nasa.giss.panoply.data.PanDataLonLatTrajectory;
import gov.nasa.giss.panoply.plot.PanLonLatPlotMap;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.plot.PanScaleMeta;
import gov.nasa.giss.panoply.util.PanCombinationType;
import gov.nasa.giss.panoply.util.PanGraphicUtils;
import gov.nasa.giss.panoply.util.PanParameterKeys;
import gov.nasa.giss.panoply.util.PanStrokeStyle;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanLonLatPlotTrajectory
extends PanLonLatPlotMap {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected Color[] trajColor_ = new Color[2];
    protected BasicStroke[] trajStroke_ = new BasicStroke[2];
    private boolean isCompare_;
    private boolean skipNaNs_;
    private BasicStroke symbolStroke_ = PanGraphicUtils.buttMiterStroke("SOLID", 100, 100);
    protected SymbolID[] symbolID_ = new SymbolID[2];
    protected float[] symbolSize_ = new float[2];
    protected boolean[] symbolFill_ = new boolean[2];

    public PanLonLatPlotTrajectory(PanPlotMeta pmeta) {
        super(pmeta);
        this.data_ = pmeta.getData();
        this.setOpaque(false);
        this.parameterChangedPrivate("all");
    }

    @Override
    protected void paintMap(Graphics2D g2d, boolean printing, AbstractProjection projection, boolean backgroundFill, boolean knockout, boolean borderVis) {
        BufferedImage tempImage = this.beginMap(backgroundFill);
        tempImage = this.paintUnderlay(tempImage);
        tempImage = this.paintSourceImage(tempImage);
        tempImage = this.paintPanMaskOverlays(tempImage);
        tempImage = this.paintNightShading(tempImage);
        LonLatBounds llbounds = new LonLatBounds(this.srcLeft_, this.srcTop_, this.srcRight_, this.srcBottom_);
        projection.setSourceImage(tempImage, llbounds);
        Graphics2D g2dx = (Graphics2D)g2d.create();
        if (printing) {
            projection.drawMapVectorized(g2dx);
        } else {
            projection.paintMap(g2dx);
        }
        this.drawOutlineOverlays(g2dx, projection);
        this.drawTrajectory(g2dx, projection);
        this.drawGridAndBorder(g2dx, projection, borderVis);
        g2dx.dispose();
    }

    private BufferedImage paintSourceImage(BufferedImage tempImage) {
        if (this.underlayEnabled_ && this.mainAlpha1_ == 0) {
            return tempImage;
        }
        int ww = tempImage.getWidth();
        int hh = tempImage.getHeight();
        Color color = this.pmeta_.getColor("feature.background");
        Graphics2D tg2d = tempImage.createGraphics();
        if (this.underlayEnabled_) {
            float alpha = 0.01f * (float)this.mainAlpha1_;
            tg2d.setComposite(AlphaComposite.getInstance(3, alpha));
        }
        tg2d.setColor(color);
        GraphicUtils.fillRect(tg2d, 0.0, 0.0, ww, hh);
        tg2d.dispose();
        return tempImage;
    }

    protected void drawTrajectory(Graphics2D g2d, AbstractProjection proj) {
        if (!(this.data_ instanceof PanDataLonLatTrajectory)) {
            return;
        }
        PanDataLonLatTrajectory trajdata = (PanDataLonLatTrajectory)this.data_;
        trajdata.getMaxValue();
        PanScaleMeta smeta = this.pmeta_.getScaleMeta();
        int istrokes = this.isCompare_ ? 2 : 1;
        for (int ii = 0; ii < istrokes; ++ii) {
            PointLL[] llarray = trajdata.getLonLatArray(ii);
            if (this.trajStroke_ != null && this.trajStroke_[ii] != null) {
                if (this.skipNaNs_) {
                    int istart = -1;
                    int istop = -1;
                    for (int j = 0; j < llarray.length; ++j) {
                        double value = trajdata.valueAt(ii, j);
                        if (Double.isNaN(value)) {
                            this.drawTrajectoryPath(proj, llarray, istart, istop, g2d, this.trajStroke_[ii], this.trajColor_[ii]);
                            istart = -1;
                            istop = -1;
                            continue;
                        }
                        istop = j;
                        if (istart >= 0) continue;
                        istart = j;
                    }
                    this.drawTrajectoryPath(proj, llarray, istart, istop, g2d, this.trajStroke_[ii], this.trajColor_[ii]);
                } else {
                    this.drawTrajectoryPath(proj, llarray, 0, llarray.length - 1, g2d, this.trajStroke_[ii], this.trajColor_[ii]);
                }
            }
            for (int j = 0; j < llarray.length; ++j) {
                double value = trajdata.valueAt(ii, j);
                if (this.skipNaNs_ && Double.isNaN(value)) continue;
                PointLL ll = llarray[j];
                Color ptcolor = new Color(smeta.rgbaForValue(value));
                if (this.symbolFill_[ii]) {
                    proj.markPoint(g2d, ll, this.symbolStroke_, this.symbolID_[ii], this.symbolSize_[ii], ptcolor, ptcolor);
                    continue;
                }
                proj.markPoint(g2d, ll, this.symbolStroke_, this.symbolID_[ii], this.symbolSize_[ii], ptcolor, null);
            }
        }
    }

    private void drawTrajectoryPath(AbstractProjection proj, PointLL[] llarray, int istart, int istop, Graphics2D g2d, BasicStroke stroke, Color color) {
        if (istart < 0 || istop <= istart) {
            return;
        }
        if (istop - istart > 100000) {
            LOGGER.info("Drawing the trajectory path for > 100k points is hopeless: {}, {}", (Object)istart, (Object)istop);
        } else if (istart == 0 && istop == llarray.length - 1) {
            proj.drawPath(g2d, llarray, stroke, color);
        } else {
            PointLL[] subset = Arrays.copyOfRange(llarray, istart, istop);
            proj.drawPath(g2d, subset, stroke, color);
        }
    }

    @Override
    protected void parameterChangedSelf(String pname) {
        super.parameterChangedSelf(pname);
        this.parameterChangedPrivate(pname);
    }

    private final void parameterChangedPrivate(String pname) {
        boolean changeAll = pname == null || "all".equals(pname);
        int sfactor = this.pmeta_.getInt("size.factor");
        float scaling = 0.01f * (float)sfactor;
        float sqscaling = (float)Math.sqrt(scaling);
        if (changeAll || pname.contains("size.factor")) {
            this.symbolStroke_ = PanGraphicUtils.buttMiterStroke("SOLID", 100, sfactor);
        }
        if (changeAll || pname.contains("combination")) {
            String ctype = this.pmeta_.getString("combination");
            this.isCompare_ = PanCombinationType.COMPARE.matches(ctype);
        }
        if (changeAll || pname.contains("feature.nanskip")) {
            this.skipNaNs_ = this.pmeta_.getBoolean("feature.nanskip");
        }
        if (changeAll || pname.contains(PanParameterKeys.STROKE_COLOR[0]) || pname.contains(PanParameterKeys.STROKE_COLOR[1]) || pname.contains(PanParameterKeys.STROKE_STYLE[0]) || pname.contains(PanParameterKeys.STROKE_STYLE[1]) || pname.contains(PanParameterKeys.STROKE_WEIGHT[0]) || pname.contains(PanParameterKeys.STROKE_WEIGHT[1])) {
            for (int i = 0; i < 2; ++i) {
                PanStrokeStyle style = PanStrokeStyle.matching(this.pmeta_.getString(PanParameterKeys.STROKE_STYLE[i]));
                int weight = this.pmeta_.getInt(PanParameterKeys.STROKE_WEIGHT[i]);
                this.trajColor_[i] = this.pmeta_.getColor(PanParameterKeys.STROKE_COLOR[i]);
                this.trajStroke_[i] = style == PanStrokeStyle.NONE || weight == 0 ? null : PanGraphicUtils.roundStroke(style, weight, sfactor);
            }
        }
        if (changeAll || pname.contains(PanParameterKeys.FEATURE_SYMBOL_ID[0]) || pname.contains(PanParameterKeys.FEATURE_SYMBOL_ID[1]) || pname.contains(PanParameterKeys.FEATURE_SYMBOL_SIZE[0]) || pname.contains(PanParameterKeys.FEATURE_SYMBOL_SIZE[1]) || pname.contains(PanParameterKeys.FEATURE_SYMBOL_FILL[0]) || pname.contains(PanParameterKeys.FEATURE_SYMBOL_FILL[1])) {
            this.symbolID_[0] = SymbolID.matching(this.pmeta_.getString(PanParameterKeys.FEATURE_SYMBOL_ID[0]));
            this.symbolID_[1] = SymbolID.matching(this.pmeta_.getString(PanParameterKeys.FEATURE_SYMBOL_ID[1]));
            this.symbolSize_[0] = this.pmeta_.getFloat(PanParameterKeys.FEATURE_SYMBOL_SIZE[0]) * sqscaling;
            this.symbolSize_[1] = this.pmeta_.getFloat(PanParameterKeys.FEATURE_SYMBOL_SIZE[1]) * sqscaling;
            this.symbolSize_[0] = MathUtils.minmax(this.symbolSize_[0], 2.0f, 12.0f);
            this.symbolSize_[1] = MathUtils.minmax(this.symbolSize_[1], 2.0f, 12.0f);
            this.symbolFill_[0] = this.pmeta_.getBoolean(PanParameterKeys.FEATURE_SYMBOL_FILL[0]);
            this.symbolFill_[1] = this.pmeta_.getBoolean(PanParameterKeys.FEATURE_SYMBOL_FILL[1]);
        }
    }
}

