/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.overlay;

import gov.nasa.giss.graphics.filter.MaskFilter;
import gov.nasa.giss.map.overlay.MapOverlay;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.Objects;
import javax.imageio.ImageIO;

public class PanMaskOverlay
extends MapOverlay {
    private static Toolkit toolkit_ = Toolkit.getDefaultToolkit();
    private BufferedImage source_;

    public PanMaskOverlay(File f) throws FileNotFoundException, IOException {
        Objects.requireNonNull(f, "File cannot be null");
        if (!f.exists()) {
            throw new FileNotFoundException("File does not exist.");
        }
        URL url = f.toURI().toURL();
        this.setIdentifier(url.toString());
        this.initFromLocation(url);
    }

    public PanMaskOverlay(URL url) throws IOException {
        this.setIdentifier(url.toString());
        this.initFromLocation(url);
    }

    public PanMaskOverlay(byte[] bytes, String id) {
        this.setIdentifier(id);
        this.source_ = this.image2BufferedImage(toolkit_.createImage(bytes));
    }

    private void initFromLocation(URL url) throws IllegalArgumentException, IOException {
        Objects.requireNonNull(url, "URL is null");
        this.source_ = ImageIO.read(url);
        if (this.source_.getWidth() < 1 || this.source_.getHeight() < 1) {
            throw new IOException("Invalid image file");
        }
    }

    public int getWidth() {
        return this.source_.getWidth();
    }

    public int getHeight() {
        return this.source_.getHeight();
    }

    public BufferedImage getSource() {
        return this.source_;
    }

    public BufferedImage getMask(Color c) {
        return this.getMask(c, false);
    }

    public BufferedImage getMask(Color c, boolean inv) {
        FilteredImageSource ip = new FilteredImageSource(this.source_.getSource(), new MaskFilter(c, inv));
        return this.image2BufferedImage(toolkit_.createImage(ip));
    }

    private BufferedImage image2BufferedImage(Image img) {
        BufferedImage bi = new BufferedImage(img.getWidth(null), img.getHeight(null), 2);
        Graphics g = bi.getGraphics();
        g.drawImage(img, 0, 0, null);
        g.dispose();
        return bi;
    }
}

