/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.menu;

import gov.nasa.giss.panoply.action.PanCloseWindowAction;
import gov.nasa.giss.panoply.action.PanExportCLScriptAction;
import gov.nasa.giss.panoply.action.PanOpenLocalFileAction;
import gov.nasa.giss.panoply.action.PanOpenRemoteCatalogAction;
import gov.nasa.giss.panoply.action.PanOpenRemoteDatasetAction;
import gov.nasa.giss.panoply.action.PanSaveImageAction;
import gov.nasa.giss.panoply.action.PanSaveImageAsAction;
import gov.nasa.giss.panoply.macos.PanHiddenMacFrame;
import gov.nasa.giss.panoply.menu.PanExportMenu;
import gov.nasa.giss.panoply.menu.PanMenu;
import gov.nasa.giss.panoply.plotui.PanPlotFrame;
import gov.nasa.giss.panoply.ui.PanDisplayFrame;
import gov.nasa.giss.panoply.ui.PanFrame;
import gov.nasa.giss.panoply.util.PanQuitHandler;
import gov.nasa.giss.ui.menu.GissMenuItem;
import gov.nasa.giss.util.GissPrintAction;
import gov.nasa.giss.util.PlatformUtils;
import java.awt.event.ActionEvent;
import java.awt.print.Printable;
import javax.swing.AbstractAction;

public class PanFileMenu
extends PanMenu {
    public PanFileMenu(PanFrame parent) {
        super(parent, "file-menu");
        boolean isMacOS = PlatformUtils.isMacintosh();
        boolean parentIsPlot = parent instanceof PanPlotFrame;
        this.add(this.makeItemFromProperties("new", null)).setEnabled(false);
        AbstractAction a = new PanOpenLocalFileAction(parent);
        GissMenuItem jmi = this.makeItemFromProperties("open-local", a);
        this.add(jmi).setEnabled(true);
        a = new PanOpenRemoteDatasetAction(parent);
        jmi = this.makeItemFromProperties("open-remote-data", a);
        this.add(jmi).setEnabled(true);
        a = new PanOpenRemoteCatalogAction(parent);
        jmi = this.makeItemFromProperties("open-remote-catalog", a);
        this.add(jmi).setEnabled(true);
        if (isMacOS) {
            this.addSeparator();
        }
        a = isMacOS && parent instanceof PanHiddenMacFrame ? null : new PanCloseWindowAction(parent);
        jmi = this.makeItemFromProperties("close", a);
        this.add(jmi).setEnabled(a != null);
        if (!isMacOS) {
            this.addSeparator();
        }
        PanSaveImageAction a1 = null;
        PanSaveImageAsAction a2 = null;
        if (parent instanceof PanDisplayFrame) {
            a2 = new PanSaveImageAsAction((PanDisplayFrame)parent);
            a1 = new PanSaveImageAction((PanDisplayFrame)parent, a2);
        }
        GissMenuItem jmi1 = this.makeItemFromProperties("save-image", a1);
        GissMenuItem jmi2 = this.makeItemFromProperties("save-image-as", a2);
        this.add(jmi1).setEnabled(a1 != null);
        this.add(jmi2).setEnabled(a2 != null);
        this.addSeparator();
        a = parentIsPlot ? new PanExportCLScriptAction((PanPlotFrame)parent) : null;
        jmi = this.makeItemFromProperties("export-cl-script", a);
        this.add(jmi).setEnabled(a != null);
        this.add(new PanExportMenu(parent));
        GissMenuItem jmi3 = this.makeItemFromProperties("export-kmz", null);
        this.add(jmi3).setEnabled(false);
        jmi3 = this.makeItemFromProperties("export-animation", null);
        this.add(jmi3).setEnabled(false);
        this.addSeparator();
        a = parent instanceof Printable ? new GissPrintAction((Printable)((Object)parent)) : null;
        jmi = this.makeItemFromProperties("print", a);
        this.add(jmi).setEnabled(a != null);
        if (!PlatformUtils.isMacintosh()) {
            this.addSeparator();
            a = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PanQuitHandler.quit();
                }
            };
            jmi = this.makeItemFromProperties("quit", a);
            this.add(jmi).setEnabled(true);
        }
    }
}

