/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.macos;

import gov.nasa.giss.panoply.macos.PanHiddenMacFrame;
import gov.nasa.giss.panoply.sources.PanSourcesFrame;
import gov.nasa.giss.util.PlatformUtils;
import java.awt.Desktop;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PanMacApplication {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static boolean success_;

    public static boolean initiate() {
        PanMacApplication instance = Singleton.INSTANCE;
        return success_;
    }

    private PanMacApplication() {
        if (!PlatformUtils.isMacintosh()) {
            throw new RuntimeException("Cannot create macOS object on this platform.");
        }
        this.initProperties();
        PanSourcesFrame.getSharedInstance();
        boolean bl = success_ = PlatformUtils.isOldMacintoshAPI() ? this.initJava8Adapter() : this.initJava9Adapter();
        if (!success_) {
            LOGGER.error("Failed creating appropriate desktop adapter.");
        }
        PanHiddenMacFrame.getSharedInstance().reveal();
    }

    private final void initProperties() {
        block2: {
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", "Panoply");
            System.setProperty("apple.awt.showGrowBox", "true");
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            System.setProperty("apple.awt.antialiasing", "true");
            System.setProperty("apple.awt.textantialiasing", "true");
            System.setProperty("apple.awt.rendering", "VALUE_RENDER_QUALITY");
            System.setProperty("apple.awt.fractionalmetrics", "VALUE_FRACTIONALMETRICS_ON");
            try {
                System.setProperty("apple.awt.graphics.UseQuartz", "true");
            }
            catch (Exception exc) {
                if (!LOGGER.isTraceEnabled()) break block2;
                exc.printStackTrace();
            }
        }
    }

    private final boolean initJava8Adapter() {
        block5: {
            try {
                Class<?> appClass = Class.forName("com.apple.eawt.Application");
                Object application = appClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                Class<?> pmaClass = Class.forName("gov.nasa.giss.panoply.desktop.PanMacDesktopAdapter");
                Object adapter = pmaClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                appClass.getMethod("setAboutHandler", Class.forName("com.apple.eawt.AboutHandler")).invoke(application, adapter);
                appClass.getMethod("setOpenFileHandler", Class.forName("com.apple.eawt.OpenFilesHandler")).invoke(application, adapter);
                appClass.getMethod("setPreferencesHandler", Class.forName("com.apple.eawt.PreferencesHandler")).invoke(application, adapter);
                appClass.getMethod("setQuitHandler", Class.forName("com.apple.eawt.QuitHandler")).invoke(application, adapter);
                return true;
            }
            catch (IllegalAccessException exc) {
                LOGGER.warn("Could not load macOS Java adapters: IllegalAccessException.");
            }
            catch (NoClassDefFoundError err) {
                LOGGER.warn("Could not load macOS Java adapters: NoClassDefFoundError.");
            }
            catch (ClassNotFoundException cnfe) {
                LOGGER.warn("Could not load macOS Java adapters: ClassNotFoundException.");
            }
            catch (Exception exc) {
                LOGGER.warn("Could not load macOS Java adapters.");
                if (!LOGGER.isTraceEnabled()) break block5;
                exc.printStackTrace();
            }
        }
        return false;
    }

    private final boolean initJava9Adapter() {
        block6: {
            try {
                Class<?> appClass = Class.forName("java.awt.Desktop");
                Method method = appClass.getMethod("getDesktop", new Class[0]);
                Desktop desktop = (Desktop)method.invoke(null, new Object[0]);
                Class<?> pmaClass = Class.forName("gov.nasa.giss.panoply.desktop.PanJ9DesktopAdapter");
                Object adapter = pmaClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                appClass.getMethod("setAboutHandler", Class.forName("java.awt.desktop.AboutHandler")).invoke((Object)desktop, adapter);
                appClass.getMethod("setOpenFileHandler", Class.forName("java.awt.desktop.OpenFilesHandler")).invoke((Object)desktop, adapter);
                appClass.getMethod("setPreferencesHandler", Class.forName("java.awt.desktop.PreferencesHandler")).invoke((Object)desktop, adapter);
                appClass.getMethod("setQuitHandler", Class.forName("java.awt.desktop.QuitHandler")).invoke((Object)desktop, adapter);
                return true;
            }
            catch (IllegalAccessException exc) {
                LOGGER.warn("Could not load Java 9 Desktop adapters: IllegalAccessException.");
                if (LOGGER.isTraceEnabled()) {
                    exc.printStackTrace();
                }
            }
            catch (NoClassDefFoundError err) {
                LOGGER.warn("Could not load Java 9 Desktop adapters: NoClassDefFoundError.");
            }
            catch (ClassNotFoundException cnfe) {
                LOGGER.warn("Could not load Java 9 Desktop adapters: ClassNotFoundException.");
            }
            catch (Exception exc) {
                LOGGER.warn("Could not load Java 9 Desktop adapters.");
                if (!LOGGER.isTraceEnabled()) break block6;
                exc.printStackTrace();
            }
        }
        return false;
    }

    private static class Singleton {
        private static final PanMacApplication INSTANCE = new PanMacApplication();

        private Singleton() {
        }
    }
}

