/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.io;

import gov.nasa.giss.map.LonLatBounds;
import gov.nasa.giss.panoply.plot.PanLonLatPlot;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.plot.PanScaleColorbar;
import gov.nasa.giss.panoply.util.PanKmlOption;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PanKmzUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public static void save(File f, PanLonLatPlot llplot, Hashtable<PanKmlOption, Object> options) throws IOException {
        String fname = f.getName();
        String lcname = fname.toLowerCase();
        boolean knockout = false;
        boolean borderVis = false;
        boolean includeScale = false;
        if (options.containsKey((Object)PanKmlOption.KNOCKOUT)) {
            knockout = (Boolean)options.get((Object)PanKmlOption.KNOCKOUT);
        }
        if (options.containsKey((Object)PanKmlOption.BORDER)) {
            borderVis = (Boolean)options.get((Object)PanKmlOption.BORDER);
        }
        if (options.containsKey((Object)PanKmlOption.COLORBAR)) {
            includeScale = (Boolean)options.get((Object)PanKmlOption.COLORBAR);
        }
        String fnameRoot = lcname.endsWith(".kmz") ? fname.substring(0, fname.length() - 4) : fname;
        fnameRoot = fnameRoot.replaceAll("\\s", "_");
        LOGGER.trace("create ZipOutputStream");
        ZipOutputStream out = new ZipOutputStream(new FileOutputStream(f));
        LOGGER.trace("writeKml");
        PanKmzUtils.writeKml(fnameRoot, out, llplot, includeScale);
        LOGGER.trace("writeMap");
        PanKmzUtils.writeMap(fnameRoot, out, llplot, knockout, borderVis);
        if (includeScale) {
            LOGGER.trace("writeColorbar");
            PanKmzUtils.writeColorbar(fnameRoot, out, llplot);
        }
        LOGGER.trace("close ZipOutputStream");
        out.close();
    }

    private static void writeKml(String fnameRoot, ZipOutputStream zipstream, PanLonLatPlot llplot, boolean includeScale) throws IOException {
        PanPlotMeta pmeta = llplot.getMeta();
        String ttext = pmeta.getString("title.text");
        String stext = pmeta.getString("subtitle.text");
        LonLatBounds edges = llplot.getLonLatBounds();
        ArrayList<String> kmlStrs = new ArrayList<String>();
        kmlStrs.add("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        kmlStrs.add("<kml xmlns=\"http://www.opengis.net/kml/2.2\">\n");
        kmlStrs.add("<Folder>\n");
        kmlStrs.add("<open>1</open>\n");
        kmlStrs.add("<GroundOverlay>\n");
        if (ttext == null || ttext.isEmpty()) {
            kmlStrs.add("<name>" + fnameRoot + "</name>\n");
        } else {
            kmlStrs.add("<name>" + ttext + "</name>\n");
        }
        kmlStrs.add("<Icon>");
        kmlStrs.add("<href>" + fnameRoot + ".png</href>");
        kmlStrs.add("</Icon>\n");
        kmlStrs.add("<LatLonBox>\n");
        kmlStrs.add("<west>" + edges.getWest() + "</west>\n");
        kmlStrs.add("<north>" + edges.getNorth() + "</north>\n");
        kmlStrs.add("<east>" + edges.getEast() + "</east>\n");
        kmlStrs.add("<south>" + edges.getSouth() + "</south>\n");
        kmlStrs.add("</LatLonBox>\n");
        if (stext != null && !stext.isEmpty()) {
            kmlStrs.add("<description>\n");
            kmlStrs.add("<![CDATA[\n");
            kmlStrs.add(stext);
            kmlStrs.add("]]>\n");
            kmlStrs.add("</description>\n");
        }
        kmlStrs.add("</GroundOverlay>\n");
        if (includeScale) {
            kmlStrs.add("<ScreenOverlay>\n");
            kmlStrs.add("<name>Scale</name>\n");
            kmlStrs.add("<Icon>");
            kmlStrs.add("<href>" + fnameRoot + "_cbar.png</href>");
            kmlStrs.add("</Icon>\n");
            kmlStrs.add("<overlayXY x=\"0.5\" y=\"0\" xunits=\"fraction\" yunits=\"fraction\" />\n");
            kmlStrs.add("<screenXY x=\"0.5\" y=\"0\" xunits=\"fraction\" yunits=\"fraction\" />\n");
            kmlStrs.add("<size x=\"-1\" y=\"-1\" xunits=\"fraction\" yunits=\"fraction\" />\n");
            kmlStrs.add("</ScreenOverlay>\n");
        }
        kmlStrs.add("</Folder>\n");
        kmlStrs.add("</kml>\n");
        zipstream.putNextEntry(new ZipEntry(fnameRoot + ".kml"));
        for (String s : kmlStrs) {
            byte[] bytes = s.getBytes("UTF-8");
            zipstream.write(bytes, 0, bytes.length);
        }
        zipstream.closeEntry();
    }

    private static void writeMap(String fnameRoot, ZipOutputStream zipstream, PanLonLatPlot llplot, boolean knockout, boolean borderVis) throws IOException {
        zipstream.putNextEntry(new ZipEntry(fnameRoot + ".png"));
        ByteArrayOutputStream bstream = new ByteArrayOutputStream();
        BufferedImage img = llplot.drawKmlIconImage(knockout, borderVis);
        ImageIO.write((RenderedImage)img, "png", bstream);
        byte[] bytes = bstream.toByteArray();
        zipstream.write(bytes, 0, bytes.length);
        zipstream.closeEntry();
    }

    private static void writeColorbar(String fnameRoot, ZipOutputStream zipstream, PanLonLatPlot llplot) throws IOException {
        PanScaleColorbar cb = llplot.getColorbar();
        if (cb == null) {
            LOGGER.warn("Colorbar is null.");
            return;
        }
        Color oldbg = cb.getBackground();
        boolean oldOpaque = cb.isOpaque();
        if (oldbg.equals(Color.WHITE)) {
            cb.setOpaque(true);
        }
        BufferedImage img = cb.getImage();
        cb.setOpaque(oldOpaque);
        zipstream.putNextEntry(new ZipEntry(fnameRoot + "_cbar.png"));
        ByteArrayOutputStream bstream = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)img, "png", bstream);
        byte[] bytes = bstream.toByteArray();
        zipstream.write(bytes, 0, bytes.length);
        zipstream.closeEntry();
    }

    private PanKmzUtils() {
    }
}

