/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.data;

import gov.nasa.giss.data.Data;
import gov.nasa.giss.data.nc.NcArray;
import gov.nasa.giss.data.nc.NcUnitUtils;
import gov.nasa.giss.panoply.data.PanDataEvent;
import gov.nasa.giss.panoply.data.PanDataListener;
import gov.nasa.giss.panoply.prefs.PanPreferences;
import gov.nasa.giss.panoply.util.PanCombinationType;
import gov.nasa.giss.panoply.util.PanConstants;
import gov.nasa.giss.text.PrintfFormat;
import java.awt.EventQueue;
import java.lang.invoke.MethodHandles;
import java.net.URL;
import java.util.ArrayList;
import java.util.Objects;
import javax.swing.event.EventListenerList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.units.ConversionException;
import ucar.units.Converter;
import ucar.units.DerivedUnit;
import ucar.units.Unit;

public abstract class PanData
implements Data {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected static final double MIN_FOR_LOG_AXIS = 1.0E-50;
    private final Object lock_ = new Object();
    protected PanCombinationType combination_ = PanCombinationType.A1_ONLY;
    protected NcArray[] ncArrays_ = new NcArray[2];
    protected Unit[] ncaUcarUnits_ = new Unit[2];
    protected Converter[] ncaUnitConverters_ = new Converter[2];
    protected String targetUnitsString_;
    protected Unit targetUcarUnit_;
    protected Converter targetConverter_;
    protected PrintfFormat scaleFormatter_;
    protected boolean interpolated_;
    protected boolean needsGridding_ = true;
    protected boolean gridding_;
    protected boolean needsExtrema_ = true;
    protected double dataMin_;
    protected double dataMax_;
    protected int scalingExponent_;
    protected double scalingFactor_ = 1.0;
    protected double[][] outputVals_ = new double[2][];
    protected static Unit scalarUnit_;
    private static Unit kelvinUnit_;
    private static Unit meterUnit_;
    private static Unit pascalUnit_;
    private static Unit speedUnit_;
    private static Unit angleUnit_;
    private final EventListenerList listenerList_ = new EventListenerList();

    protected PanData(NcArray nca) {
        if (!this.validateArrayType(nca)) {
            throw new IllegalArgumentException("Wrong type of NcArray.");
        }
        PanPreferences prefs = PanPreferences.getSharedInstance();
        this.setArray(0, nca);
        this.setUnits(nca.getUnitsString());
        this.setInterpolated(prefs.getBoolean("plot:interpolate"));
        this.setScaleFormat(prefs.getString("plot:scale.tick.format"));
    }

    protected abstract boolean validateArrayType(NcArray var1);

    public String[] getArraySource(int index) {
        if (this.ncArrays_[index] == null) {
            return null;
        }
        URL url = this.ncArrays_[index].getDataset().getURL();
        String daddress = url.toString();
        if (url.getProtocol().equals("file")) {
            try {
                daddress = url.toURI().getPath();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        String vname = this.ncArrays_[index].getFullName();
        return new String[]{daddress, vname};
    }

    public NcArray[] getArrays() {
        return this.ncArrays_;
    }

    public NcArray getArray(int idx) {
        if (idx < 0 || idx > 1) {
            throw new IndexOutOfBoundsException();
        }
        return this.ncArrays_[idx];
    }

    public final void setScaleFormat(String fmt) {
        Objects.requireNonNull(fmt, "Format string cannot be null.");
        this.scaleFormatter_ = new PrintfFormat(fmt);
    }

    protected void setBoundsChanged() {
        this.needsGridding_ = true;
        this.fireDataEvent(PanDataEvent.EType.BOUNDS_CHANGED);
    }

    public synchronized void setArray(int idx, NcArray nca) {
        if (idx < 0 || idx > 1) {
            throw new IndexOutOfBoundsException();
        }
        this.ncArrays_[idx] = nca;
        this.needsGridding_ = true;
        this.needsExtrema_ = true;
        this.ncaUcarUnits_[idx] = scalarUnit_;
        Unit uu = nca.getUcarUnits();
        if (uu != null) {
            this.ncaUcarUnits_[idx] = uu;
        }
        this.findExtrema();
        this.fireDataEvent(PanDataEvent.EType.VARIABLE_CHANGED);
    }

    public int getSlice(int arrayNum, int dimNum) {
        return this.ncArrays_[arrayNum].getSliceIndex(dimNum);
    }

    public void setSlice(int arrayNum, int dimNum, int index) {
        this.ncArrays_[arrayNum].setSliceIndex(dimNum, index);
        this.needsGridding_ = true;
        this.needsExtrema_ = true;
        this.findExtrema();
    }

    public PanCombinationType getCombinationType() {
        return this.combination_;
    }

    public void setCombinationType(PanCombinationType newtype) {
        if (this.combination_ == newtype) {
            return;
        }
        this.combination_ = newtype;
        this.updateUnitConverters();
        this.needsGridding_ = true;
        this.needsExtrema_ = true;
        this.findExtrema();
    }

    public boolean isInterpolated() {
        return this.interpolated_;
    }

    public void setInterpolated(boolean newval) {
        if (newval == this.interpolated_) {
            return;
        }
        this.interpolated_ = newval;
        this.needsGridding_ = true;
        this.needsExtrema_ = true;
        this.findExtrema();
    }

    public int getScalingExponent() {
        return this.scalingExponent_;
    }

    public void setScalingExponent(int newval) {
        if (newval == this.scalingExponent_) {
            return;
        }
        if (newval < -50 || newval > 50) {
            throw new IllegalArgumentException("Scaling exponent must be in range [-50,50].");
        }
        this.scalingExponent_ = newval;
        this.scalingFactor_ = Math.pow(10.0, this.scalingExponent_);
        this.needsExtrema_ = true;
        this.findExtrema();
    }

    @Override
    public String getUnits() {
        return this.targetUnitsString_;
    }

    @Override
    public final void setUnits(String uStr) {
        String s = uStr;
        if (s == null || s.isEmpty() || s.equals("<scalar>")) {
            s = "1";
        }
        if (s.charAt(0) == '[') {
            this.targetUnitsString_ = null;
            this.targetUcarUnit_ = null;
        } else {
            try {
                this.targetUnitsString_ = s;
                this.targetUcarUnit_ = NcUnitUtils.parse(this.targetUnitsString_);
            }
            catch (Exception exc) {
                this.targetUnitsString_ = null;
                this.targetUcarUnit_ = null;
            }
        }
        this.updateUnitConverters();
        this.needsGridding_ = true;
        this.needsExtrema_ = true;
        this.findExtrema();
    }

    public String[] getUnitsChoices() {
        ArrayList<String> choices = new ArrayList<String>();
        Unit baseUnit = null;
        switch (this.combination_) {
            case A1_ONLY: 
            case A2_ONLY: {
                int idx = this.combination_ == PanCombinationType.A1_ONLY ? 0 : 1;
                String ustr = this.ncArrays_[idx].getUnitsString();
                if (ustr != null) {
                    this.addToUnitsChoices(choices, ustr);
                }
                if (this.ncaUcarUnits_[idx] == null) break;
                baseUnit = this.ncaUcarUnits_[idx];
                this.addToUnitsChoices(choices, this.ncaUcarUnits_[idx]);
                break;
            }
            case A1_PLUS_A2: 
            case A1_MINUS_A2: 
            case A2_MINUS_A1: 
            case AVERAGE: 
            case MERGE: 
            case COMPARE: {
                if (this.ncaUcarUnits_[0] == null || this.ncaUcarUnits_[1] == null) {
                    return new String[]{"[null/unrecognized unit]"};
                }
                if (!this.ncArrays_[0].isCompatibleUnits(this.ncArrays_[1])) {
                    return new String[]{"[incompatible units?]"};
                }
                baseUnit = this.ncaUcarUnits_[0];
                for (int i = 0; i < 2; ++i) {
                    String ustr = this.ncArrays_[i].getUnitsString();
                    if (ustr != null) {
                        this.addToUnitsChoices(choices, ustr);
                    }
                    this.addToUnitsChoices(choices, this.ncaUcarUnits_[i]);
                }
                break;
            }
            case VECTOR: {
                throw new RuntimeException("Got VECTOR type");
            }
            case A1_MINUS_A2_PCT: 
            case A2_MINUS_A1_PCT: {
                if (this.ncaUcarUnits_[0] == null || this.ncaUcarUnits_[1] == null) {
                    return new String[]{"[null/unrecognized unit]"};
                }
                if (this.ncArrays_[0].isCompatibleUnits(this.ncArrays_[1])) break;
                return new String[]{"[incompatible units?]"};
            }
            case A1_TIMES_A2: 
            case A1_OVER_A2: 
            case A2_OVER_A1: {
                if (this.ncaUcarUnits_[0] == null && this.ncaUcarUnits_[1] == null) {
                    return new String[]{"[null/unrecognized unit]"};
                }
                try {
                    Unit xx = null;
                    xx = this.combination_ == PanCombinationType.A1_TIMES_A2 ? this.ncaUcarUnits_[0].multiplyBy(this.ncaUcarUnits_[1]) : (this.combination_ == PanCombinationType.A1_OVER_A2 ? this.ncaUcarUnits_[0].divideBy(this.ncaUcarUnits_[1]) : this.ncaUcarUnits_[1].divideBy(this.ncaUcarUnits_[0]));
                    baseUnit = xx;
                    this.addToUnitsChoices(choices, xx);
                }
                catch (Exception exception) {}
                break;
            }
        }
        this.addCompatibleToUnitsChoices(choices, baseUnit);
        if (choices.isEmpty()) {
            return new String[]{"<scalar>"};
        }
        return choices.toArray(new String[0]);
    }

    protected void addCompatibleToUnitsChoices(ArrayList<String> choices, Unit baseUnit) {
        if (baseUnit == null) {
            return;
        }
        String[] compatible = null;
        if (baseUnit.isCompatible(kelvinUnit_)) {
            compatible = PanConstants.TEMPERATURE_UNITS;
        } else if (baseUnit.isCompatible(meterUnit_)) {
            compatible = PanConstants.DISTANCE_UNITS;
        } else if (baseUnit.isCompatible(pascalUnit_)) {
            compatible = PanConstants.PRESSURE_UNITS;
        } else if (baseUnit.isCompatible(speedUnit_)) {
            compatible = PanConstants.SPEED_UNITS;
        } else if (baseUnit.isCompatible(angleUnit_)) {
            compatible = PanConstants.ANGLE_UNITS;
        }
        if (compatible != null) {
            for (String ss : compatible) {
                this.addToUnitsChoices(choices, ss);
            }
        }
    }

    protected void addToUnitsChoices(ArrayList<String> choices, Unit uu) {
        if (uu == null) {
            return;
        }
        this.addToUnitsChoices(choices, uu.toString());
        this.addToUnitsChoices(choices, uu.getSymbol());
        DerivedUnit dunit = uu.getDerivedUnit();
        if (dunit != null) {
            this.addToUnitsChoices(choices, dunit.toString());
            this.addToUnitsChoices(choices, dunit.getSymbol());
        }
    }

    protected void addToUnitsChoices(ArrayList<String> choices, String s) {
        if (s == null || s.isEmpty()) {
            return;
        }
        if (s.equals("1")) {
            this.addToUnitsChoices(choices, "<scalar>");
        }
        for (String choice : choices) {
            if (!s.equals(choice)) continue;
            return;
        }
        choices.add(s);
    }

    protected void updateUnitConverters() {
        this.ncaUnitConverters_[0] = null;
        this.ncaUnitConverters_[1] = null;
        this.targetConverter_ = null;
        if (this.targetUcarUnit_ == null) {
            return;
        }
        switch (this.combination_) {
            case A1_ONLY: 
            case A2_ONLY: {
                int idx;
                int n = idx = this.combination_ == PanCombinationType.A1_ONLY ? 0 : 1;
                if (this.ncaUcarUnits_[idx] != null) {
                    try {
                        this.ncaUnitConverters_[idx] = this.ncaUcarUnits_[idx].getConverterTo(this.targetUcarUnit_);
                    }
                    catch (ConversionException exc) {
                        LOGGER.warn("Units conversion exception (A): {} -> {}", (Object)this.ncaUcarUnits_[idx], (Object)this.targetUcarUnit_);
                    }
                }
                if (this.ncaUnitConverters_[idx] != null) break;
                this.targetUnitsString_ = null;
                this.targetUcarUnit_ = null;
                break;
            }
            case A1_PLUS_A2: 
            case A1_MINUS_A2: 
            case A2_MINUS_A1: 
            case AVERAGE: 
            case MERGE: 
            case COMPARE: {
                for (int i = 0; i < 2; ++i) {
                    if (this.ncaUcarUnits_[i] == null) continue;
                    try {
                        this.ncaUnitConverters_[i] = this.ncaUcarUnits_[i].getConverterTo(this.targetUcarUnit_);
                        continue;
                    }
                    catch (ConversionException exc) {
                        LOGGER.warn("Units conversion exception (B), {}: {} -> {}", i, this.ncaUcarUnits_[i], this.targetUcarUnit_);
                        this.ncaUnitConverters_[0] = null;
                        this.ncaUnitConverters_[1] = null;
                        break;
                    }
                }
                if (this.ncaUnitConverters_[0] == null) {
                    this.targetUnitsString_ = null;
                    this.targetUcarUnit_ = null;
                }
                this.targetConverter_ = null;
                break;
            }
            case VECTOR: {
                throw new RuntimeException("Got VECTOR type");
            }
            case A1_MINUS_A2_PCT: 
            case A2_MINUS_A1_PCT: {
                try {
                    Converter c = this.ncaUcarUnits_[1].getConverterTo(this.ncaUcarUnits_[0]);
                    this.ncaUnitConverters_[0] = null;
                    this.ncaUnitConverters_[1] = c;
                }
                catch (ConversionException exc) {
                    LOGGER.warn("Units conversion exception A2_MINUS_A1_PCT");
                    this.ncaUnitConverters_[0] = null;
                    this.ncaUnitConverters_[1] = null;
                    break;
                }
                this.makeTargetConverter(scalarUnit_);
                break;
            }
            case A1_TIMES_A2: {
                Unit finalSrcUnit = null;
                if (this.ncaUcarUnits_[0] == null && this.ncaUcarUnits_[1] == null) {
                    finalSrcUnit = null;
                } else if (this.ncaUcarUnits_[0] == null) {
                    finalSrcUnit = this.ncaUcarUnits_[1];
                } else if (this.ncaUcarUnits_[1] == null) {
                    finalSrcUnit = this.ncaUcarUnits_[0];
                } else {
                    try {
                        finalSrcUnit = this.ncaUcarUnits_[0].multiplyBy(this.ncaUcarUnits_[1]);
                    }
                    catch (Exception exc) {
                        finalSrcUnit = null;
                    }
                }
                this.makeTargetConverter(finalSrcUnit);
                break;
            }
            case A1_OVER_A2: {
                Unit finalSrcUnit = null;
                if (this.ncaUcarUnits_[0] == null && this.ncaUcarUnits_[1] == null) {
                    finalSrcUnit = null;
                } else if (this.ncaUcarUnits_[0] == null) {
                    try {
                        finalSrcUnit = this.ncaUcarUnits_[1].raiseTo(-1);
                    }
                    catch (Exception exc) {
                        LOGGER.warn("Units conversion exception A1_OVER_A2 - A");
                        finalSrcUnit = null;
                    }
                } else if (this.ncaUcarUnits_[1] == null) {
                    finalSrcUnit = this.ncaUcarUnits_[0];
                } else {
                    try {
                        finalSrcUnit = this.ncaUcarUnits_[0].divideBy(this.ncaUcarUnits_[1]);
                    }
                    catch (Exception exc) {
                        LOGGER.warn("Units conversion exception A1_OVER_A2 - B");
                        finalSrcUnit = null;
                    }
                }
                this.makeTargetConverter(finalSrcUnit);
                break;
            }
            case A2_OVER_A1: {
                Unit finalSrcUnit = null;
                if (this.ncaUcarUnits_[0] == null && this.ncaUcarUnits_[1] == null) {
                    finalSrcUnit = null;
                } else if (this.ncaUcarUnits_[0] == null) {
                    finalSrcUnit = this.ncaUcarUnits_[1];
                } else if (this.ncaUcarUnits_[1] == null) {
                    try {
                        finalSrcUnit = this.ncaUcarUnits_[0].raiseTo(-1);
                    }
                    catch (Exception exc) {
                        finalSrcUnit = null;
                    }
                } else {
                    try {
                        finalSrcUnit = this.ncaUcarUnits_[1].divideBy(this.ncaUcarUnits_[0]);
                    }
                    catch (Exception exc) {
                        LOGGER.warn("Units conversion exception A2_OVER_A1");
                        finalSrcUnit = null;
                    }
                }
                this.makeTargetConverter(finalSrcUnit);
                break;
            }
        }
    }

    private final void makeTargetConverter(Unit unit) {
        this.targetConverter_ = null;
        if (unit != null) {
            try {
                this.targetConverter_ = unit.getConverterTo(this.targetUcarUnit_);
            }
            catch (ConversionException ignore) {
                LOGGER.warn("Could not create converter from {} to {}", (Object)unit, (Object)this.targetUcarUnit_);
            }
        }
        if (this.targetConverter_ == null) {
            this.targetUnitsString_ = null;
            this.targetUcarUnit_ = null;
        }
    }

    protected abstract void regrid();

    protected abstract void prepareGrid();

    protected void fillArrayNaN(double[] array) {
        int isize = array.length;
        for (int i = 0; i < isize; ++i) {
            array[i] = Double.NaN;
        }
    }

    @Override
    public double getMinValue() {
        if (this.needsExtrema_) {
            this.findExtrema();
        }
        return this.dataMin_;
    }

    @Override
    public double getMaxValue() {
        if (this.needsExtrema_) {
            this.findExtrema();
        }
        return this.dataMax_;
    }

    private final synchronized void findExtrema() {
        if (!this.needsExtrema_) {
            return;
        }
        this.dataMin_ = Double.NaN;
        this.dataMax_ = Double.NaN;
        if (this.combination_ == PanCombinationType.A1_ONLY) {
            this.dataMin_ = this.ncArrays_[0].minimumValue();
            this.dataMax_ = this.ncArrays_[0].maximumValue();
            if (this.ncaUnitConverters_[0] != null) {
                this.dataMin_ = this.ncaUnitConverters_[0].convert(this.dataMin_);
                this.dataMax_ = this.ncaUnitConverters_[0].convert(this.dataMax_);
            }
        } else if (this.combination_ == PanCombinationType.A2_ONLY) {
            this.dataMin_ = this.ncArrays_[1].minimumValue();
            this.dataMax_ = this.ncArrays_[1].maximumValue();
            if (this.ncaUnitConverters_[1] != null) {
                this.dataMin_ = this.ncaUnitConverters_[1].convert(this.dataMin_);
                this.dataMax_ = this.ncaUnitConverters_[1].convert(this.dataMax_);
            }
        } else {
            if (this.needsGridding_) {
                this.regrid();
            }
            boolean onefound = false;
            for (double dval : this.outputVals_[0]) {
                if (Double.isNaN(dval) || Double.isInfinite(dval)) continue;
                if (onefound) {
                    if (dval < this.dataMin_) {
                        this.dataMin_ = dval;
                        continue;
                    }
                    if (!(dval > this.dataMax_)) continue;
                    this.dataMax_ = dval;
                    continue;
                }
                this.dataMin_ = dval;
                this.dataMax_ = dval;
                onefound = true;
            }
            if (this.combination_ == PanCombinationType.COMPARE) {
                for (double dval : this.outputVals_[1]) {
                    if (Double.isNaN(dval) || Double.isInfinite(dval)) continue;
                    if (onefound) {
                        if (dval < this.dataMin_) {
                            this.dataMin_ = dval;
                            continue;
                        }
                        if (!(dval > this.dataMax_)) continue;
                        this.dataMax_ = dval;
                        continue;
                    }
                    this.dataMin_ = dval;
                    this.dataMax_ = dval;
                    onefound = true;
                }
            }
        }
        if (this.scalingExponent_ != 0) {
            this.dataMin_ /= this.scalingFactor_;
            this.dataMax_ /= this.scalingFactor_;
        }
        if (this.dataMax_ <= this.dataMin_) {
            this.dataMax_ = this.dataMin_ + 1.0E-25;
        }
        this.needsExtrema_ = false;
    }

    public String getVarShortName(int idx) {
        if (this.ncArrays_[idx] == null) {
            return null;
        }
        return this.ncArrays_[idx].getShortName();
    }

    public String getVarLongName(int idx) {
        if (this.ncArrays_[idx] == null) {
            return null;
        }
        String lname = this.ncArrays_[idx].getLongName();
        if (lname != null) {
            return lname;
        }
        return this.ncArrays_[idx].getShortName();
    }

    public String getDescription() {
        StringBuilder sb = new StringBuilder("");
        if (this.combination_ == PanCombinationType.A1_ONLY || this.combination_ == PanCombinationType.A2_ONLY) {
            int idx = this.combination_ == PanCombinationType.A1_ONLY ? 0 : 1;
            String lname = this.ncArrays_[idx].getLongName();
            if (lname != null) {
                sb.append(lname);
            } else {
                sb.append(this.ncArrays_[idx].getShortName());
            }
            sb.append(" (");
            if (this.scalingExponent_ != 0) {
                sb.append("10^").append(this.scalingExponent_).append(' ');
            }
            if (this.ncaUnitConverters_[idx] != null) {
                sb.append(this.targetUnitsString_);
            } else {
                String unitsStr = this.ncArrays_[idx].getUnitsString();
                if (unitsStr != null && !unitsStr.isEmpty() && !unitsStr.equals("1")) {
                    sb.append(unitsStr);
                }
            }
            sb.append(")");
            return sb.toString();
        }
        String first = this.ncArrays_[0].getLongName();
        String second = this.ncArrays_[1].getLongName();
        if (first == null) {
            first = "null";
        }
        if (second == null) {
            second = "null";
        }
        if (first.equalsIgnoreCase(second)) {
            second = first;
        }
        switch (this.combination_) {
            case A1_MINUS_A2: {
                sb.append(first).append(" - ").append(second);
                break;
            }
            case A2_MINUS_A1: {
                sb.append(second).append(" - ").append(first);
                break;
            }
            case A1_PLUS_A2: {
                sb.append(first).append(" + ").append(second);
                break;
            }
            case A1_TIMES_A2: {
                sb.append(first).append(" \u00d7 ").append(second);
                break;
            }
            case A1_OVER_A2: {
                sb.append(first).append(" / ").append(second);
                break;
            }
            case A2_OVER_A1: {
                sb.append(second).append(" / ").append(first);
                break;
            }
            case A1_MINUS_A2_PCT: {
                sb.append("(").append(first).append(" - ").append(second).append(") / ").append(second);
                break;
            }
            case A2_MINUS_A1_PCT: {
                sb.append("(").append(second).append(" - ").append(first).append(") / ").append(first);
                break;
            }
            case AVERAGE: {
                sb.append("0.5 \u00d7 ").append('(').append(first).append(" + ").append(second).append(")");
                break;
            }
            case MERGE: {
                sb.append("Combine ").append('(').append(first).append(", ").append(second).append(')');
                break;
            }
            case VECTOR: {
                throw new RuntimeException("Got VECTOR type");
            }
            case COMPARE: {
                sb.append(first).append(" vs ").append(second);
                break;
            }
            default: {
                LOGGER.trace("Switch - How did we get here? {}", (Object)this.combination_);
            }
        }
        if (this.targetUnitsString_ != null && !this.targetUnitsString_.equals(Character.valueOf('1'))) {
            sb.append(" (");
            if (this.scalingExponent_ != 0) {
                sb.append("10^").append(this.scalingExponent_).append(' ');
            }
            if (this.targetUcarUnit_ != null) {
                sb.append(this.targetUnitsString_);
            } else {
                sb.append("Bad Units?");
            }
            sb.append(")");
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDataListener(PanDataListener l) {
        Object object = this.lock_;
        synchronized (object) {
            this.listenerList_.add(PanDataListener.class, l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDataListener(PanDataListener l) {
        Object object = this.lock_;
        synchronized (object) {
            if (this.listenerList_ == null) {
                return;
            }
            this.listenerList_.remove(PanDataListener.class, l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDataListeners() {
        if (this.listenerList_ == null) {
            return;
        }
        Object object = this.lock_;
        synchronized (object) {
            for (PanDataListener listener : (PanDataListener[])this.listenerList_.getListeners(PanDataListener.class)) {
                this.removeDataListener(listener);
            }
        }
    }

    public synchronized void fireDataEvent(PanDataEvent.EType id) {
        if (this.listenerList_ == null) {
            return;
        }
        PanDataEvent e = new PanDataEvent(this, id);
        for (PanDataListener listener : (PanDataListener[])this.listenerList_.getListeners(PanDataListener.class)) {
            EventQueue.invokeLater(() -> listener.dataChanged(e));
        }
    }

    static {
        try {
            scalarUnit_ = NcUnitUtils.parse("1");
            kelvinUnit_ = NcUnitUtils.parse("K");
            meterUnit_ = NcUnitUtils.parse("m");
            pascalUnit_ = NcUnitUtils.parse("Pa");
            speedUnit_ = NcUnitUtils.parse("m/s");
            angleUnit_ = NcUnitUtils.parse("radian");
        }
        catch (Exception exc) {
            throw new RuntimeException("Could not create standard units");
        }
    }

    protected static enum CombineOperation {
        SET,
        ADD,
        SUBTRACT,
        MULTIPLY,
        DIVIDE,
        AVERAGE,
        MERGE,
        MAGNITUDE;

    }
}

