/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.action.dialog;

import gov.nasa.giss.data.nc.NcAxisType;
import gov.nasa.giss.data.nc.NcDimension;
import gov.nasa.giss.data.nc.NcVariable;
import gov.nasa.giss.panoply.ui.PanCommonComboBox;
import gov.nasa.giss.panoply.ui.PanEnumComboBox;
import gov.nasa.giss.panoply.ui.PanFrame;
import gov.nasa.giss.panoply.ui.PanLabel;
import gov.nasa.giss.panoply.ui.PanRadioButton;
import gov.nasa.giss.panoply.ui.PanStringComboBox;
import gov.nasa.giss.panoply.util.PanCreatePlotOption;
import gov.nasa.giss.panoply.util.PanPlotType;
import gov.nasa.giss.ui.QuickBox;
import gov.nasa.giss.ui.label.MultiLineLabel;
import gov.nasa.giss.util.PlatformUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import net.schmunk.ui.FGConstraint;
import net.schmunk.ui.FlexingGridLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanCreatePlotDialog
extends JDialog {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private PanRadioButton georefPlotButton_;
    private PanRadioButton common2DPlotButton_;
    private PanRadioButton linePlotButton_;
    private PanEnumComboBox geoAxesCombo_;
    private PanCommonComboBox twoDXAxisCombo_;
    private PanCommonComboBox twoDYAxisCombo_;
    private PanStringComboBox linePlotDirCombo_;
    private PanCommonComboBox linePlotAxisCombo_;
    private JButton cancelButton_;
    private JButton createButton_;
    private boolean success_;

    public PanCreatePlotDialog(PanFrame ff, NcVariable ncvar) {
        super(ff, "Create Plot", true);
        this.setResizable(false);
        this.createLayout(ncvar);
        this.attachListeners();
        Rectangle rr = ff.getBounds();
        Dimension psize = this.getContentPane().getPreferredSize();
        int x = (rr.width - psize.width) / 2;
        int y = (rr.height - psize.height) / 2;
        this.setLocation(rr.x + x, rr.y + y);
    }

    private final void createLayout(NcVariable ncvar) {
        Object dx;
        NcDimension[] dims = ncvar.getDimensions();
        ArrayList<DimensionWrapper> dwrappers = new ArrayList<DimensionWrapper>();
        for (int i = 0; i < dims.length; ++i) {
            if (dims[i].getLength() <= 1) continue;
            dwrappers.add(new DimensionWrapper(i, dims[i]));
        }
        Collections.sort(dwrappers);
        MultiLineLabel message = new MultiLineLabel("More than one type of plot can be created from the variable '" + ncvar.getName() + "'. What type would you like to create?", 100, 2);
        int maxWidth = message.getPreferredSize().width;
        QuickBox georefBox = null;
        QuickBox common2DBox = null;
        QuickBox lineplotBox = null;
        if (ncvar.isGriddable2DGeo()) {
            this.georefPlotButton_ = PanRadioButton.create("Create a georeferenced ", true);
            this.geoAxesCombo_ = PanEnumComboBox.create(PanPlotType.class);
            this.geoAxesCombo_.removeAllItems();
            if (ncvar.hasAxesOfType(NcAxisType.TIME, NcAxisType.LAT)) {
                this.geoAxesCombo_.addItem(PanPlotType.LAT_TIME);
            }
            if (ncvar.hasAxesOfType(NcAxisType.LAT, NcAxisType.VERT)) {
                this.geoAxesCombo_.addItem(PanPlotType.LAT_VERT);
            }
            if (ncvar.hasAxesOfType(NcAxisType.LON, NcAxisType.LAT)) {
                this.geoAxesCombo_.addItem(PanPlotType.LON_LAT);
                this.geoAxesCombo_.setSelectedItem(PanPlotType.LON_LAT);
            }
            if (ncvar.hasAxesOfType(NcAxisType.LON, NcAxisType.TIME)) {
                this.geoAxesCombo_.addItem(PanPlotType.LON_TIME);
            }
            if (ncvar.hasAxesOfType(NcAxisType.LON, NcAxisType.VERT)) {
                this.geoAxesCombo_.addItem(PanPlotType.LON_VERT);
            }
            if (ncvar.hasAxesOfType(NcAxisType.TIME, NcAxisType.LAT)) {
                this.geoAxesCombo_.addItem(PanPlotType.TIME_LAT);
            }
            if (ncvar.hasAxesOfType(NcAxisType.TIME, NcAxisType.VERT)) {
                this.geoAxesCombo_.addItem(PanPlotType.TIME_VERT);
            }
            georefBox = QuickBox.createLeftBox(this.georefPlotButton_, this.geoAxesCombo_, PanLabel.create("plot"));
            maxWidth = Math.max(maxWidth, georefBox.getPreferredSize().width);
        } else if (ncvar.isTrajectory()) {
            this.georefPlotButton_ = PanRadioButton.create("Create a georeferenced ", true);
            this.geoAxesCombo_ = PanEnumComboBox.create(PanPlotType.class);
            this.geoAxesCombo_.removeAllItems();
            this.geoAxesCombo_.addItem(PanPlotType.LL_TRAJ);
            georefBox = QuickBox.createLeftBox(this.georefPlotButton_, this.geoAxesCombo_, PanLabel.create("plot"));
            maxWidth = Math.max(maxWidth, georefBox.getPreferredSize().width);
        }
        if (ncvar.isGriddable2D()) {
            this.common2DPlotButton_ = PanRadioButton.create("Create a 2D plot using", true);
            this.twoDXAxisCombo_ = PanCommonComboBox.create();
            this.twoDYAxisCombo_ = PanCommonComboBox.create();
            for (DimensionWrapper dwrapper : dwrappers) {
                this.twoDXAxisCombo_.addItem(dwrapper);
                this.twoDYAxisCombo_.addItem(dwrapper);
            }
            this.twoDXAxisCombo_.setSelectedIndex(0);
            this.twoDYAxisCombo_.setSelectedIndex(1);
            dx = this.twoDXAxisCombo_.getPreferredSize();
            Dimension dy = this.twoDYAxisCombo_.getPreferredSize();
            if (((Dimension)dx).width > 180) {
                ((Dimension)dx).width = 172;
                this.twoDXAxisCombo_.setPreferredSize((Dimension)dx);
                this.twoDXAxisCombo_.setMaximumSize((Dimension)dx);
                this.twoDXAxisCombo_.setMinimumSize((Dimension)dx);
            }
            if (dy.width > 180) {
                dy.width = 172;
                this.twoDYAxisCombo_.setPreferredSize((Dimension)dx);
                this.twoDYAxisCombo_.setMaximumSize((Dimension)dx);
                this.twoDYAxisCombo_.setMinimumSize((Dimension)dx);
            }
            common2DBox = QuickBox.createLeftBox(this.common2DPlotButton_, this.twoDXAxisCombo_, PanLabel.create("for X axis and"), this.twoDYAxisCombo_, PanLabel.create("for Y axis"));
            maxWidth = Math.max(maxWidth, common2DBox.getPreferredSize().width);
        }
        this.linePlotButton_ = PanRadioButton.create("Create a", false);
        this.linePlotDirCombo_ = PanStringComboBox.create();
        this.linePlotDirCombo_.addItem("horizontal");
        this.linePlotDirCombo_.addItem("vertical");
        this.linePlotAxisCombo_ = PanCommonComboBox.create();
        for (DimensionWrapper dwrapper : dwrappers) {
            this.linePlotAxisCombo_.addItem(dwrapper);
        }
        dx = this.linePlotAxisCombo_.getPreferredSize();
        if (((Dimension)dx).width > 180) {
            ((Dimension)dx).width = 172;
            this.linePlotAxisCombo_.setPreferredSize((Dimension)dx);
            this.linePlotAxisCombo_.setMaximumSize((Dimension)dx);
            this.linePlotAxisCombo_.setMinimumSize((Dimension)dx);
        }
        lineplotBox = QuickBox.createLeftBox(this.linePlotButton_, this.linePlotDirCombo_, PanLabel.create(" line plot along "), this.linePlotAxisCombo_, PanLabel.create(" axis"));
        maxWidth = Math.max(maxWidth, lineplotBox.getPreferredSize().width);
        ButtonGroup plotChoices = new ButtonGroup();
        if (this.linePlotButton_ != null) {
            plotChoices.add(this.linePlotButton_);
            this.linePlotButton_.setSelected(true);
        }
        if (this.common2DPlotButton_ != null) {
            plotChoices.add(this.common2DPlotButton_);
            this.common2DPlotButton_.setSelected(true);
        }
        if (this.georefPlotButton_ != null) {
            plotChoices.add(this.georefPlotButton_);
            this.georefPlotButton_.setSelected(true);
        }
        this.cancelButton_ = new JButton("Cancel");
        this.createButton_ = new JButton("Create");
        QuickBox buttonBox = PlatformUtils.isMacintosh() ? QuickBox.createRightBox(this.cancelButton_, this.createButton_) : QuickBox.createRightBox(this.createButton_, this.cancelButton_);
        JPanel contentPanel = new JPanel();
        FlexingGridLayout fgl = new FlexingGridLayout(2, 10, 0, 2);
        contentPanel.setLayout(fgl);
        contentPanel.setBorder(BorderFactory.createEmptyBorder(16, 16, 16, 16));
        int row = 0;
        contentPanel.add((Component)message, new FGConstraint(0, row));
        ++row;
        ++row;
        if (georefBox != null) {
            contentPanel.add((Component)georefBox, new FGConstraint(0, ++row));
        }
        if (common2DBox != null) {
            contentPanel.add((Component)common2DBox, new FGConstraint(0, ++row));
        }
        if (lineplotBox != null) {
            contentPanel.add((Component)lineplotBox, new FGConstraint(0, ++row));
        }
        ++row;
        ++row;
        contentPanel.add((Component)buttonBox, new FGConstraint(0, ++row, 1.0));
        this.getContentPane().add(contentPanel);
        this.getRootPane().setDefaultButton(this.createButton_);
        this.pack();
    }

    @Override
    public void setVisible(boolean vis) {
        if (vis) {
            EventQueue.invokeLater(() -> this.createButton_.requestFocusInWindow());
        }
        super.setVisible(vis);
    }

    private final void attachListeners() {
        ItemListener il;
        if (this.georefPlotButton_ != null) {
            this.geoAxesCombo_.addItemListener(e -> {
                if (e.getStateChange() != 1) {
                    return;
                }
                this.georefPlotButton_.setSelected(true);
            });
        }
        if (this.common2DPlotButton_ != null) {
            il = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() != 1) {
                        return;
                    }
                    PanCreatePlotDialog.this.common2DPlotButton_.setSelected(true);
                    int x = PanCreatePlotDialog.this.twoDXAxisCombo_.getSelectedIndex();
                    int y = PanCreatePlotDialog.this.twoDYAxisCombo_.getSelectedIndex();
                    if (x == y) {
                        Object source = e.getSource();
                        if (source == PanCreatePlotDialog.this.twoDXAxisCombo_) {
                            if (y == 0) {
                                PanCreatePlotDialog.this.twoDYAxisCombo_.setSelectedIndex(1);
                            } else {
                                PanCreatePlotDialog.this.twoDYAxisCombo_.setSelectedIndex(0);
                            }
                        } else if (x == 0) {
                            PanCreatePlotDialog.this.twoDXAxisCombo_.setSelectedIndex(1);
                        } else {
                            PanCreatePlotDialog.this.twoDXAxisCombo_.setSelectedIndex(0);
                        }
                    }
                }
            };
            this.twoDXAxisCombo_.addItemListener(il);
            this.twoDYAxisCombo_.addItemListener(il);
        }
        if (this.linePlotButton_ != null) {
            il = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() != 1) {
                        return;
                    }
                    PanCreatePlotDialog.this.linePlotButton_.setSelected(true);
                }
            };
            this.linePlotDirCombo_.addItemListener(il);
            this.linePlotAxisCombo_.addItemListener(il);
        }
        this.createButton_.addActionListener(e -> {
            this.success_ = true;
            this.setVisible(false);
        });
        this.cancelButton_.addActionListener(e -> this.setVisible(false));
    }

    public boolean isSuccessful() {
        return this.success_;
    }

    public Hashtable<PanCreatePlotOption, Object> getOptions() {
        Hashtable<PanCreatePlotOption, Object> opts = new Hashtable<PanCreatePlotOption, Object>();
        if (this.georefPlotButton_ != null && this.georefPlotButton_.isSelected()) {
            opts.put(PanCreatePlotOption.PLOT_TYPE, this.geoAxesCombo_.getSelectedItem());
        } else if (this.common2DPlotButton_ != null && this.common2DPlotButton_.isSelected()) {
            DimensionWrapper dw1 = (DimensionWrapper)this.twoDXAxisCombo_.getSelectedItem();
            DimensionWrapper dw2 = (DimensionWrapper)this.twoDYAxisCombo_.getSelectedItem();
            int idx1 = dw1.getIndex();
            int idx2 = dw2.getIndex();
            opts.put(PanCreatePlotOption.PLOT_TYPE, PanPlotType.GENERAL_2D);
            opts.put(PanCreatePlotOption.AXIS_INFO_1, idx1);
            opts.put(PanCreatePlotOption.AXIS_INFO_2, idx2);
        } else if (this.linePlotButton_ != null && this.linePlotButton_.isSelected()) {
            DimensionWrapper dw = (DimensionWrapper)this.linePlotAxisCombo_.getSelectedItem();
            int idx = dw.getIndex();
            if (((String)this.linePlotDirCombo_.getSelectedItem()).equals("horizontal")) {
                opts.put(PanCreatePlotOption.PLOT_TYPE, PanPlotType.HORZ_LINE);
                opts.put(PanCreatePlotOption.AXIS_INFO_1, idx);
            } else {
                opts.put(PanCreatePlotOption.PLOT_TYPE, PanPlotType.VERT_LINE);
                opts.put(PanCreatePlotOption.AXIS_INFO_1, idx);
            }
        }
        return opts;
    }

    class DimensionWrapper
    implements Comparable<DimensionWrapper> {
        int index_;
        NcDimension dimension_;
        String name_;

        DimensionWrapper(int index, NcDimension dimension) {
            this.index_ = index;
            this.dimension_ = dimension;
            this.name_ = this.dimension_.getName();
            if (this.name_ == null || this.name_.isEmpty()) {
                this.name_ = index + 1 + " / " + this.dimension_.getLength();
            }
        }

        int getIndex() {
            return this.index_;
        }

        NcDimension getDimension() {
            return this.dimension_;
        }

        public String toString() {
            return this.name_;
        }

        @Override
        public int compareTo(DimensionWrapper o) {
            return this.name_.compareTo(o.toString());
        }
    }
}

