/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.action;

import gov.nasa.giss.data.nc.NcVariable;
import gov.nasa.giss.panoply.action.task.PanExportCsvTask;
import gov.nasa.giss.panoply.io.PanFileUtils;
import gov.nasa.giss.panoply.prefs.PanPreferences;
import gov.nasa.giss.panoply.sources.PanSourcesFrame;
import gov.nasa.giss.panoply.util.PanProperties;
import gov.nasa.giss.ui.treetable.TreeTableNode;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;

public class PanExportCsvAction
extends AbstractAction {
    private static final String CSV_EXT = "csv";
    private static final String ACTION_NAME = PanProperties.MENU_PROPS.getString("export-csv");
    private static final PanPreferences PREFS = PanPreferences.getSharedInstance();
    private final PanSourcesFrame parent_;

    public PanExportCsvAction(PanSourcesFrame parent) {
        super(ACTION_NAME);
        this.parent_ = parent;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object[] options;
        long mega;
        String message;
        int choice;
        TreeTableNode node = this.parent_.getSelectedNode();
        if (!(node instanceof NcVariable)) {
            return;
        }
        NcVariable ncvar = (NcVariable)node;
        long count = ncvar.getElementCount();
        if (PREFS.getBoolean("files:save.export.warning") && count > 20000000L && (choice = JOptionPane.showOptionDialog(this.parent_, message = (mega = count / 1000L / 1000L) > 100L ? "The variable includes " + mega + " million elements. Exporting as\nCSV could take a very long time and result in a multi-gigabyte\nfile. Shall I continue?" : "The variable includes " + mega + " million elements. Exporting as\nCSV could take some time and result in a very large file.\nShall I continue?", "Confirm", 0, 3, null, options = new String[]{"Okay", "Cancel"}, options[0])) != 0) {
            return;
        }
        String fnameRoot = ncvar.getName();
        File file = PanFileUtils.showSingleTypeSaveFileChooser(this.parent_, "Export data as\u2026", CSV_EXT, fnameRoot, CSV_EXT);
        if (file == null) {
            return;
        }
        PanExportCsvTask task = new PanExportCsvTask(this.parent_, ncvar, file);
        this.parent_.addTask(task);
    }
}

