/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.shapefile;

import gov.nasa.giss.map.shapefile.ShapeException;
import gov.nasa.giss.map.shapefile.ShapeRecord;
import gov.nasa.giss.map.shapefile.ShapeRecordType;
import gov.nasa.giss.map.shapefile.ShapeUtils;
import java.awt.geom.Point2D;

public class ShapeRecordPoint
extends ShapeRecord {
    private Point2D.Double pt_;
    private Double m_;
    private Double z_;

    @Override
    void readFromBuffer(byte[] buffer) {
        this.recordType_ = ShapeUtils.shapeTypeFromBytes(buffer, 0);
        if (!this.isPoint()) {
            throw new ShapeException("Shape type is not Point.");
        }
        this.numParts_ = 1;
        this.numPoints_ = 1;
        double x = ShapeUtils.doubleFromLittleBytes(ShapeUtils.arraySection(buffer, 4, 8));
        double y = ShapeUtils.doubleFromLittleBytes(ShapeUtils.arraySection(buffer, 12, 8));
        this.pt_ = new Point2D.Double(x, y);
        this.left_ = x;
        this.top_ = y;
        this.right_ = x;
        this.bottom_ = y;
        if (this.recordType_ == ShapeRecordType.POINT) {
            return;
        }
        if (this.recordType_ == ShapeRecordType.POINT_M) {
            this.m_ = ShapeUtils.doubleFromLittleBytes(ShapeUtils.arraySection(buffer, 20, 8));
        } else if (this.recordType_ == ShapeRecordType.POINT_Z) {
            this.z_ = ShapeUtils.doubleFromLittleBytes(ShapeUtils.arraySection(buffer, 20, 8));
            this.m_ = ShapeUtils.doubleFromLittleBytes(ShapeUtils.arraySection(buffer, 28, 8));
        }
    }

    @Override
    public Point2D.Double[] getPoints(int partNum) {
        if (partNum != 0) {
            throw new IllegalArgumentException("Part number out of range.");
        }
        return new Point2D.Double[]{this.pt_};
    }

    public Double getM() {
        return this.m_;
    }

    public Double getZ() {
        return this.z_;
    }
}

