/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj.ui;

import gov.nasa.giss.map.proj.ProjIntegerParameter;
import gov.nasa.giss.map.proj.ui.ProjParamComponent;
import gov.nasa.giss.ui.spinner.IntSpinner;
import java.util.Objects;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;

public class ProjIntegerComponent
extends ProjParamComponent {
    private static final long serialVersionUID = 181L;
    private ProjIntegerParameter parameter_;
    private IntSpinner spinner_;

    public ProjIntegerComponent(ProjIntegerParameter parameter) {
        this(parameter, parameter.getDefault());
    }

    public ProjIntegerComponent(ProjIntegerParameter parameter, int value) {
        this(parameter, value, false);
    }

    public ProjIntegerComponent(ProjIntegerParameter parameter, int value, boolean padded) {
        super(parameter);
        this.parameter_ = parameter;
        this.createLayout(value, padded);
        this.attachListeners();
    }

    private void createLayout(int value, boolean padded) {
        this.setLayout(new BoxLayout(this, 0));
        this.setOpaque(false);
        JLabel nLabel = new JLabel(this.parameter_.getLabel() + ": ");
        nLabel.setOpaque(false);
        this.add(nLabel);
        int min = this.parameter_.getMinimum();
        int max = this.parameter_.getMaximum();
        this.spinner_ = new IntSpinner(value, min, max, 1);
        this.add(this.spinner_);
        String punits = this.parameter_.getUnits();
        if (punits != null && punits.length() > 0) {
            JLabel uLabel = new JLabel(punits);
            uLabel.setOpaque(false);
            this.add(uLabel);
        }
        if (padded) {
            this.add(Box.createHorizontalGlue());
        }
    }

    private void attachListeners() {
        this.spinner_.addChangeListener(e -> {
            try {
                this.spinner_.commitEdit();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.handleParam();
        });
    }

    @Override
    public void reset() {
        this.spinner_.setValue(this.parameter_.getDefault());
        this.handleParam();
    }

    @Override
    public String getStringValue() {
        return this.getValue().toString();
    }

    public int getIntegerValue() {
        return this.parameter_.getValue();
    }

    public int getMinValue() {
        return this.parameter_.getMinimum();
    }

    public int getMaxValue() {
        return this.parameter_.getMaximum();
    }

    @Override
    public Object getValue() {
        return this.parameter_.getValue();
    }

    @Override
    public void setValue(String sval) {
        Objects.requireNonNull(sval, "Value must not be null.");
        try {
            this.setValue(Integer.parseInt(sval));
        }
        catch (Exception exc) {
            throw new IllegalArgumentException("Value is not an Integer: " + sval);
        }
    }

    public void setValue(int ival) {
        this.spinner_.setValue(ival);
        this.parameter_.setValue(ival);
        this.spinner_.repaint();
        super.fireValueChanged();
    }

    @Override
    protected void handleParam() {
        int oldval;
        int newval = this.spinner_.getIntValue();
        if (newval == (oldval = this.parameter_.getValue())) {
            return;
        }
        this.parameter_.setValue(newval);
        super.fireValueChanged();
    }
}

